/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.search;

import org.apache.lucene1.search.ScoreDoc;

public interface ScoreDocComparator {
    public static final ScoreDocComparator RELEVANCE = new ScoreDocComparator(){

        public int compare(ScoreDoc i, ScoreDoc j) {
            if (i.score > j.score) {
                return -1;
            }
            if (i.score < j.score) {
                return 1;
            }
            return 0;
        }

        public Comparable sortValue(ScoreDoc i) {
            return new Float(i.score);
        }

        public int sortType() {
            return 0;
        }
    };
    public static final ScoreDocComparator INDEXORDER = new ScoreDocComparator(){

        public int compare(ScoreDoc i, ScoreDoc j) {
            if (i.doc < j.doc) {
                return -1;
            }
            if (i.doc > j.doc) {
                return 1;
            }
            return 0;
        }

        public Comparable sortValue(ScoreDoc i) {
            return new Integer(i.doc);
        }

        public int sortType() {
            return 1;
        }
    };

    public int compare(ScoreDoc var1, ScoreDoc var2);

    public Comparable sortValue(ScoreDoc var1);

    public int sortType();
}

