/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.search;

import java.io.IOException;
import org.apache.lucene1.index.IndexReader;
import org.apache.lucene1.search.FieldCache;
import org.apache.lucene1.search.ScoreDoc;
import org.apache.lucene1.search.ScoreDocComparator;
import org.apache.lucene1.search.SortComparatorSource;

public abstract class SortComparator
implements SortComparatorSource {
    public ScoreDocComparator newComparator(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final Comparable[] cachedValues = FieldCache.DEFAULT.getCustom(reader, field, this);
        return new ScoreDocComparator(){

            public int compare(ScoreDoc i, ScoreDoc j) {
                return cachedValues[i.doc].compareTo(cachedValues[j.doc]);
            }

            public Comparable sortValue(ScoreDoc i) {
                return cachedValues[i.doc];
            }

            public int sortType() {
                return 9;
            }
        };
    }

    protected abstract Comparable getComparable(String var1);
}

