/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene1.index.IndexReader;
import org.apache.lucene1.search.spans.SpanNearQuery;
import org.apache.lucene1.search.spans.SpanQuery;
import org.apache.lucene1.search.spans.Spans;
import org.apache.lucene1.util.PriorityQueue;

class NearSpans
implements Spans {
    private SpanNearQuery query;
    private List ordered = new ArrayList();
    private int slop;
    private boolean inOrder;
    private SpansCell first;
    private SpansCell last;
    private int totalLength;
    private CellQueue queue;
    private SpansCell max;
    private boolean more = true;
    private boolean firstTime = true;

    public NearSpans(SpanNearQuery query, IndexReader reader) throws IOException {
        this.query = query;
        this.slop = query.getSlop();
        this.inOrder = query.isInOrder();
        SpanQuery[] clauses = query.getClauses();
        this.queue = new CellQueue(clauses.length);
        for (int i = 0; i < clauses.length; ++i) {
            SpansCell cell = new SpansCell(clauses[i].getSpans(reader), i);
            this.ordered.add(cell);
        }
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.initList(true);
            this.listToQueue();
            this.firstTime = false;
        } else if (this.more) {
            this.more = this.min().next();
            if (this.more) {
                this.queue.adjustTop();
            }
        }
        while (this.more) {
            boolean queueStale = false;
            if (this.min().doc() != this.max.doc()) {
                this.queueToList();
                queueStale = true;
            }
            while (this.more && this.first.doc() < this.last.doc()) {
                this.more = this.first.skipTo(this.last.doc());
                this.firstToLast();
                queueStale = true;
            }
            if (!this.more) {
                return false;
            }
            if (queueStale) {
                this.listToQueue();
                queueStale = false;
            }
            if (this.atMatch()) {
                return true;
            }
            if (this.inOrder && this.checkSlop()) {
                this.more = this.firstNonOrderedNextToPartialList();
                if (!this.more) continue;
                this.partialListToQueue();
                continue;
            }
            this.more = this.min().next();
            if (!this.more) continue;
            this.queue.adjustTop();
        }
        return false;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.firstTime) {
            this.initList(false);
            SpansCell cell = this.first;
            while (this.more && cell != null) {
                this.more = cell.skipTo(target);
                cell = cell.next;
            }
            if (this.more) {
                this.listToQueue();
            }
            this.firstTime = false;
        } else {
            while (this.more && this.min().doc() < target) {
                this.more = this.min().skipTo(target);
                if (!this.more) continue;
                this.queue.adjustTop();
            }
        }
        if (this.more) {
            if (this.atMatch()) {
                return true;
            }
            return this.next();
        }
        return false;
    }

    private SpansCell min() {
        return (SpansCell)this.queue.top();
    }

    public int doc() {
        return this.min().doc();
    }

    public int start() {
        return this.min().start();
    }

    public int end() {
        return this.max.end();
    }

    public String toString() {
        return "spans(" + this.query.toString() + ")@" + (this.firstTime ? "START" : (this.more ? this.doc() + ":" + this.start() + "-" + this.end() : "END"));
    }

    private void initList(boolean next) throws IOException {
        for (int i = 0; this.more && i < this.ordered.size(); ++i) {
            SpansCell cell = (SpansCell)this.ordered.get(i);
            if (next) {
                this.more = cell.next();
            }
            if (!this.more) continue;
            this.addToList(cell);
        }
    }

    private void addToList(SpansCell cell) {
        if (this.last != null) {
            this.last.next = cell;
        } else {
            this.first = cell;
        }
        this.last = cell;
        cell.next = null;
    }

    private void firstToLast() {
        this.last.next = this.first;
        this.last = this.first;
        this.first = this.first.next;
        this.last.next = null;
    }

    private void queueToList() {
        this.first = null;
        this.last = null;
        while (this.queue.top() != null) {
            this.addToList((SpansCell)this.queue.pop());
        }
    }

    private boolean firstNonOrderedNextToPartialList() throws IOException {
        this.first = null;
        this.last = null;
        int orderedIndex = 0;
        while (this.queue.top() != null) {
            SpansCell cell = (SpansCell)this.queue.pop();
            this.addToList(cell);
            if (cell.index == orderedIndex) {
                ++orderedIndex;
                continue;
            }
            return cell.next();
        }
        throw new RuntimeException("Unexpected: ordered");
    }

    private void listToQueue() {
        this.queue.clear();
        this.partialListToQueue();
    }

    private void partialListToQueue() {
        SpansCell cell = this.first;
        while (cell != null) {
            this.queue.put(cell);
            cell = cell.next;
        }
    }

    private boolean atMatch() {
        return this.min().doc() == this.max.doc() && this.checkSlop() && (!this.inOrder || this.matchIsOrdered());
    }

    private boolean checkSlop() {
        int matchLength = this.max.end() - this.min().start();
        return matchLength - this.totalLength <= this.slop;
    }

    private boolean matchIsOrdered() {
        int lastStart = -1;
        for (int i = 0; i < this.ordered.size(); ++i) {
            int start = ((SpansCell)this.ordered.get(i)).start();
            if (start <= lastStart) {
                return false;
            }
            lastStart = start;
        }
        return true;
    }

    private class SpansCell
    implements Spans {
        private Spans spans;
        private SpansCell next;
        private int length = -1;
        private int index;

        public SpansCell(Spans spans, int index) {
            this.spans = spans;
            this.index = index;
        }

        public boolean next() throws IOException {
            boolean more;
            if (this.length != -1) {
                NearSpans.this.totalLength -= this.length;
            }
            if (more = this.spans.next()) {
                this.length = this.end() - this.start();
                NearSpans.this.totalLength += this.length;
                if (NearSpans.this.max == null || this.doc() > NearSpans.this.max.doc() || this.doc() == NearSpans.this.max.doc() && this.end() > NearSpans.this.max.end()) {
                    NearSpans.this.max = this;
                }
            }
            return more;
        }

        public boolean skipTo(int target) throws IOException {
            boolean more;
            if (this.length != -1) {
                NearSpans.this.totalLength -= this.length;
            }
            if (more = this.spans.skipTo(target)) {
                this.length = this.end() - this.start();
                NearSpans.this.totalLength += this.length;
                if (NearSpans.this.max == null || this.doc() > NearSpans.this.max.doc() || this.doc() == NearSpans.this.max.doc() && this.end() > NearSpans.this.max.end()) {
                    NearSpans.this.max = this;
                }
            }
            return more;
        }

        public int doc() {
            return this.spans.doc();
        }

        public int start() {
            return this.spans.start();
        }

        public int end() {
            return this.spans.end();
        }

        public String toString() {
            return this.spans.toString() + "#" + this.index;
        }
    }

    private class CellQueue
    extends PriorityQueue {
        public CellQueue(int size) {
            this.initialize(size);
        }

        protected final boolean lessThan(Object o1, Object o2) {
            SpansCell spans1 = (SpansCell)o1;
            SpansCell spans2 = (SpansCell)o2;
            if (spans1.doc() == spans2.doc()) {
                if (spans1.start() == spans2.start()) {
                    if (spans1.end() == spans2.end()) {
                        return spans1.index > spans2.index;
                    }
                    return spans1.end() < spans2.end();
                }
                return spans1.start() < spans2.start();
            }
            return spans1.doc() < spans2.doc();
        }
    }
}

