/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene1.index.IndexReader;
import org.apache.lucene1.search.spans.NearSpans;
import org.apache.lucene1.search.spans.SpanOrQuery;
import org.apache.lucene1.search.spans.SpanQuery;
import org.apache.lucene1.search.spans.Spans;

public class SpanNearQuery
extends SpanQuery {
    private List clauses;
    private int slop;
    private boolean inOrder;
    private String field;

    public SpanNearQuery(SpanQuery[] clauses, int slop, boolean inOrder) {
        this.clauses = new ArrayList(clauses.length);
        for (int i = 0; i < clauses.length; ++i) {
            SpanQuery clause = clauses[i];
            if (i == 0) {
                this.field = clause.getField();
            } else if (!clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(clause);
        }
        this.slop = slop;
        this.inOrder = inOrder;
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    public int getSlop() {
        return this.slop;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public String getField() {
        return this.field;
    }

    public Collection getTerms() {
        ArrayList terms = new ArrayList();
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = (SpanQuery)i.next();
            terms.addAll(clause.getTerms());
        }
        return terms;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanNear([");
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = (SpanQuery)i.next();
            buffer.append(clause.toString(field));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("], ");
        buffer.append(this.slop);
        buffer.append(", ");
        buffer.append(this.inOrder);
        buffer.append(")");
        return buffer.toString();
    }

    public Spans getSpans(IndexReader reader) throws IOException {
        if (this.clauses.size() == 0) {
            return new SpanOrQuery(this.getClauses()).getSpans(reader);
        }
        if (this.clauses.size() == 1) {
            return ((SpanQuery)this.clauses.get(0)).getSpans(reader);
        }
        return new NearSpans(this, reader);
    }
}

