/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.store;

import java.io.IOException;
import org.apache.lucene1.store.OutputStream;
import org.apache.lucene1.store.RAMFile;

public class RAMOutputStream
extends OutputStream {
    private RAMFile file;
    private int pointer = 0;

    public RAMOutputStream() {
        this(new RAMFile());
    }

    RAMOutputStream(RAMFile f) {
        this.file = f;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.flush();
        long end = this.file.length;
        long pos = 0L;
        int buffer = 0;
        while (pos < end) {
            int length = 1024;
            long nextPos = pos + (long)length;
            if (nextPos > end) {
                length = (int)(end - pos);
            }
            out.writeBytes((byte[])this.file.buffers.elementAt(buffer++), length);
            pos = nextPos;
        }
    }

    public void reset() {
        try {
            this.seek(0L);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        this.file.length = 0L;
    }

    public void flushBuffer(byte[] src, int len) {
        int bytesToCopy;
        int bufferNumber = this.pointer / 1024;
        int bufferOffset = this.pointer % 1024;
        int bytesInBuffer = 1024 - bufferOffset;
        int n = bytesToCopy = bytesInBuffer >= len ? len : bytesInBuffer;
        if (bufferNumber == this.file.buffers.size()) {
            this.file.buffers.addElement(new byte[1024]);
        }
        byte[] buffer = (byte[])this.file.buffers.elementAt(bufferNumber);
        System.arraycopy(src, 0, buffer, bufferOffset, bytesToCopy);
        if (bytesToCopy < len) {
            int srcOffset = bytesToCopy;
            bytesToCopy = len - bytesToCopy;
            if (++bufferNumber == this.file.buffers.size()) {
                this.file.buffers.addElement(new byte[1024]);
            }
            buffer = (byte[])this.file.buffers.elementAt(bufferNumber);
            System.arraycopy(src, srcOffset, buffer, 0, bytesToCopy);
        }
        this.pointer += len;
        if ((long)this.pointer > this.file.length) {
            this.file.length = this.pointer;
        }
        this.file.lastModified = System.currentTimeMillis();
    }

    public void close() throws IOException {
        super.close();
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.pointer = (int)pos;
    }

    public long length() {
        return this.file.length;
    }
}

