/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.poi1.hpsf.DocumentSummaryInformation;
import org.apache.poi1.hpsf.HPSFException;
import org.apache.poi1.hpsf.MutablePropertySet;
import org.apache.poi1.hpsf.PropertySet;
import org.apache.poi1.hpsf.PropertySetFactory;
import org.apache.poi1.hpsf.SummaryInformation;
import org.apache.poi1.hpsf.WritingNotSupportedException;
import org.apache.poi1.poifs.filesystem.DocumentInputStream;
import org.apache.poi1.poifs.filesystem.POIFSFileSystem;
import org.apache.poi1.util.POILogFactory;
import org.apache.poi1.util.POILogger;

public abstract class POIDocument {
    protected SummaryInformation sInf;
    protected DocumentSummaryInformation dsInf;
    protected POIFSFileSystem filesystem;
    protected POILogger logger = POILogFactory.getLogger(this.getClass());

    public DocumentSummaryInformation getDocumentSummaryInformation() {
        return this.dsInf;
    }

    public SummaryInformation getSummaryInformation() {
        return this.sInf;
    }

    protected void readProperties() {
        this.dsInf = (DocumentSummaryInformation)this.getPropertySet("\u0005DocumentSummaryInformation");
        this.sInf = (SummaryInformation)this.getPropertySet("\u0005SummaryInformation");
    }

    protected PropertySet getPropertySet(String setName) {
        DocumentInputStream dis;
        try {
            dis = this.filesystem.createDocumentInputStream(setName);
        }
        catch (IOException ie) {
            System.err.println("Error getting property set with name " + setName + "\n" + ie);
            return null;
        }
        try {
            PropertySet set = PropertySetFactory.create(dis);
            return set;
        }
        catch (IOException ie) {
            System.err.println("Error creating property set with name " + setName + "\n" + ie);
        }
        catch (HPSFException he) {
            System.err.println("Error creating property set with name " + setName + "\n" + he);
        }
        return null;
    }

    protected void writeProperties(POIFSFileSystem outFS) throws IOException {
        if (this.sInf != null) {
            this.writePropertySet("\u0005SummaryInformation", this.sInf, outFS);
        }
        if (this.dsInf != null) {
            this.writePropertySet("\u0005DocumentSummaryInformation", this.dsInf, outFS);
        }
    }

    protected void writePropertySet(String name, PropertySet set, POIFSFileSystem outFS) throws IOException {
        try {
            MutablePropertySet mSet = new MutablePropertySet(set);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            mSet.write(bOut);
            byte[] data = bOut.toByteArray();
            ByteArrayInputStream bIn = new ByteArrayInputStream(data);
            outFS.createDocument(bIn, name);
            this.logger.log(3, "Wrote property set " + name + " of size " + data.length);
        }
        catch (WritingNotSupportedException wnse) {
            System.err.println("Couldn't write property set with name " + name + " as not supported by HPSF yet");
        }
    }
}

