/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.HexDump;
import org.apache.poi1.util.LittleEndian;

public class AxisLineFormatRecord
extends Record {
    public static final short sid = 4129;
    private short field_1_axisType;
    public static final short AXIS_TYPE_AXIS_LINE = 0;
    public static final short AXIS_TYPE_MAJOR_GRID_LINE = 1;
    public static final short AXIS_TYPE_MINOR_GRID_LINE = 2;
    public static final short AXIS_TYPE_WALLS_OR_FLOOR = 3;

    public AxisLineFormatRecord() {
    }

    public AxisLineFormatRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4129) {
            throw new RecordFormatException("Not a AxisLineFormat record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_axisType = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AXISLINEFORMAT]\n");
        buffer.append("    .axisType             = ").append("0x").append(HexDump.toHex(this.getAxisType())).append(" (").append(this.getAxisType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/AXISLINEFORMAT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4129);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_axisType);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4129;
    }

    public Object clone() {
        AxisLineFormatRecord rec = new AxisLineFormatRecord();
        rec.field_1_axisType = this.field_1_axisType;
        return rec;
    }

    public short getAxisType() {
        return this.field_1_axisType;
    }

    public void setAxisType(short field_1_axisType) {
        this.field_1_axisType = field_1_axisType;
    }
}

