/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.LittleEndian;

public class RefModeRecord
extends Record {
    public static final short sid = 15;
    public static final short USE_A1_MODE = 1;
    public static final short USE_R1C1_MODE = 0;
    private short field_1_mode;

    public RefModeRecord() {
    }

    public RefModeRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 15) {
            throw new RecordFormatException("NOT An RefMode RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_mode = in.readShort();
    }

    public void setMode(short mode) {
        this.field_1_mode = mode;
    }

    public short getMode() {
        return this.field_1_mode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[REFMODE]\n");
        buffer.append("    .mode           = ").append(Integer.toHexString(this.getMode())).append("\n");
        buffer.append("[/REFMODE]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)15);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getMode());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 15;
    }

    public Object clone() {
        RefModeRecord rec = new RefModeRecord();
        rec.field_1_mode = this.field_1_mode;
        return rec;
    }
}

