/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.LittleEndian;

public class RefreshAllRecord
extends Record {
    public static final short sid = 439;
    private short field_1_refreshall;

    public RefreshAllRecord() {
    }

    public RefreshAllRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 439) {
            throw new RecordFormatException("NOT A REFRESHALL RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_refreshall = in.readShort();
    }

    public void setRefreshAll(boolean refreshall) {
        this.field_1_refreshall = refreshall ? (short)1 : 0;
    }

    public boolean getRefreshAll() {
        return this.field_1_refreshall == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[REFRESHALL]\n");
        buffer.append("    .refreshall      = ").append(this.getRefreshAll()).append("\n");
        buffer.append("[/REFRESHALL]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)439);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_refreshall);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 439;
    }
}

