/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.LittleEndian;

public class SeriesListRecord
extends Record {
    public static final short sid = 4118;
    private short[] field_1_seriesNumbers;

    public SeriesListRecord() {
    }

    public SeriesListRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4118) {
            throw new RecordFormatException("Not a SeriesList record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_seriesNumbers = in.readShortArray();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SERIESLIST]\n");
        buffer.append("    .seriesNumbers        = ").append(" (").append(this.getSeriesNumbers()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/SERIESLIST]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4118);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShortArray(data, 4 + offset + pos, this.field_1_seriesNumbers);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.field_1_seriesNumbers.length * 2 + 2;
    }

    public short getSid() {
        return 4118;
    }

    public Object clone() {
        SeriesListRecord rec = new SeriesListRecord();
        rec.field_1_seriesNumbers = this.field_1_seriesNumbers;
        return rec;
    }

    public short[] getSeriesNumbers() {
        return this.field_1_seriesNumbers;
    }

    public void setSeriesNumbers(short[] field_1_seriesNumbers) {
        this.field_1_seriesNumbers = field_1_seriesNumbers;
    }
}

