/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.LittleEndian;

public class SupBookRecord
extends Record {
    public static final short sid = 430;
    private short field_1_number_of_sheets;
    private short field_2_flag;

    public SupBookRecord() {
        this.setFlag((short)1025);
    }

    public SupBookRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 430) {
            throw new RecordFormatException("NOT An Supbook RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_number_of_sheets = in.readShort();
        this.field_2_flag = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SUPBOOK]\n");
        buffer.append("numberosheets = ").append(this.getNumberOfSheets()).append('\n');
        buffer.append("flag          = ").append(this.getFlag()).append('\n');
        buffer.append("[/SUPBOOK]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)430);
        LittleEndian.putShort(data, 2 + offset, (short)4);
        LittleEndian.putShort(data, 4 + offset, this.field_1_number_of_sheets);
        LittleEndian.putShort(data, 6 + offset, this.field_2_flag);
        return this.getRecordSize();
    }

    public void setNumberOfSheets(short number) {
        this.field_1_number_of_sheets = number;
    }

    public short getNumberOfSheets() {
        return this.field_1_number_of_sheets;
    }

    public void setFlag(short flag) {
        this.field_2_flag = flag;
    }

    public short getFlag() {
        return this.field_2_flag;
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 430;
    }
}

