/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.usermodel;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi1.hssf.model.FormulaParser;
import org.apache.poi1.hssf.model.Sheet;
import org.apache.poi1.hssf.model.Workbook;
import org.apache.poi1.hssf.record.BlankRecord;
import org.apache.poi1.hssf.record.BoolErrRecord;
import org.apache.poi1.hssf.record.CellValueRecordInterface;
import org.apache.poi1.hssf.record.CommonObjectDataSubRecord;
import org.apache.poi1.hssf.record.ExtendedFormatRecord;
import org.apache.poi1.hssf.record.FormulaRecord;
import org.apache.poi1.hssf.record.LabelSSTRecord;
import org.apache.poi1.hssf.record.NoteRecord;
import org.apache.poi1.hssf.record.NumberRecord;
import org.apache.poi1.hssf.record.ObjRecord;
import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.SubRecord;
import org.apache.poi1.hssf.record.TextObjectRecord;
import org.apache.poi1.hssf.record.UnicodeString;
import org.apache.poi1.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi1.hssf.record.formula.Ptg;
import org.apache.poi1.hssf.usermodel.HSSFCellStyle;
import org.apache.poi1.hssf.usermodel.HSSFComment;
import org.apache.poi1.hssf.usermodel.HSSFDateUtil;
import org.apache.poi1.hssf.usermodel.HSSFRichTextString;

public class HSSFCell {
    public static final int CELL_TYPE_NUMERIC = 0;
    public static final int CELL_TYPE_STRING = 1;
    public static final int CELL_TYPE_FORMULA = 2;
    public static final int CELL_TYPE_BLANK = 3;
    public static final int CELL_TYPE_BOOLEAN = 4;
    public static final int CELL_TYPE_ERROR = 5;
    public static final short ENCODING_UNCHANGED = -1;
    public static final short ENCODING_COMPRESSED_UNICODE = 0;
    public static final short ENCODING_UTF_16 = 1;
    private int cellType;
    private HSSFRichTextString stringValue;
    private short encoding = (short)-1;
    private Workbook book;
    private Sheet sheet;
    private CellValueRecordInterface record;
    private HSSFComment comment;

    protected HSSFCell(Workbook book, Sheet sheet, int row, short col) {
        this.checkBounds(col);
        this.stringValue = null;
        this.book = book;
        this.sheet = sheet;
        short xfindex = sheet.getXFIndexForColAt(col);
        this.setCellType(3, false, row, col, xfindex);
    }

    protected HSSFCell(Workbook book, Sheet sheet, int row, short col, int type) {
        this.checkBounds(col);
        this.cellType = -1;
        this.stringValue = null;
        this.book = book;
        this.sheet = sheet;
        short xfindex = sheet.getXFIndexForColAt(col);
        this.setCellType(type, false, row, col, xfindex);
    }

    protected HSSFCell(Workbook book, Sheet sheet, int row, CellValueRecordInterface cval) {
        this.record = cval;
        this.cellType = this.determineType(cval);
        this.stringValue = null;
        this.book = book;
        this.sheet = sheet;
        switch (this.cellType) {
            case 1: {
                this.stringValue = new HSSFRichTextString(book, (LabelSSTRecord)cval);
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                this.stringValue = new HSSFRichTextString(((FormulaRecordAggregate)cval).getStringValue());
            }
        }
        ExtendedFormatRecord xf = book.getExFormatAt(cval.getXFIndex());
        this.setCellStyle(new HSSFCellStyle(cval.getXFIndex(), xf));
    }

    private HSSFCell() {
    }

    private int determineType(CellValueRecordInterface cval) {
        Record record = (Record)((Object)cval);
        short sid = record.getSid();
        int retval = 0;
        switch (sid) {
            case 515: {
                retval = 0;
                break;
            }
            case 513: {
                retval = 3;
                break;
            }
            case 253: {
                retval = 1;
                break;
            }
            case -2000: {
                retval = 2;
                break;
            }
            case 517: {
                BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                retval = boolErrRecord.isBoolean() ? 4 : 5;
            }
        }
        return retval;
    }

    public void setCellNum(short num) {
        this.record.setColumn(num);
    }

    public short getCellNum() {
        return this.record.getColumn();
    }

    public void setCellType(int cellType) {
        int row = this.record.getRow();
        short col = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        this.setCellType(cellType, true, row, col, styleIndex);
    }

    private void setCellType(int cellType, boolean setValue, int row, short col, short styleIndex) {
        if (cellType > 5) {
            throw new RuntimeException("I have no idea what type that is!");
        }
        switch (cellType) {
            case 2: {
                FormulaRecordAggregate frec = null;
                frec = cellType != this.cellType ? new FormulaRecordAggregate(new FormulaRecord(), null) : (FormulaRecordAggregate)this.record;
                frec.setColumn(col);
                if (setValue) {
                    frec.getFormulaRecord().setValue(this.getNumericCellValue());
                }
                frec.setXFIndex(styleIndex);
                frec.setRow(row);
                this.record = frec;
                break;
            }
            case 0: {
                NumberRecord nrec = null;
                nrec = cellType != this.cellType ? new NumberRecord() : (NumberRecord)this.record;
                nrec.setColumn(col);
                if (setValue) {
                    nrec.setValue(this.getNumericCellValue());
                }
                nrec.setXFIndex(styleIndex);
                nrec.setRow(row);
                this.record = nrec;
                break;
            }
            case 1: {
                LabelSSTRecord lrec = null;
                lrec = cellType != this.cellType ? new LabelSSTRecord() : (LabelSSTRecord)this.record;
                lrec.setColumn(col);
                lrec.setRow(row);
                lrec.setXFIndex(styleIndex);
                if (setValue && this.getStringCellValue() != null && !this.getStringCellValue().equals("")) {
                    int sst = 0;
                    UnicodeString str = this.getRichStringCellValue().getUnicodeString();
                    sst = this.book.addSSTString(str);
                    lrec.setSSTIndex(sst);
                    this.getRichStringCellValue().setUnicodeString(this.book.getSSTString(sst));
                }
                this.record = lrec;
                break;
            }
            case 3: {
                BlankRecord brec = null;
                brec = cellType != this.cellType ? new BlankRecord() : (BlankRecord)this.record;
                brec.setColumn(col);
                brec.setXFIndex(styleIndex);
                brec.setRow(row);
                this.record = brec;
                break;
            }
            case 4: {
                BoolErrRecord boolRec = null;
                boolRec = cellType != this.cellType ? new BoolErrRecord() : (BoolErrRecord)this.record;
                boolRec.setColumn(col);
                if (setValue) {
                    boolRec.setValue(this.getBooleanCellValue());
                }
                boolRec.setXFIndex(styleIndex);
                boolRec.setRow(row);
                this.record = boolRec;
                break;
            }
            case 5: {
                BoolErrRecord errRec = null;
                errRec = cellType != this.cellType ? new BoolErrRecord() : (BoolErrRecord)this.record;
                errRec.setColumn(col);
                if (setValue) {
                    errRec.setValue(this.getErrorCellValue());
                }
                errRec.setXFIndex(styleIndex);
                errRec.setRow(row);
                this.record = errRec;
            }
        }
        if (cellType != this.cellType && this.cellType != -1) {
            int loc = this.sheet.getLoc();
            this.sheet.replaceValueRecord(this.record);
            this.sheet.setLoc(loc);
        }
        this.cellType = cellType;
    }

    public int getCellType() {
        return this.cellType;
    }

    public void setCellValue(double value) {
        int row = this.record.getRow();
        short col = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        if (this.cellType != 0 && this.cellType != 2) {
            this.setCellType(0, false, row, col, styleIndex);
        }
        ((NumberRecord)this.record).setValue(value);
    }

    public void setCellValue(Date value) {
        this.setCellValue(HSSFDateUtil.getExcelDate(value));
    }

    public void setCellValue(Calendar value) {
        this.setCellValue(value.getTime());
    }

    public void setCellValue(String value) {
        HSSFRichTextString str = new HSSFRichTextString(value);
        this.setCellValue(str);
    }

    public void setCellValue(HSSFRichTextString value) {
        int row = this.record.getRow();
        short col = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        if (value == null) {
            this.setCellType(3, false, row, col, styleIndex);
        } else {
            if (this.cellType != 1 && this.cellType != 2) {
                this.setCellType(1, false, row, col, styleIndex);
            }
            int index = 0;
            UnicodeString str = value.getUnicodeString();
            index = this.book.addSSTString(str);
            ((LabelSSTRecord)this.record).setSSTIndex(index);
            this.stringValue = value;
            this.stringValue.setWorkbookReferences(this.book, (LabelSSTRecord)this.record);
            this.stringValue.setUnicodeString(this.book.getSSTString(index));
        }
    }

    public void setCellFormula(String formula) {
        int row = this.record.getRow();
        short col = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        if (formula == null) {
            this.setCellType(3, false, row, col, styleIndex);
        } else {
            this.setCellType(2, false, row, col, styleIndex);
            FormulaRecordAggregate rec = (FormulaRecordAggregate)this.record;
            FormulaRecord frec = rec.getFormulaRecord();
            frec.setOptions((short)2);
            frec.setValue(0.0);
            if (rec.getXFIndex() == 0) {
                rec.setXFIndex((short)15);
            }
            FormulaParser fp = new FormulaParser(formula + ";", this.book);
            fp.parse();
            Ptg[] ptg = fp.getRPNPtg();
            int size = 0;
            int iSize = frec.getNumberOfExpressionTokens();
            for (int i = 0; i < iSize; ++i) {
                frec.popExpressionToken();
            }
            for (int k = 0; k < ptg.length; ++k) {
                size += ptg[k].getSize();
                frec.pushExpressionToken(ptg[k]);
            }
            rec.getFormulaRecord().setExpressionLength((short)size);
        }
    }

    public String getCellFormula() {
        String retval = FormulaParser.toFormulaString(this.book, ((FormulaRecordAggregate)this.record).getFormulaRecord().getParsedExpression());
        return retval;
    }

    public double getNumericCellValue() {
        if (this.cellType == 3) {
            return 0.0;
        }
        if (this.cellType == 1) {
            throw new NumberFormatException("You cannot get a numeric value from a String based cell");
        }
        if (this.cellType == 4) {
            throw new NumberFormatException("You cannot get a numeric value from a boolean cell");
        }
        if (this.cellType == 5) {
            throw new NumberFormatException("You cannot get a numeric value from an error cell");
        }
        if (this.cellType == 0) {
            return ((NumberRecord)this.record).getValue();
        }
        if (this.cellType == 2) {
            return ((FormulaRecordAggregate)this.record).getFormulaRecord().getValue();
        }
        throw new NumberFormatException("Unknown Record Type in Cell:" + this.cellType);
    }

    public Date getDateCellValue() {
        if (this.cellType == 3) {
            return null;
        }
        if (this.cellType == 1) {
            throw new NumberFormatException("You cannot get a date value from a String based cell");
        }
        if (this.cellType == 4) {
            throw new NumberFormatException("You cannot get a date value from a boolean cell");
        }
        if (this.cellType == 5) {
            throw new NumberFormatException("You cannot get a date value from an error cell");
        }
        double value = this.getNumericCellValue();
        if (this.book.isUsing1904DateWindowing()) {
            return HSSFDateUtil.getJavaDate(value, true);
        }
        return HSSFDateUtil.getJavaDate(value, false);
    }

    public String getStringCellValue() {
        HSSFRichTextString str = this.getRichStringCellValue();
        return str.getString();
    }

    public HSSFRichTextString getRichStringCellValue() {
        if (this.cellType == 3) {
            return new HSSFRichTextString("");
        }
        if (this.cellType == 0) {
            throw new NumberFormatException("You cannot get a string value from a numeric cell");
        }
        if (this.cellType == 4) {
            throw new NumberFormatException("You cannot get a string value from a boolean cell");
        }
        if (this.cellType == 5) {
            throw new NumberFormatException("You cannot get a string value from an error cell");
        }
        if (this.cellType == 2 && this.stringValue == null) {
            return new HSSFRichTextString("");
        }
        return this.stringValue;
    }

    public void setCellValue(boolean value) {
        int row = this.record.getRow();
        short col = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        if (this.cellType != 4 && this.cellType != 2) {
            this.setCellType(4, false, row, col, styleIndex);
        }
        ((BoolErrRecord)this.record).setValue(value);
    }

    public void setCellErrorValue(byte value) {
        int row = this.record.getRow();
        short col = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        if (this.cellType != 5 && this.cellType != 2) {
            this.setCellType(5, false, row, col, styleIndex);
        }
        ((BoolErrRecord)this.record).setValue(value);
    }

    public boolean getBooleanCellValue() {
        if (this.cellType == 4) {
            return ((BoolErrRecord)this.record).getBooleanValue();
        }
        if (this.cellType == 3) {
            return false;
        }
        throw new NumberFormatException("You cannot get a boolean value from a non-boolean cell");
    }

    public byte getErrorCellValue() {
        if (this.cellType == 5) {
            return ((BoolErrRecord)this.record).getErrorValue();
        }
        if (this.cellType == 3) {
            return 0;
        }
        throw new NumberFormatException("You cannot get an error value from a non-error cell");
    }

    public void setCellStyle(HSSFCellStyle style) {
        this.record.setXFIndex(style.getIndex());
    }

    public HSSFCellStyle getCellStyle() {
        short styleIndex = this.record.getXFIndex();
        ExtendedFormatRecord xf = this.book.getExFormatAt(styleIndex);
        return new HSSFCellStyle(styleIndex, xf);
    }

    public short getEncoding() {
        return this.encoding;
    }

    public void setEncoding(short encoding) {
        this.encoding = encoding;
    }

    protected CellValueRecordInterface getCellValueRecord() {
        return this.record;
    }

    private void checkBounds(int cellNum) {
        if (cellNum > 255) {
            throw new RuntimeException("You cannot have more than 255 columns in a given row (IV).  Because Excel can't handle it");
        }
        if (cellNum < 0) {
            throw new RuntimeException("You cannot reference columns with an index of less then 0.");
        }
    }

    public void setAsActiveCell() {
        int row = this.record.getRow();
        short col = this.record.getColumn();
        this.sheet.setActiveCellRow(row);
        this.sheet.setActiveCellCol(col);
    }

    public String toString() {
        switch (this.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return this.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case 5: {
                return "#ERR" + this.getErrorCellValue();
            }
            case 2: {
                return this.getCellFormula();
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted(this)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
                    return sdf.format(this.getDateCellValue());
                }
                return this.getNumericCellValue() + "";
            }
            case 1: {
                return this.getStringCellValue();
            }
        }
        return "Unknown Cell Type: " + this.getCellType();
    }

    public void setCellComment(HSSFComment comment) {
        comment.setRow((short)this.record.getRow());
        comment.setColumn(this.record.getColumn());
        this.comment = comment;
    }

    public HSSFComment getCellComment() {
        if (this.comment == null) {
            this.comment = HSSFCell.findCellComment(this.sheet, this.record.getRow(), this.record.getColumn());
        }
        return this.comment;
    }

    protected static HSSFComment findCellComment(Sheet sheet, int row, int column) {
        HSSFComment comment = null;
        HashMap<Integer, Record> txshapes = new HashMap<Integer, Record>();
        Iterator it = sheet.getRecords().iterator();
        block0: while (it.hasNext()) {
            CommonObjectDataSubRecord cmo;
            ObjRecord obj;
            SubRecord sub;
            Record rec = (Record)it.next();
            if (rec instanceof NoteRecord) {
                NoteRecord note = (NoteRecord)rec;
                if (note.getRow() != row || note.getColumn() != column) continue;
                TextObjectRecord txo = (TextObjectRecord)txshapes.get(new Integer(note.getShapeId()));
                comment = new HSSFComment(note, txo);
                comment.setRow(note.getRow());
                comment.setColumn(note.getColumn());
                comment.setAuthor(note.getAuthor());
                comment.setVisible(note.getFlags() == 2);
                comment.setString(txo.getStr());
                break;
            }
            if (!(rec instanceof ObjRecord) || !((sub = (SubRecord)(obj = (ObjRecord)rec).getSubRecords().get(0)) instanceof CommonObjectDataSubRecord) || (cmo = (CommonObjectDataSubRecord)sub).getObjectType() != 25) continue;
            while (it.hasNext()) {
                rec = (Record)it.next();
                if (!(rec instanceof TextObjectRecord)) continue;
                txshapes.put(new Integer(cmo.getObjectId()), rec);
                continue block0;
            }
        }
        return comment;
    }
}

