/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.usermodel;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.poi1.hssf.usermodel.FontDetails;

class StaticFontMetrics {
    private static Properties fontMetricsProps;
    private static Map fontDetailsMap;

    StaticFontMetrics() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FontDetails getFontDetails(Font font) {
        String fontName;
        block12: {
            if (fontMetricsProps == null) {
                InputStream metricsIn = null;
                try {
                    try {
                        fontMetricsProps = new Properties();
                        if (System.getProperty("font.metrics.filename") != null) {
                            String filename = System.getProperty("font.metrics.filename");
                            File file = new File(filename);
                            if (!file.exists()) {
                                throw new FileNotFoundException("font_metrics.properties not found at path " + file.getAbsolutePath());
                            }
                            metricsIn = new FileInputStream(file);
                        } else {
                            metricsIn = FontDetails.class.getResourceAsStream("/font_metrics.properties");
                            if (metricsIn == null) {
                                throw new FileNotFoundException("font_metrics.properties not found in classpath");
                            }
                        }
                        fontMetricsProps.load(metricsIn);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not load font metrics: " + e.getMessage());
                    }
                    Object var5_5 = null;
                    if (metricsIn == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (metricsIn == null) throw throwable;
                    try {
                        metricsIn.close();
                        throw throwable;
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException ignore) {}
                metricsIn.close();
            }
        }
        if (fontDetailsMap.get(fontName = font.getName()) != null) return (FontDetails)fontDetailsMap.get(fontName);
        FontDetails fontDetails = FontDetails.create(fontName, fontMetricsProps);
        fontDetailsMap.put(fontName, fontDetails);
        return fontDetails;
    }

    static {
        fontDetailsMap = new HashMap();
    }
}

