/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.util;

public class CellReference {
    private int row;
    private int col;
    private String sheetName;
    private boolean rowAbs;
    private boolean colAbs;

    public CellReference(String cellRef) {
        String[] parts = this.separateRefParts(cellRef);
        this.sheetName = parts[0];
        String ref = parts[1];
        if (ref == null || "".equals(ref)) {
            throw new IllegalArgumentException("Invalid Formula cell reference: '" + cellRef + "'");
        }
        if (ref.charAt(0) == '$') {
            this.colAbs = true;
            ref = ref.substring(1);
        }
        this.col = this.convertColStringToNum(ref);
        ref = parts[2];
        if (ref == null || "".equals(ref)) {
            throw new IllegalArgumentException("Invalid Formula cell reference: '" + cellRef + "'");
        }
        if (ref.charAt(0) == '$') {
            this.rowAbs = true;
            ref = ref.substring(1);
        }
        this.row = Integer.parseInt(ref) - 1;
    }

    public CellReference(int pRow, int pCol) {
        this(pRow, pCol, false, false);
    }

    public CellReference(int pRow, int pCol, boolean pAbsRow, boolean pAbsCol) {
        this.row = pRow;
        this.col = pCol;
        this.rowAbs = pAbsRow;
        this.colAbs = pAbsCol;
    }

    public int getRow() {
        return this.row;
    }

    public short getCol() {
        return (short)this.col;
    }

    public boolean isRowAbsolute() {
        return this.rowAbs;
    }

    public boolean isColAbsolute() {
        return this.colAbs;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    private int convertColStringToNum(String ref) {
        int len = ref.length();
        int retval = 0;
        int pos = 0;
        for (int k = ref.length() - 1; k > -1; --k) {
            char thechar = ref.charAt(k);
            retval = pos == 0 ? (retval += Character.getNumericValue(thechar) - 9) : (retval += (Character.getNumericValue(thechar) - 9) * (pos * 26));
            ++pos;
        }
        return retval - 1;
    }

    private String[] separateRefParts(String reference) {
        int loc;
        String[] retval = new String[3];
        int start = reference.indexOf("!");
        if (start != -1) {
            retval[0] = reference.substring(0, start);
        }
        int length = reference.length();
        char[] chars = reference.toCharArray();
        if (chars[loc = ++start] == '$') {
            ++loc;
        }
        while (loc < chars.length && !Character.isDigit(chars[loc]) && chars[loc] != '$') {
            ++loc;
        }
        retval[1] = reference.substring(start, loc);
        retval[2] = reference.substring(loc);
        return retval;
    }

    private static String convertNumToColString(int col) {
        String retval = null;
        int mod = col % 26;
        int div = col / 26;
        char small = (char)(mod + 65);
        char big = (char)(div + 64);
        retval = div == 0 ? "" + small : "" + big + "" + small;
        return retval;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append(this.colAbs ? "$" : "");
        retval.append(CellReference.convertNumToColString(this.col));
        retval.append(this.rowAbs ? "$" : "");
        retval.append(this.row + 1);
        return retval.toString();
    }
}

