/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hwpf.model;

import org.apache.poi1.util.LittleEndian;

public class SectionDescriptor {
    private short fn;
    private int fc;
    private short fnMpr;
    private int fcMpr;

    public SectionDescriptor() {
    }

    public SectionDescriptor(byte[] buf, int offset) {
        this.fn = LittleEndian.getShort(buf, offset);
        this.fc = LittleEndian.getInt(buf, offset += 2);
        this.fnMpr = LittleEndian.getShort(buf, offset += 4);
        this.fcMpr = LittleEndian.getInt(buf, offset += 2);
    }

    public int getFc() {
        return this.fc;
    }

    public void setFc(int fc) {
        this.fc = fc;
    }

    public boolean equals(Object o) {
        SectionDescriptor sed = (SectionDescriptor)o;
        return sed.fn == this.fn && sed.fnMpr == this.fnMpr;
    }

    public byte[] toByteArray() {
        int offset = 0;
        byte[] buf = new byte[12];
        LittleEndian.putShort(buf, offset, this.fn);
        LittleEndian.putInt(buf, offset += 2, this.fc);
        LittleEndian.putShort(buf, offset += 4, this.fnMpr);
        LittleEndian.putInt(buf, offset += 2, this.fcMpr);
        return buf;
    }
}

