/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hwpf.model;

import java.io.UnsupportedEncodingException;
import org.apache.poi1.hwpf.model.PieceDescriptor;
import org.apache.poi1.hwpf.model.PropertyNode;

public class TextPiece
extends PropertyNode
implements Comparable {
    private boolean _usesUnicode;
    private PieceDescriptor _pd;
    private int _cpStart;

    public TextPiece(int start, int end, byte[] text, PieceDescriptor pd, int cpStart) throws UnsupportedEncodingException {
        super(start, end, new StringBuffer(new String(text, pd.isUnicode() ? "UTF-16LE" : "Cp1252")));
        this._usesUnicode = pd.isUnicode();
        this._pd = pd;
        this._cpStart = cpStart;
    }

    public boolean usesUnicode() {
        return this._usesUnicode;
    }

    public PieceDescriptor getPieceDescriptor() {
        return this._pd;
    }

    public StringBuffer getStringBuffer() {
        return (StringBuffer)this._buf;
    }

    public byte[] getRawBytes() {
        try {
            return ((StringBuffer)this._buf).toString().getBytes(this._usesUnicode ? "UTF-16LE" : "Cp1252");
        }
        catch (UnsupportedEncodingException ignore) {
            return ((StringBuffer)this._buf).toString().getBytes();
        }
    }

    public String substring(int start, int end) {
        int denominator = this._usesUnicode ? 2 : 1;
        return ((StringBuffer)this._buf).substring(start / denominator, end / denominator);
    }

    public void adjustForDelete(int start, int length) {
    }

    public int characterLength() {
        return (this.getEnd() - this.getStart()) / (this._usesUnicode ? 2 : 1);
    }

    public boolean equals(Object o) {
        if (this.limitsAreEqual(o)) {
            TextPiece tp = (TextPiece)o;
            return this.getStringBuffer().toString().equals(tp.getStringBuffer().toString()) && tp._usesUnicode == this._usesUnicode && this._pd.equals(tp._pd);
        }
        return false;
    }

    public int getCP() {
        return this._cpStart;
    }
}

