/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.poi1.poifs.storage.BigBlock;
import org.apache.poi1.poifs.storage.RawDataBlock;
import org.apache.poi1.util.IOUtils;

public class DocumentBlock
extends BigBlock {
    private static final byte _default_value = -1;
    private byte[] _data;
    private int _bytes_read;

    public DocumentBlock(RawDataBlock block) throws IOException {
        this._data = block.getData();
        this._bytes_read = this._data.length;
    }

    public DocumentBlock(InputStream stream) throws IOException {
        this();
        int count = IOUtils.readFully(stream, this._data);
        this._bytes_read = count == -1 ? 0 : count;
    }

    private DocumentBlock() {
        this._data = new byte[512];
        Arrays.fill(this._data, (byte)-1);
    }

    public int size() {
        return this._bytes_read;
    }

    public boolean partiallyRead() {
        return this._bytes_read != 512;
    }

    public static byte getFillByte() {
        return -1;
    }

    public static DocumentBlock[] convert(byte[] array, int size) {
        DocumentBlock[] rval = new DocumentBlock[(size + 512 - 1) / 512];
        int offset = 0;
        for (int k = 0; k < rval.length; ++k) {
            rval[k] = new DocumentBlock();
            if (offset < array.length) {
                int length = Math.min(512, array.length - offset);
                System.arraycopy(array, offset, rval[k]._data, 0, length);
                if (length != 512) {
                    Arrays.fill(rval[k]._data, length, 512, (byte)-1);
                }
            } else {
                Arrays.fill(rval[k]._data, (byte)-1);
            }
            offset += 512;
        }
        return rval;
    }

    public static void read(DocumentBlock[] blocks, byte[] buffer, int offset) {
        int firstBlockIndex = offset / 512;
        int firstBlockOffset = offset % 512;
        int lastBlockIndex = (offset + buffer.length - 1) / 512;
        if (firstBlockIndex == lastBlockIndex) {
            System.arraycopy(blocks[firstBlockIndex]._data, firstBlockOffset, buffer, 0, buffer.length);
        } else {
            int buffer_offset = 0;
            System.arraycopy(blocks[firstBlockIndex]._data, firstBlockOffset, buffer, buffer_offset, 512 - firstBlockOffset);
            buffer_offset += 512 - firstBlockOffset;
            for (int j = firstBlockIndex + 1; j < lastBlockIndex; ++j) {
                System.arraycopy(blocks[j]._data, 0, buffer, buffer_offset, 512);
                buffer_offset += 512;
            }
            System.arraycopy(blocks[lastBlockIndex]._data, 0, buffer, buffer_offset, buffer.length - buffer_offset);
        }
    }

    void writeData(OutputStream stream) throws IOException {
        this.doWriteData(stream, this._data);
    }
}

