/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.app;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.cp.eip.fts.app.AnalyzerManager;
import com.kingdee.eas.cp.eip.fts.app.BusinessDataObject;
import com.kingdee.eas.cp.eip.fts.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene1.analysis.Analyzer;
import org.apache.lucene1.document.Document;
import org.apache.lucene1.document.Field;
import org.apache.lucene1.index.IndexReader;
import org.apache.lucene1.index.IndexWriter;
import org.apache.lucene1.index.Term;
import org.apache.lucene1.store.Directory;
import org.apache.lucene1.store.FSDirectory;
import org.apache.lucene1.store.RAMDirectory;

public class IndexManager {
    protected final Logger log = CoreUIObject.getLogger((Class)IndexManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexBusinessData(List list, String dbCenterName) throws IOException {
        String dbCenterIndexFold = Utils.getIndexDbPath(dbCenterName);
        Object fsDir = null;
        IndexWriter fsWriter = null;
        try {
            this.batchDelete(list, dbCenterName);
            fsWriter = this.getIndexWriter(dbCenterIndexFold);
            RAMDirectory ramDir = new RAMDirectory();
            Analyzer analyzer = AnalyzerManager.getAnalyzer();
            IndexWriter ramWriter = new IndexWriter(ramDir, analyzer, true);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BusinessDataObject dataObject = (BusinessDataObject)iterator.next();
                this.log.info((Object)("%%%%%%%%new update index.............,dataObject write into fts:" + dataObject.getGategory() + ":" + dataObject.getTitle() + ":" + dataObject.getKeyWord()));
                Document doc = this.getLuceneDoc(dataObject);
                fsWriter.addDocument(doc);
                this.log.info((Object)("%%%%%%%%new update index.............,doc write into fts:" + doc));
            }
            Directory[] directorys = new Directory[]{ramDir};
            fsWriter.addIndexes(directorys);
        }
        catch (Exception e) {
            this.log.error((Object)("\u951f\u65a4\u62f7b\u951f\u65a4\u62f7\u951f\u7aed\u9769\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u5931\u951f\u65a4\u62f7!" + e));
        }
        finally {
            if (fsWriter != null) {
                fsWriter.close();
            }
        }
    }

    private IndexWriter getIndexWriter(String dbCenterIndexFold) throws IOException {
        IndexWriter fsWriter;
        File file = new File(dbCenterIndexFold);
        Analyzer analyzer = AnalyzerManager.getAnalyzer();
        if (!file.exists() || file.isDirectory() && file.list().length == 0) {
            FSDirectory fsDir = FSDirectory.getDirectory(dbCenterIndexFold, true);
            fsWriter = new IndexWriter(fsDir, analyzer, true);
        } else {
            FSDirectory fsDir = FSDirectory.getDirectory(dbCenterIndexFold, false);
            fsWriter = new IndexWriter(fsDir, analyzer, false);
        }
        fsWriter.minMergeDocs = 1000;
        fsWriter.maxMergeDocs = 1000;
        return fsWriter;
    }

    public void initIndexWriter(String dbCenterIndexFold) throws IOException {
        IndexWriter fsWriter = null;
        File file = new File(dbCenterIndexFold);
        Analyzer analyzer = AnalyzerManager.getAnalyzer();
        try {
            FSDirectory fsDir = !file.exists() ? FSDirectory.getDirectory(dbCenterIndexFold, true) : FSDirectory.getDirectory(dbCenterIndexFold, false);
            fsWriter = new IndexWriter(fsDir, analyzer, true);
        }
        catch (IOException e) {
            this.log.error((Object)"\u951f\u65a4\u62f7\u59cb\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u951f\ufffd");
            throw e;
        }
        finally {
            if (fsWriter != null) {
                fsWriter.close();
            }
        }
    }

    private boolean notEmpty(Object obj) {
        return obj != null;
    }

    private Document getLuceneDoc(BusinessDataObject dataObject) {
        Document doc = new Document();
        doc.add(Field.Keyword("uuid", dataObject.getUuid()));
        if (this.notEmpty(dataObject.getTitle())) {
            doc.add(Field.Text("title", dataObject.getTitle()));
        }
        if (this.notEmpty(dataObject.getKeyWord())) {
            doc.add(Field.Text("keyWord", dataObject.getKeyWord()));
        }
        if (this.notEmpty(dataObject.getContent())) {
            doc.add(Field.Text("content", dataObject.getContent()));
        }
        if (this.notEmpty(dataObject.getCreateUser())) {
            doc.add(Field.Text("createuser", dataObject.getCreateUser()));
        }
        if (this.notEmpty(dataObject.getLastUpdateUser())) {
            doc.add(Field.Text("lastUpdateUser", dataObject.getLastUpdateUser()));
        }
        if (this.notEmpty(dataObject.getCreateTime())) {
            doc.add(Field.Keyword("createTime", dataObject.getCreateTime()));
        }
        if (this.notEmpty(dataObject.getLastUpdateTime())) {
            doc.add(Field.Keyword("lastUpdateTime", dataObject.getLastUpdateTime()));
        }
        if (this.notEmpty(dataObject.getPath())) {
            doc.add(Field.Keyword("path", dataObject.getPath()));
        }
        if (this.notEmpty(dataObject.getGategory())) {
            doc.add(Field.Keyword("gategory", dataObject.getGategory()));
        }
        if (this.notEmpty(dataObject.getPeritemName())) {
            doc.add(Field.Keyword("perItem", dataObject.getPeritemName()));
        }
        return doc;
    }

    public void batchDelete(List list, String dbCenterName) throws IOException {
        String dbCenterIndexFold = Utils.getIndexDbPath(dbCenterName);
        FSDirectory fsDir = null;
        File file = new File(dbCenterIndexFold);
        if (file.exists()) {
            fsDir = FSDirectory.getDirectory(dbCenterIndexFold, false);
            this.batchDelete(list, fsDir);
        }
    }

    private void batchDelete(List list, FSDirectory fsDir) throws IOException {
        if (fsDir.getFile() == null || fsDir.getFile().list().length == 0) {
            return;
        }
        IndexReader reader = IndexReader.open(fsDir);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BusinessDataObject dataObject = (BusinessDataObject)iterator.next();
            reader.delete(new Term("uuid", dataObject.getUuid()));
        }
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize(String dbCenterName) throws IOException {
        String dbCenterIndexFold = Utils.getIndexDbPath(dbCenterName);
        FSDirectory fsDir = null;
        IndexWriter fsWriter = null;
        try {
            fsDir = FSDirectory.getDirectory(dbCenterIndexFold, false);
            Analyzer analyzer = AnalyzerManager.getAnalyzer();
            fsWriter = new IndexWriter(fsDir, analyzer, false);
            fsWriter.optimize();
        }
        catch (IOException e) {
            this.log.error((Object)"optimize index for fail!");
        }
        finally {
            if (fsWriter != null) {
                fsWriter.close();
            }
        }
    }
}

