/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.business;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.cp.eip.fts.FullTextModuleEnum;
import com.kingdee.eas.cp.eip.fts.app.BusinessDataObject;
import com.kingdee.eas.cp.eip.fts.business.EasBusinessResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EasCmsMainResource
extends EasBusinessResource {
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eip.fts.business.EasBusinessResource");

    public EasCmsMainResource() {
        this.queryName = "ContentQuery";
        this.queryPackage = "com.kingdee.eas.cp.eip.cm.app";
        this.fullTextModuleEnum = FullTextModuleEnum.CMS;
    }

    protected List format(IRowSet rowSet) {
        ArrayList<BusinessDataObject> list = new ArrayList<BusinessDataObject>();
        BusinessDataObject obj = null;
        Timestamp max = this.getLastRunTime();
        Timestamp cur = null;
        try {
            while (rowSet.next()) {
                obj = new BusinessDataObject();
                obj.setUuid(rowSet.getString("id"));
                StringBuffer title = new StringBuffer();
                title.append(rowSet.getString("CMColumn.name"));
                title.append("/");
                title.append(rowSet.getString("CMClass.name"));
                title.append(" ");
                title.append(StringUtils.defaultString((String)rowSet.getString("title")));
                obj.setTitle(title.toString());
                obj.setCreateUser(rowSet.getString("User.name"));
                obj.setCreateTime(rowSet.getTimestamp("createTime"));
                cur = rowSet.getTimestamp("lastUpdateTime");
                if (max == null || max.before(cur)) {
                    max = cur;
                }
                obj.setLastUpdateTime(rowSet.getTimestamp("lastUpdateTime"));
                obj.setKeyWord(rowSet.getString("keyword"));
                obj.setPath("cm/ContentView.do?contentId=" + URLEncoder.encode(rowSet.getString("id"), "utf-8"));
                obj.setContent(rowSet.getString("summary"));
                obj.setGategory(this.fullTextModuleEnum.getValue());
                obj.setPeritemName("cm_manager");
                list.add(obj);
            }
            this.setLastRunTime(max);
        }
        catch (Exception e) {
            logger.warn((Object)("\u951f\u65a4\u62f7\u951f\u6377\u7678\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u837b\u951f\u997a\u2208\u044d\u62f7\u57fd\u951f\ufffd" + e.getMessage()));
        }
        return list;
    }

    protected EntityViewInfo getEntityView() {
        EntityViewInfo entityViewInfo = null;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo0 = new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS);
        entityViewInfo = new EntityViewInfo();
        filterInfo.getFilterItems().add(filterItemInfo0);
        if (this.lastRunTime != null) {
            FilterItemInfo filterItemInfo = new FilterItemInfo("lastUpdateTime", (Object)this.lastRunTime, CompareType.GREATER_EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString("#0 and #1");
        }
        entityViewInfo.setFilter(filterInfo);
        SorterItemInfo item = new SorterItemInfo("lastUpdateTime");
        entityViewInfo.getSorter().add(item);
        return entityViewInfo;
    }
}

