/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.documents;

import java.nio.charset.Charset;
import java.util.HashMap;

public class StringUtil {
    private static HashMap encodingAliases = new HashMap();

    public static String rightPad(String s, int length) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = length - s.length(); i > 0; --i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String leftPad(String s, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = length - s.length(); i > 0; --i) {
            sb.append(" ");
        }
        sb.append(s);
        return sb.toString();
    }

    public static String parseCharacterEncoding(String contentType) {
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (start < 0) {
            return null;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            encoding = encoding.substring(0, end);
        }
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding.trim();
    }

    public static String resolveEncodingAlias(String encoding) {
        if (!Charset.isSupported(encoding)) {
            return null;
        }
        String canonicalName = new String(Charset.forName(encoding).name());
        return encodingAliases.containsKey(canonicalName) ? (String)encodingAliases.get(canonicalName) : canonicalName;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: StringUtil <encoding name>");
        } else {
            System.out.println(args[0] + " is resolved to " + StringUtil.resolveEncodingAlias(args[0]));
        }
    }

    static {
        encodingAliases.put("ISO-8859-1", "windows-1252");
        encodingAliases.put("EUC-KR", "x-windows-949");
        encodingAliases.put("x-EUC-CN", "GB18030");
        encodingAliases.put("GBK", "GB18030");
        encodingAliases.put("GB2312", "GB18030");
        encodingAliases.put("Big5", "Big5HKSCS");
        encodingAliases.put("TIS620", "Cp874");
        encodingAliases.put("ISO-8859-11", "Cp874");
    }
}

