/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.utils;

import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.cp.eip.fts.FullTextModuleEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ExceptionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.SystemUtils;

public class Utils {
    public static String ALL_GATEGORY = EASCommonResource.getString((String)"com.kingdee.eas.cp.eip.fts.ftsearch", (String)"allGategory", (Locale)ContextUtils.getLocaleFromEnv());
    public static String NEEDINDEX = "0";
    public static String NOTINDEX = "1";
    public static final String MAGICCODE = "###PACKER4.0.1###";

    public static boolean isValidBosId(String id) {
        return id != null && (id.length() == 44 || id.length() == 28);
    }

    public static String getBosId(String id) {
        int index = id.indexOf(";");
        if (index > 0) {
            return id.substring(0, index);
        }
        return id;
    }

    public static String getGategoryById(String id) {
        if (id == null || id.equals("")) {
            return "";
        }
        if (Utils.isValidBosId(id)) {
            if (BOSUuid.read((String)id).getType().equals((Object)new BOSObjectType("8612C308"))) {
                return FullTextModuleEnum.CMS.getValue();
            }
            if (BOSUuid.read((String)id).getType().equals((Object)new BOSObjectType("C7E914D9"))) {
                return FullTextModuleEnum.PERRESUME.getValue();
            }
            if (BOSUuid.read((String)id).getType().equals((Object)new BOSObjectType("E2379C70"))) {
                return FullTextModuleEnum.FME.getValue();
            }
        }
        return FullTextModuleEnum.OTHER.getValue();
    }

    public static String getIndexDbPath(String dbCenterName) {
        try {
            StringBuffer bf = new StringBuffer();
            bf.append(System.getProperty("EAS_HOME"));
            bf.append(SystemUtils.FILE_SEPARATOR);
            bf.append("server");
            bf.append(SystemUtils.FILE_SEPARATOR);
            bf.append("properties");
            bf.append(SystemUtils.FILE_SEPARATOR);
            bf.append("workspace");
            bf.append(SystemUtils.FILE_SEPARATOR);
            bf.append("portal");
            bf.append(SystemUtils.FILE_SEPARATOR);
            bf.append("index");
            String baseIndexFold = bf.toString();
            String dbCenterIndexFold = baseIndexFold + SystemUtils.FILE_SEPARATOR + dbCenterName;
            return dbCenterIndexFold;
        }
        catch (Exception e0) {
            return "/home/index" + SystemUtils.FILE_SEPARATOR + dbCenterName;
        }
    }

    public static String buildDetail(Throwable exc) {
        StringBuffer detail = new StringBuffer();
        detail.append(exc.getMessage());
        detail.append(System.getProperty("line.separator"));
        detail.append(ExceptionUtil.getExcLinkStackTrace((Throwable)exc));
        return detail.toString();
    }

    public static String mapType(String type, int contentType) {
        String rtnVal = "";
        if (type.equals(".b") || type.equals("b") || type.equals("\u93c8\ue046\u7161\u93c2\u56e6\u6b22\u7eeb\u8bf2\u7037\u951b\ufffd.b\u951b\ufffd") || type.equals("\u93c8\ue046\u7161\u93c2\u56e6\u6b22\u7eeb\u8bf2\u7037\u951b\ufffd.html\u951b\ufffd") || type.equals("\u93c8\ue046\u7161\u93c2\u56e6\u6b22\u7eeb\u8bf2\u7037\u951b\ufffd.body\u951b\ufffd")) {
            switch (contentType) {
                case 1: {
                    rtnVal = "html";
                    break;
                }
                case 2: {
                    rtnVal = "doc";
                    break;
                }
                case 3: {
                    rtnVal = "xls";
                    break;
                }
                case 4: {
                    rtnVal = "pdf";
                    break;
                }
                default: {
                    rtnVal = "html";
                    break;
                }
            }
        } else if (type.equals(".java") || type.equals("TEXT \u93c2\u56e8\u6e70\u93c2\u56e6\u6b22")) {
            rtnVal = "txt";
        } else if (type.equals(".doc") || type.equals("Microsoft Word \u93c2\u56e8\u3002") || type.equals("\u93c8\ue046\u7161\u93c2\u56e6\u6b22\u7eeb\u8bf2\u7037\u951b\ufffd.docx\u951b\ufffd") || type.equals("\u93c8\ue046\u7161\u93c2\u56e6\u6b22\u7eeb\u8bf2\u7037\u951b\ufffd.DOC_FOFFICE\u951b\ufffd")) {
            rtnVal = "doc";
        } else if (type.equals(".excel") || type.equals("\u93c8\ue046\u7161\u93c2\u56e6\u6b22\u7eeb\u8bf2\u7037\u951b\ufffd.xlsx\u951b\ufffd") || type.equals("Microsoft Excel \u741b\u3126\u7278")) {
            rtnVal = "xls";
        } else if (type.equals("\u93c8\ue046\u7161\u93c2\u56e6\u6b22\u7eeb\u8bf2\u7037\u951b\ufffd.pdf\u951b\ufffd") || type.equals("\u93c8\ue046\u7161\u93c2\u56e6\u6b22\u7eeb\u8bf2\u7037\u951b\ufffd.PDF\u951b\ufffd") || type.equals("\u93c8\ue046\u7161\u93c2\u56e6\u6b22\u7eeb\u8bf2\u7037\u951b\ufffd.4\u951b\ufffd")) {
            rtnVal = "pdf";
        }
        return rtnVal;
    }

    public static String formatType(String type, int contentType) {
        type = Utils.mapType(type, contentType);
        type = "[" + type + "]";
        type = type.toUpperCase();
        return type;
    }

    public static byte[] unpack(byte[] source) throws IOException {
        int len;
        if (source == null || source.length < 1) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(source);
        int count = Utils.readMagic(bin);
        if (count == Integer.MAX_VALUE) {
            bin.close();
            return source;
        }
        if (count < 1) {
            bin.close();
            return null;
        }
        GZIPInputStream zin = new GZIPInputStream(bin);
        byte[] res = new byte[count];
        int num = 0;
        while ((len = count - num) >= 0) {
            int n;
            if (len > 4096) {
                len = 4096;
            }
            if ((n = zin.read(res, num, len)) <= 0) break;
            num += n;
        }
        zin.close();
        bin.close();
        return num != count ? null : res;
    }

    private static int readMagic(ByteArrayInputStream input) {
        if (input == null) {
            return 0;
        }
        int len = MAGICCODE.length();
        for (int m = 0; m < len; ++m) {
            if (MAGICCODE.charAt(m) == (char)input.read()) continue;
            return Integer.MAX_VALUE;
        }
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            int sz = input.read();
            if (sz < 0) {
                return 0;
            }
            if (i > 0) {
                res <<= 8;
            }
            res |= sz;
        }
        return res;
    }
}

