/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.search;

import java.io.IOException;
import org.apache.lucene1.index.Term;
import org.apache.lucene1.search.FieldDocSortedHitQueue;
import org.apache.lucene1.search.Filter;
import org.apache.lucene1.search.HitCollector;
import org.apache.lucene1.search.HitQueue;
import org.apache.lucene1.search.MultiSearcher;
import org.apache.lucene1.search.MultiSearcherThread;
import org.apache.lucene1.search.Query;
import org.apache.lucene1.search.ScoreDoc;
import org.apache.lucene1.search.Searchable;
import org.apache.lucene1.search.Sort;
import org.apache.lucene1.search.TopDocs;
import org.apache.lucene1.search.TopFieldDocs;

public class ParallelMultiSearcher
extends MultiSearcher {
    private Searchable[] searchables;
    private int[] starts;

    public ParallelMultiSearcher(Searchable[] searchables) throws IOException {
        super(searchables);
        this.searchables = searchables;
        this.starts = this.getStarts();
    }

    public int docFreq(Term term) throws IOException {
        int docFreq = 0;
        for (int i = 0; i < this.searchables.length; ++i) {
            docFreq += this.searchables[i].docFreq(term);
        }
        return docFreq;
    }

    public TopDocs search(Query query, Filter filter, int nDocs) throws IOException {
        int i;
        HitQueue hq = new HitQueue(nDocs);
        int totalHits = 0;
        MultiSearcherThread[] msta = new MultiSearcherThread[this.searchables.length];
        for (i = 0; i < this.searchables.length; ++i) {
            msta[i] = new MultiSearcherThread(this.searchables[i], query, filter, nDocs, hq, i, this.starts, "MultiSearcher thread #" + (i + 1));
            msta[i].start();
        }
        for (i = 0; i < this.searchables.length; ++i) {
            try {
                msta[i].join();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            IOException ioe = msta[i].getIOException();
            if (ioe == null) {
                totalHits += msta[i].hits();
                continue;
            }
            throw ioe;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i2 = hq.size() - 1; i2 >= 0; --i2) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
        }
        return new TopDocs(totalHits, scoreDocs);
    }

    public TopFieldDocs search(Query query, Filter filter, int nDocs, Sort sort) throws IOException {
        int i;
        FieldDocSortedHitQueue hq = new FieldDocSortedHitQueue(null, nDocs);
        int totalHits = 0;
        MultiSearcherThread[] msta = new MultiSearcherThread[this.searchables.length];
        for (i = 0; i < this.searchables.length; ++i) {
            msta[i] = new MultiSearcherThread(this.searchables[i], query, filter, nDocs, hq, sort, i, this.starts, "MultiSearcher thread #" + (i + 1));
            msta[i].start();
        }
        for (i = 0; i < this.searchables.length; ++i) {
            try {
                msta[i].join();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            IOException ioe = msta[i].getIOException();
            if (ioe == null) {
                totalHits += msta[i].hits();
                continue;
            }
            throw ioe;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i2 = hq.size() - 1; i2 >= 0; --i2) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
        }
        return new TopFieldDocs(totalHits, scoreDocs, hq.getFields());
    }

    public void search(Query query, Filter filter, final HitCollector results) throws IOException {
        for (int i = 0; i < this.searchables.length; ++i) {
            final int start = this.starts[i];
            this.searchables[i].search(query, filter, new HitCollector(){

                public void collect(int doc, float score) {
                    results.collect(doc + start, score);
                }
            });
        }
    }

    public Query rewrite(Query original) throws IOException {
        Query[] queries = new Query[this.searchables.length];
        for (int i = 0; i < this.searchables.length; ++i) {
            queries[i] = this.searchables[i].rewrite(original);
        }
        return original.combine(queries);
    }
}

