/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.ddf;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi1.ddf.EscherBSERecord;
import org.apache.poi1.ddf.EscherBitmapBlip;
import org.apache.poi1.ddf.EscherBlipRecord;
import org.apache.poi1.ddf.EscherChildAnchorRecord;
import org.apache.poi1.ddf.EscherClientAnchorRecord;
import org.apache.poi1.ddf.EscherClientDataRecord;
import org.apache.poi1.ddf.EscherContainerRecord;
import org.apache.poi1.ddf.EscherDgRecord;
import org.apache.poi1.ddf.EscherDggRecord;
import org.apache.poi1.ddf.EscherOptRecord;
import org.apache.poi1.ddf.EscherRecord;
import org.apache.poi1.ddf.EscherRecordFactory;
import org.apache.poi1.ddf.EscherSpRecord;
import org.apache.poi1.ddf.EscherSpgrRecord;
import org.apache.poi1.ddf.EscherSplitMenuColorsRecord;
import org.apache.poi1.ddf.EscherTextboxRecord;
import org.apache.poi1.ddf.UnknownEscherRecord;
import org.apache.poi1.hssf.record.RecordFormatException;

public class DefaultEscherRecordFactory
implements EscherRecordFactory {
    private static Class[] escherRecordClasses = new Class[]{EscherBSERecord.class, EscherOptRecord.class, EscherClientAnchorRecord.class, EscherDgRecord.class, EscherSpgrRecord.class, EscherSpRecord.class, EscherClientDataRecord.class, EscherDggRecord.class, EscherSplitMenuColorsRecord.class, EscherChildAnchorRecord.class, EscherTextboxRecord.class};
    private static Map recordsMap = DefaultEscherRecordFactory.recordsToMap(escherRecordClasses);

    public EscherRecord createRecord(byte[] data, int offset) {
        EscherRecord.EscherRecordHeader header = EscherRecord.EscherRecordHeader.readHeader(data, offset);
        if ((header.getOptions() & 0xF) == 15 && header.getRecordId() != -4083) {
            EscherContainerRecord r = new EscherContainerRecord();
            r.setRecordId(header.getRecordId());
            r.setOptions(header.getOptions());
            return r;
        }
        if (header.getRecordId() >= -4072 && header.getRecordId() <= -3817) {
            EscherBlipRecord r = header.getRecordId() == -4065 || header.getRecordId() == -4067 || header.getRecordId() == -4066 ? new EscherBitmapBlip() : new EscherBlipRecord();
            r.setRecordId(header.getRecordId());
            r.setOptions(header.getOptions());
            return r;
        }
        Constructor recordConstructor = (Constructor)recordsMap.get(new Short(header.getRecordId()));
        EscherRecord escherRecord = null;
        if (recordConstructor != null) {
            try {
                escherRecord = (EscherRecord)recordConstructor.newInstance(new Object[0]);
                escherRecord.setRecordId(header.getRecordId());
                escherRecord.setOptions(header.getOptions());
            }
            catch (Exception e) {
                escherRecord = null;
            }
        }
        return escherRecord == null ? new UnknownEscherRecord() : escherRecord;
    }

    private static Map recordsToMap(Class[] records) {
        HashMap result = new HashMap();
        for (int i = 0; i < records.length; ++i) {
            Constructor constructor;
            Class record = null;
            short sid = 0;
            record = records[i];
            try {
                sid = record.getField("RECORD_ID").getShort(null);
                constructor = record.getConstructor(new Class[0]);
            }
            catch (Exception illegalArgumentException) {
                throw new RecordFormatException("Unable to determine record types");
            }
            result.put(new Short(sid), constructor);
        }
        return result;
    }
}

