/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hdf.extractor;

import org.apache.poi1.hdf.extractor.CHP;
import org.apache.poi1.hdf.extractor.PAP;
import org.apache.poi1.hdf.extractor.Utils;

public class StyleDescription {
    private static int PARAGRAPH_STYLE = 1;
    private static int CHARACTER_STYLE = 2;
    int _baseStyleIndex;
    int _styleTypeCode;
    int _numUPX;
    byte[] _papx;
    byte[] _chpx;
    PAP _pap;
    CHP _chp;

    public StyleDescription() {
        this._pap = new PAP();
        this._chp = new CHP();
    }

    public StyleDescription(byte[] std, int baseLength, boolean word9) {
        short infoShort = Utils.convertBytesToShort(std, 2);
        this._styleTypeCode = infoShort & 0xF;
        this._baseStyleIndex = (infoShort & 0xFFF0) >> 4;
        infoShort = Utils.convertBytesToShort(std, 4);
        this._numUPX = infoShort & 0xF;
        short nameLength = 0;
        int multiplier = 1;
        if (word9) {
            nameLength = Utils.convertBytesToShort(std, baseLength);
            multiplier = 2;
        } else {
            nameLength = std[baseLength];
        }
        int grupxStart = multiplier + (nameLength + 1) * multiplier + baseLength;
        int offset = 0;
        for (int x = 0; x < this._numUPX; ++x) {
            int upxSize = Utils.convertBytesToShort(std, grupxStart + offset);
            if (this._styleTypeCode == PARAGRAPH_STYLE) {
                if (x == 0) {
                    this._papx = new byte[upxSize];
                    System.arraycopy(std, grupxStart + offset + 2, this._papx, 0, upxSize);
                } else if (x == 1) {
                    this._chpx = new byte[upxSize];
                    System.arraycopy(std, grupxStart + offset + 2, this._chpx, 0, upxSize);
                }
            } else if (this._styleTypeCode == CHARACTER_STYLE && x == 0) {
                this._chpx = new byte[upxSize];
                System.arraycopy(std, grupxStart + offset + 2, this._chpx, 0, upxSize);
            }
            if (upxSize % 2 == 1) {
                ++upxSize;
            }
            offset += 2 + upxSize;
        }
    }

    public int getBaseStyle() {
        return this._baseStyleIndex;
    }

    public byte[] getCHPX() {
        return this._chpx;
    }

    public byte[] getPAPX() {
        return this._papx;
    }

    public PAP getPAP() {
        return this._pap;
    }

    public CHP getCHP() {
        return this._chp;
    }

    public void setPAP(PAP pap) {
        this._pap = pap;
    }

    public void setCHP(CHP chp) {
        this._chp = chp;
    }
}

