/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.BitField;
import org.apache.poi1.util.BitFieldFactory;
import org.apache.poi1.util.HexDump;
import org.apache.poi1.util.LittleEndian;

public class AreaRecord
extends Record {
    public static final short sid = 4122;
    private short field_1_formatFlags;
    private BitField stacked = BitFieldFactory.getInstance(1);
    private BitField displayAsPercentage = BitFieldFactory.getInstance(2);
    private BitField shadow = BitFieldFactory.getInstance(4);

    public AreaRecord() {
    }

    public AreaRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4122) {
            throw new RecordFormatException("Not a Area record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_formatFlags = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AREA]\n");
        buffer.append("    .formatFlags          = ").append("0x").append(HexDump.toHex(this.getFormatFlags())).append(" (").append(this.getFormatFlags()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .stacked                  = ").append(this.isStacked()).append('\n');
        buffer.append("         .displayAsPercentage      = ").append(this.isDisplayAsPercentage()).append('\n');
        buffer.append("         .shadow                   = ").append(this.isShadow()).append('\n');
        buffer.append("[/AREA]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4122);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_formatFlags);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4122;
    }

    public Object clone() {
        AreaRecord rec = new AreaRecord();
        rec.field_1_formatFlags = this.field_1_formatFlags;
        return rec;
    }

    public short getFormatFlags() {
        return this.field_1_formatFlags;
    }

    public void setFormatFlags(short field_1_formatFlags) {
        this.field_1_formatFlags = field_1_formatFlags;
    }

    public void setStacked(boolean value) {
        this.field_1_formatFlags = this.stacked.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isStacked() {
        return this.stacked.isSet(this.field_1_formatFlags);
    }

    public void setDisplayAsPercentage(boolean value) {
        this.field_1_formatFlags = this.displayAsPercentage.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isDisplayAsPercentage() {
        return this.displayAsPercentage.isSet(this.field_1_formatFlags);
    }

    public void setShadow(boolean value) {
        this.field_1_formatFlags = this.shadow.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isShadow() {
        return this.shadow.isSet(this.field_1_formatFlags);
    }
}

