/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi1.hssf.record.PColor;
import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.LittleEndian;

public class PaletteRecord
extends Record {
    public static final short sid = 146;
    public static final byte STANDARD_PALETTE_SIZE = 56;
    public static final short FIRST_COLOR_INDEX = 8;
    private short field_1_numcolors;
    private List field_2_colors;

    public PaletteRecord() {
        this.createDefaultPalette();
    }

    public PaletteRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 146) {
            throw new RecordFormatException("NOT An Palette RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_numcolors = in.readShort();
        this.field_2_colors = new ArrayList(this.field_1_numcolors);
        for (int k = 0; k < this.field_1_numcolors; ++k) {
            this.field_2_colors.add(new PColor(in.readByte(), in.readByte(), in.readByte()));
            in.readByte();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PALETTE]\n");
        buffer.append("  numcolors     = ").append(this.field_1_numcolors).append('\n');
        for (int k = 0; k < this.field_1_numcolors; ++k) {
            PColor c = (PColor)this.field_2_colors.get(k);
            buffer.append("* colornum      = ").append(k).append('\n');
            buffer.append(c.toString());
            buffer.append("/*colornum      = ").append(k).append('\n');
        }
        buffer.append("[/PALETTE]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)146);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.field_1_numcolors);
        for (int k = 0; k < this.field_1_numcolors; ++k) {
            PColor c = (PColor)this.field_2_colors.get(k);
            c.serialize(data, 6 + offset + k * 4);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6 + this.field_1_numcolors * 4;
    }

    public short getSid() {
        return 146;
    }

    public byte[] getColor(short byteIndex) {
        int i = byteIndex - 8;
        if (i < 0 || i >= this.field_2_colors.size()) {
            return null;
        }
        PColor color = (PColor)this.field_2_colors.get(i);
        return new byte[]{color.red, color.green, color.blue};
    }

    public void setColor(short byteIndex, byte red, byte green, byte blue) {
        int i = byteIndex - 8;
        if (i < 0 || i >= 56) {
            return;
        }
        while (this.field_2_colors.size() <= i) {
            this.field_2_colors.add(new PColor(0, 0, 0));
        }
        PColor custColor = new PColor(red, green, blue);
        this.field_2_colors.set(i, custColor);
    }

    private void createDefaultPalette() {
        this.field_1_numcolors = (short)56;
        this.field_2_colors = new ArrayList(this.field_1_numcolors);
        byte[] palette = new byte[]{0, 0, 0, 0, -1, -1, -1, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, -1, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, 0, 0, -128, 0, 0, 0, 0, -128, 0, -128, -128, 0, 0, -128, 0, -128, 0, 0, -128, -128, 0, -64, -64, -64, 0, -128, -128, -128, 0, -103, -103, -1, 0, -103, 51, 102, 0, -1, -1, -52, 0, -52, -1, -1, 0, 102, 0, 102, 0, -1, -128, -128, 0, 0, 102, -52, 0, -52, -52, -1, 0, 0, 0, -128, 0, -1, 0, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -128, 0, -128, 0, -128, 0, 0, 0, 0, -128, -128, 0, 0, 0, -1, 0, 0, -52, -1, 0, -52, -1, -1, 0, -52, -1, -52, 0, -1, -1, -103, 0, -103, -52, -1, 0, -1, -103, -52, 0, -52, -103, -1, 0, -1, -52, -103, 0, 51, 102, -1, 0, 51, -52, -52, 0, -103, -52, 0, 0, -1, -52, 0, 0, -1, -103, 0, 0, -1, 102, 0, 0, 102, 102, -103, 0, -106, -106, -106, 0, 0, 51, 102, 0, 51, -103, 102, 0, 0, 51, 0, 0, 51, 51, 0, 0, -103, 51, 0, 0, -103, 51, 102, 0, 51, 51, -103, 0, 51, 51, 51, 0};
        for (int k = 0; k < this.field_1_numcolors; ++k) {
            this.field_2_colors.add(new PColor(palette[k * 4], palette[k * 4 + 1], palette[k * 4 + 2]));
        }
    }
}

