/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.LittleEndian;

public class RecalcIdRecord
extends Record {
    public static final short sid = 449;
    public short[] field_1_recalcids;
    private boolean isNeeded = true;

    public RecalcIdRecord() {
    }

    public RecalcIdRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 449) {
            throw new RecordFormatException("NOT A RECALCID RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_recalcids = new short[in.remaining() / 2];
        for (int k = 0; k < this.field_1_recalcids.length; ++k) {
            this.field_1_recalcids[k] = in.readShort();
        }
    }

    public void setRecalcIdArray(short[] array) {
        this.field_1_recalcids = array;
    }

    public short[] getRecalcIdArray() {
        return this.field_1_recalcids;
    }

    public void setIsNeeded(boolean isNeeded) {
        this.isNeeded = isNeeded;
    }

    public boolean isNeeded() {
        return this.isNeeded;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[RECALCID]\n");
        buffer.append("    .elements        = ").append(this.field_1_recalcids.length).append("\n");
        for (int k = 0; k < this.field_1_recalcids.length; ++k) {
            buffer.append("    .element_" + k + "       = ").append(this.field_1_recalcids[k]).append("\n");
        }
        buffer.append("[/RECALCID]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        short[] tabids = this.getRecalcIdArray();
        short length = (short)(tabids.length * 2);
        int byteoffset = 4;
        LittleEndian.putShort(data, 0 + offset, (short)449);
        LittleEndian.putShort(data, 2 + offset, length);
        for (int k = 0; k < length / 2; ++k) {
            LittleEndian.putShort(data, byteoffset + offset, tabids[k]);
            byteoffset += 2;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.getRecalcIdArray().length * 2;
    }

    public short getSid() {
        return 449;
    }
}

