/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.HexDump;
import org.apache.poi1.util.LittleEndian;
import org.apache.poi1.util.StringUtil;

public class SeriesTextRecord
extends Record {
    public static final short sid = 4109;
    private short field_1_id;
    private byte field_2_textLength;
    private byte field_3_undocumented;
    private String field_4_text;

    public SeriesTextRecord() {
    }

    public SeriesTextRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4109) {
            throw new RecordFormatException("Not a SeriesText record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_id = in.readShort();
        this.field_2_textLength = in.readByte();
        this.field_3_undocumented = in.readByte();
        this.field_4_text = in.readUnicodeLEString(this.field_2_textLength);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SERIESTEXT]\n");
        buffer.append("    .id                   = ").append("0x").append(HexDump.toHex(this.getId())).append(" (").append(this.getId()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .textLength           = ").append("0x").append(HexDump.toHex(this.getTextLength())).append(" (").append(this.getTextLength()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .undocumented         = ").append("0x").append(HexDump.toHex(this.getUndocumented())).append(" (").append(this.getUndocumented()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .text                 = ").append(" (").append(this.getText()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/SERIESTEXT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4109);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_id);
        data[6 + offset + pos] = this.field_2_textLength;
        data[7 + offset + pos] = this.field_3_undocumented;
        StringUtil.putUnicodeLE(this.field_4_text, data, 8 + offset + pos);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8 + this.field_2_textLength * 2;
    }

    public short getSid() {
        return 4109;
    }

    public Object clone() {
        SeriesTextRecord rec = new SeriesTextRecord();
        rec.field_1_id = this.field_1_id;
        rec.field_2_textLength = this.field_2_textLength;
        rec.field_3_undocumented = this.field_3_undocumented;
        rec.field_4_text = this.field_4_text;
        return rec;
    }

    public short getId() {
        return this.field_1_id;
    }

    public void setId(short field_1_id) {
        this.field_1_id = field_1_id;
    }

    public byte getTextLength() {
        return this.field_2_textLength;
    }

    public void setTextLength(byte field_2_textLength) {
        this.field_2_textLength = field_2_textLength;
    }

    public byte getUndocumented() {
        return this.field_3_undocumented;
    }

    public void setUndocumented(byte field_3_undocumented) {
        this.field_3_undocumented = field_3_undocumented;
    }

    public String getText() {
        return this.field_4_text;
    }

    public void setText(String field_4_text) {
        this.field_4_text = field_4_text;
    }
}

