/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.BitField;
import org.apache.poi1.util.BitFieldFactory;
import org.apache.poi1.util.HexDump;
import org.apache.poi1.util.LittleEndian;

public class TickRecord
extends Record {
    public static final short sid = 4126;
    private byte field_1_majorTickType;
    private byte field_2_minorTickType;
    private byte field_3_labelPosition;
    private byte field_4_background;
    private int field_5_labelColorRgb;
    private int field_6_zero1;
    private int field_7_zero2;
    private int field_8_zero3;
    private int field_9_zero4;
    private short field_10_options;
    private BitField autoTextColor = BitFieldFactory.getInstance(1);
    private BitField autoTextBackground = BitFieldFactory.getInstance(2);
    private BitField rotation = BitFieldFactory.getInstance(28);
    private BitField autorotate = BitFieldFactory.getInstance(32);
    private short field_11_tickColor;
    private short field_12_zero5;

    public TickRecord() {
    }

    public TickRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4126) {
            throw new RecordFormatException("Not a Tick record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_majorTickType = in.readByte();
        this.field_2_minorTickType = in.readByte();
        this.field_3_labelPosition = in.readByte();
        this.field_4_background = in.readByte();
        this.field_5_labelColorRgb = in.readInt();
        this.field_6_zero1 = in.readInt();
        this.field_7_zero2 = in.readInt();
        this.field_8_zero3 = in.readInt();
        this.field_9_zero4 = in.readInt();
        this.field_10_options = in.readShort();
        this.field_11_tickColor = in.readShort();
        this.field_12_zero5 = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TICK]\n");
        buffer.append("    .majorTickType        = ").append("0x").append(HexDump.toHex(this.getMajorTickType())).append(" (").append(this.getMajorTickType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .minorTickType        = ").append("0x").append(HexDump.toHex(this.getMinorTickType())).append(" (").append(this.getMinorTickType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .labelPosition        = ").append("0x").append(HexDump.toHex(this.getLabelPosition())).append(" (").append(this.getLabelPosition()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .background           = ").append("0x").append(HexDump.toHex(this.getBackground())).append(" (").append(this.getBackground()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .labelColorRgb        = ").append("0x").append(HexDump.toHex(this.getLabelColorRgb())).append(" (").append(this.getLabelColorRgb()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .zero1                = ").append("0x").append(HexDump.toHex(this.getZero1())).append(" (").append(this.getZero1()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .zero2                = ").append("0x").append(HexDump.toHex(this.getZero2())).append(" (").append(this.getZero2()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .autoTextColor            = ").append(this.isAutoTextColor()).append('\n');
        buffer.append("         .autoTextBackground       = ").append(this.isAutoTextBackground()).append('\n');
        buffer.append("         .rotation                 = ").append(this.getRotation()).append('\n');
        buffer.append("         .autorotate               = ").append(this.isAutorotate()).append('\n');
        buffer.append("    .tickColor            = ").append("0x").append(HexDump.toHex(this.getTickColor())).append(" (").append(this.getTickColor()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .zero3                = ").append("0x").append(HexDump.toHex(this.getZero3())).append(" (").append(this.getZero3()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/TICK]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4126);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        data[4 + offset + pos] = this.field_1_majorTickType;
        data[5 + offset + pos] = this.field_2_minorTickType;
        data[6 + offset + pos] = this.field_3_labelPosition;
        data[7 + offset + pos] = this.field_4_background;
        LittleEndian.putInt(data, 8 + offset + pos, this.field_5_labelColorRgb);
        LittleEndian.putInt(data, 12 + offset + pos, this.field_6_zero1);
        LittleEndian.putInt(data, 16 + offset + pos, this.field_7_zero2);
        LittleEndian.putInt(data, 20 + offset + pos, this.field_8_zero3);
        LittleEndian.putInt(data, 24 + offset + pos, this.field_9_zero4);
        LittleEndian.putShort(data, 28 + offset + pos, this.field_10_options);
        LittleEndian.putShort(data, 30 + offset + pos, this.field_11_tickColor);
        LittleEndian.putShort(data, 32 + offset + pos, this.field_12_zero5);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 34;
    }

    public short getSid() {
        return 4126;
    }

    public Object clone() {
        TickRecord rec = new TickRecord();
        rec.field_1_majorTickType = this.field_1_majorTickType;
        rec.field_2_minorTickType = this.field_2_minorTickType;
        rec.field_3_labelPosition = this.field_3_labelPosition;
        rec.field_4_background = this.field_4_background;
        rec.field_5_labelColorRgb = this.field_5_labelColorRgb;
        rec.field_6_zero1 = this.field_6_zero1;
        rec.field_7_zero2 = this.field_7_zero2;
        rec.field_8_zero3 = this.field_8_zero3;
        rec.field_9_zero4 = this.field_9_zero4;
        rec.field_10_options = this.field_10_options;
        rec.field_11_tickColor = this.field_11_tickColor;
        rec.field_12_zero5 = this.field_12_zero5;
        return rec;
    }

    public byte getMajorTickType() {
        return this.field_1_majorTickType;
    }

    public void setMajorTickType(byte field_1_majorTickType) {
        this.field_1_majorTickType = field_1_majorTickType;
    }

    public byte getMinorTickType() {
        return this.field_2_minorTickType;
    }

    public void setMinorTickType(byte field_2_minorTickType) {
        this.field_2_minorTickType = field_2_minorTickType;
    }

    public byte getLabelPosition() {
        return this.field_3_labelPosition;
    }

    public void setLabelPosition(byte field_3_labelPosition) {
        this.field_3_labelPosition = field_3_labelPosition;
    }

    public byte getBackground() {
        return this.field_4_background;
    }

    public void setBackground(byte field_4_background) {
        this.field_4_background = field_4_background;
    }

    public int getLabelColorRgb() {
        return this.field_5_labelColorRgb;
    }

    public void setLabelColorRgb(int field_5_labelColorRgb) {
        this.field_5_labelColorRgb = field_5_labelColorRgb;
    }

    public int getZero1() {
        return this.field_6_zero1;
    }

    public void setZero1(int field_6_zero1) {
        this.field_6_zero1 = field_6_zero1;
    }

    public int getZero2() {
        return this.field_7_zero2;
    }

    public void setZero2(int field_7_zero2) {
        this.field_7_zero2 = field_7_zero2;
    }

    public short getOptions() {
        return this.field_10_options;
    }

    public void setOptions(short field_10_options) {
        this.field_10_options = field_10_options;
    }

    public short getTickColor() {
        return this.field_11_tickColor;
    }

    public void setTickColor(short field_11_tickColor) {
        this.field_11_tickColor = field_11_tickColor;
    }

    public short getZero3() {
        return this.field_12_zero5;
    }

    public void setZero3(short field_12_zero3) {
        this.field_12_zero5 = field_12_zero3;
    }

    public void setAutoTextColor(boolean value) {
        this.field_10_options = this.autoTextColor.setShortBoolean(this.field_10_options, value);
    }

    public boolean isAutoTextColor() {
        return this.autoTextColor.isSet(this.field_10_options);
    }

    public void setAutoTextBackground(boolean value) {
        this.field_10_options = this.autoTextBackground.setShortBoolean(this.field_10_options, value);
    }

    public boolean isAutoTextBackground() {
        return this.autoTextBackground.isSet(this.field_10_options);
    }

    public void setRotation(short value) {
        this.field_10_options = this.rotation.setShortValue(this.field_10_options, value);
    }

    public short getRotation() {
        return this.rotation.getShortValue(this.field_10_options);
    }

    public void setAutorotate(boolean value) {
        this.field_10_options = this.autorotate.setShortBoolean(this.field_10_options, value);
    }

    public boolean isAutorotate() {
        return this.autorotate.isSet(this.field_10_options);
    }
}

