/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record.formula;

import org.apache.poi1.hssf.model.Workbook;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.hssf.record.formula.Ptg;
import org.apache.poi1.util.LittleEndian;

public class MemAreaPtg
extends Ptg {
    public static final short sid = 38;
    private static final int SIZE = 7;
    private int field_1_reserved;
    private short field_2_subex_len;

    public MemAreaPtg() {
    }

    public MemAreaPtg(RecordInputStream in) {
        this.field_1_reserved = in.readInt();
        this.field_2_subex_len = in.readShort();
    }

    public void setReserved(int res) {
        this.field_1_reserved = res;
    }

    public int getReserved() {
        return this.field_1_reserved;
    }

    public void setSubexpressionLength(short subexlen) {
        this.field_2_subex_len = subexlen;
    }

    public short getSubexpressionLength() {
        return this.field_2_subex_len;
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(38 + this.ptgClass);
        LittleEndian.putInt(array, offset + 1, this.field_1_reserved);
        LittleEndian.putShort(array, offset + 5, this.field_2_subex_len);
    }

    public int getSize() {
        return 7;
    }

    public String toFormulaString(Workbook book) {
        return "";
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public Object clone() {
        MemAreaPtg ptg = new MemAreaPtg();
        ptg.field_1_reserved = this.field_1_reserved;
        ptg.field_2_subex_len = this.field_2_subex_len;
        return ptg;
    }
}

