/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.usermodel;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class FontDetails {
    private String fontName;
    private int height;
    private Map charWidths = new HashMap();

    public FontDetails(String fontName, int height) {
        this.fontName = fontName;
        this.height = height;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getHeight() {
        return this.height;
    }

    public void addChar(char c, int width) {
        this.charWidths.put(new Character(c), new Integer(width));
    }

    public int getCharWidth(char c) {
        Integer widthInteger = (Integer)this.charWidths.get(new Character(c));
        if (widthInteger == null && c != 'W') {
            return this.getCharWidth('W');
        }
        return widthInteger;
    }

    public void addChars(char[] characters, int[] widths) {
        for (int i = 0; i < characters.length; ++i) {
            this.charWidths.put(new Character(characters[i]), new Integer(widths[i]));
        }
    }

    public static FontDetails create(String fontName, Properties fontMetricsProps) {
        String[] widthsStrArray;
        String heightStr = fontMetricsProps.getProperty("font." + fontName + ".height");
        String widthsStr = fontMetricsProps.getProperty("font." + fontName + ".widths");
        String charactersStr = fontMetricsProps.getProperty("font." + fontName + ".characters");
        int height = Integer.parseInt(heightStr);
        FontDetails d = new FontDetails(fontName, height);
        String[] charactersStrArray = FontDetails.split(charactersStr, ",", -1);
        if (charactersStrArray.length != (widthsStrArray = FontDetails.split(widthsStr, ",", -1)).length) {
            throw new RuntimeException("Number of characters does not number of widths for font " + fontName);
        }
        for (int i = 0; i < widthsStrArray.length; ++i) {
            if (charactersStrArray[i].length() == 0) continue;
            d.addChar(charactersStrArray[i].charAt(0), Integer.parseInt(widthsStrArray[i]));
        }
        return d;
    }

    public int getStringWidth(String str) {
        int width = 0;
        for (int i = 0; i < str.length(); ++i) {
            width += this.getCharWidth(str.charAt(i));
        }
        return width;
    }

    private static String[] split(String text, String separator, int max) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int listSize = tok.countTokens();
        if (max != -1 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i = 0;
        while (tok.hasMoreTokens()) {
            if (max != -1 && i == listSize - 1) {
                StringBuffer buf = new StringBuffer(text.length() * (listSize - i) / listSize);
                while (tok.hasMoreTokens()) {
                    buf.append(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    buf.append(separator);
                }
                list[i] = buf.toString().trim();
                break;
            }
            list[i] = tok.nextToken().trim();
            ++i;
        }
        return list;
    }
}

