/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hwpf.model;

import java.util.ArrayList;
import org.apache.poi1.hwpf.model.GenericPropertyNode;
import org.apache.poi1.util.LittleEndian;

public class PlexOfCps {
    private int _count;
    private int _offset;
    private int _sizeOfStruct;
    private ArrayList _props;

    public PlexOfCps(int sizeOfStruct) {
        this._props = new ArrayList();
        this._sizeOfStruct = sizeOfStruct;
    }

    public PlexOfCps(byte[] buf, int start, int size, int sizeOfStruct) {
        this._count = (size - 4) / (4 + sizeOfStruct);
        this._sizeOfStruct = sizeOfStruct;
        this._props = new ArrayList(this._count);
        for (int x = 0; x < this._count; ++x) {
            this._props.add(this.getProperty(x, buf, start));
        }
    }

    public GenericPropertyNode getProperty(int index) {
        return (GenericPropertyNode)this._props.get(index);
    }

    public void addProperty(GenericPropertyNode node) {
        this._props.add(node);
    }

    public byte[] toByteArray() {
        int size = this._props.size();
        int cpBufSize = (size + 1) * 4;
        int structBufSize = this._sizeOfStruct * size;
        int bufSize = cpBufSize + structBufSize;
        byte[] buf = new byte[bufSize];
        GenericPropertyNode node = null;
        for (int x = 0; x < size; ++x) {
            node = (GenericPropertyNode)this._props.get(x);
            LittleEndian.putInt(buf, 4 * x, node.getStart());
            System.arraycopy(node.getBytes(), 0, buf, cpBufSize + x * this._sizeOfStruct, this._sizeOfStruct);
        }
        LittleEndian.putInt(buf, 4 * size, node.getEnd());
        return buf;
    }

    private GenericPropertyNode getProperty(int index, byte[] buf, int offset) {
        int start = LittleEndian.getInt(buf, offset + this.getIntOffset(index));
        int end = LittleEndian.getInt(buf, offset + this.getIntOffset(index + 1));
        byte[] struct = new byte[this._sizeOfStruct];
        System.arraycopy(buf, offset + this.getStructOffset(index), struct, 0, this._sizeOfStruct);
        return new GenericPropertyNode(start, end, struct);
    }

    private int getIntOffset(int index) {
        return index * 4;
    }

    public int length() {
        return this._count;
    }

    private int getStructOffset(int index) {
        return 4 * (this._count + 1) + this._sizeOfStruct * index;
    }
}

