/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.poifs.filesystem;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi1.poifs.dev.POIFSViewable;
import org.apache.poi1.poifs.filesystem.BATManaged;
import org.apache.poi1.poifs.filesystem.DirectoryEntry;
import org.apache.poi1.poifs.filesystem.DirectoryNode;
import org.apache.poi1.poifs.filesystem.DocumentEntry;
import org.apache.poi1.poifs.filesystem.DocumentInputStream;
import org.apache.poi1.poifs.filesystem.DocumentNode;
import org.apache.poi1.poifs.filesystem.Entry;
import org.apache.poi1.poifs.filesystem.EntryNode;
import org.apache.poi1.poifs.filesystem.POIFSDocument;
import org.apache.poi1.poifs.filesystem.POIFSWriterListener;
import org.apache.poi1.poifs.property.DirectoryProperty;
import org.apache.poi1.poifs.property.Property;
import org.apache.poi1.poifs.property.PropertyTable;
import org.apache.poi1.poifs.storage.BATBlock;
import org.apache.poi1.poifs.storage.BlockAllocationTableReader;
import org.apache.poi1.poifs.storage.BlockAllocationTableWriter;
import org.apache.poi1.poifs.storage.BlockList;
import org.apache.poi1.poifs.storage.BlockWritable;
import org.apache.poi1.poifs.storage.HeaderBlockReader;
import org.apache.poi1.poifs.storage.HeaderBlockWriter;
import org.apache.poi1.poifs.storage.RawDataBlockList;
import org.apache.poi1.poifs.storage.SmallBlockTableReader;
import org.apache.poi1.poifs.storage.SmallBlockTableWriter;

public class POIFSFileSystem
implements POIFSViewable {
    private PropertyTable _property_table = new PropertyTable();
    private List _documents = new ArrayList();
    private DirectoryNode _root = null;

    public POIFSFileSystem() {
    }

    public POIFSFileSystem(InputStream stream) throws IOException {
        this();
        HeaderBlockReader header_block_reader = new HeaderBlockReader(stream);
        RawDataBlockList data_blocks = new RawDataBlockList(stream);
        new BlockAllocationTableReader(header_block_reader.getBATCount(), header_block_reader.getBATArray(), header_block_reader.getXBATCount(), header_block_reader.getXBATIndex(), data_blocks);
        PropertyTable properties = new PropertyTable(header_block_reader.getPropertyStart(), data_blocks);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks(data_blocks, properties.getRoot(), header_block_reader.getSBATStart()), data_blocks, properties.getRoot().getChildren(), null);
    }

    public DocumentEntry createDocument(InputStream stream, String name) throws IOException {
        return this.getRoot().createDocument(name, stream);
    }

    public DocumentEntry createDocument(String name, int size, POIFSWriterListener writer) throws IOException {
        return this.getRoot().createDocument(name, size, writer);
    }

    public DirectoryEntry createDirectory(String name) throws IOException {
        return this.getRoot().createDirectory(name);
    }

    public void writeFilesystem(OutputStream stream) throws IOException {
        this._property_table.preWrite();
        SmallBlockTableWriter sbtw = new SmallBlockTableWriter(this._documents, this._property_table.getRoot());
        BlockAllocationTableWriter bat = new BlockAllocationTableWriter();
        ArrayList<BATManaged> bm_objects = new ArrayList<BATManaged>();
        bm_objects.addAll(this._documents);
        bm_objects.add(this._property_table);
        bm_objects.add(sbtw);
        bm_objects.add(sbtw.getSBAT());
        Iterator iter = bm_objects.iterator();
        while (iter.hasNext()) {
            BATManaged bmo = (BATManaged)iter.next();
            int block_count = bmo.countBlocks();
            if (block_count == 0) continue;
            bmo.setStartBlock(bat.allocateSpace(block_count));
        }
        int batStartBlock = bat.createBlocks();
        HeaderBlockWriter header_block_writer = new HeaderBlockWriter();
        BATBlock[] xbat_blocks = header_block_writer.setBATBlocks(bat.countBlocks(), batStartBlock);
        header_block_writer.setPropertyStart(this._property_table.getStartBlock());
        header_block_writer.setSBATStart(sbtw.getSBAT().getStartBlock());
        header_block_writer.setSBATBlockCount(sbtw.getSBATBlockCount());
        ArrayList<BlockWritable> writers = new ArrayList<BlockWritable>();
        writers.add(header_block_writer);
        writers.addAll(this._documents);
        writers.add(this._property_table);
        writers.add(sbtw);
        writers.add(sbtw.getSBAT());
        writers.add(bat);
        for (int j = 0; j < xbat_blocks.length; ++j) {
            writers.add(xbat_blocks[j]);
        }
        iter = writers.iterator();
        while (iter.hasNext()) {
            BlockWritable writer = (BlockWritable)iter.next();
            writer.writeBlocks(stream);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("two arguments required: input filename and output filename");
            System.exit(1);
        }
        FileInputStream istream = new FileInputStream(args[0]);
        FileOutputStream ostream = new FileOutputStream(args[1]);
        new POIFSFileSystem(istream).writeFilesystem(ostream);
        istream.close();
        ostream.close();
    }

    public DirectoryEntry getRoot() {
        if (this._root == null) {
            this._root = new DirectoryNode(this._property_table.getRoot(), this, null);
        }
        return this._root;
    }

    public DocumentInputStream createDocumentInputStream(String documentName) throws IOException {
        Entry document = this.getRoot().getEntry(documentName);
        if (!document.isDocumentEntry()) {
            throw new IOException("Entry '" + documentName + "' is not a DocumentEntry");
        }
        return new DocumentInputStream((DocumentEntry)document);
    }

    void addDocument(POIFSDocument document) {
        this._documents.add(document);
        this._property_table.addProperty(document.getDocumentProperty());
    }

    void addDirectory(DirectoryProperty directory) {
        this._property_table.addProperty(directory);
    }

    void remove(EntryNode entry) {
        this._property_table.removeProperty(entry.getProperty());
        if (entry.isDocumentEntry()) {
            this._documents.remove(((DocumentNode)entry).getDocument());
        }
    }

    private void processProperties(BlockList small_blocks, BlockList big_blocks, Iterator properties, DirectoryNode dir) throws IOException {
        while (properties.hasNext()) {
            DirectoryNode parent;
            Property property = (Property)properties.next();
            String name = property.getName();
            DirectoryNode directoryNode = parent = dir == null ? (DirectoryNode)this.getRoot() : dir;
            if (property.isDirectory()) {
                DirectoryNode new_dir = (DirectoryNode)parent.createDirectory(name);
                new_dir.setStorageClsid(property.getStorageClsid());
                this.processProperties(small_blocks, big_blocks, ((DirectoryProperty)property).getChildren(), new_dir);
                continue;
            }
            int startBlock = property.getStartBlock();
            int size = property.getSize();
            POIFSDocument document = null;
            document = property.shouldUseSmallBlocks() ? new POIFSDocument(name, small_blocks.fetchBlocks(startBlock), size) : new POIFSDocument(name, big_blocks.fetchBlocks(startBlock), size);
            parent.createDocument(document);
        }
    }

    public Object[] getViewableArray() {
        if (this.preferArray()) {
            return ((POIFSViewable)((Object)this.getRoot())).getViewableArray();
        }
        return new Object[0];
    }

    public Iterator getViewableIterator() {
        if (!this.preferArray()) {
            return ((POIFSViewable)((Object)this.getRoot())).getViewableIterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean preferArray() {
        return ((POIFSViewable)((Object)this.getRoot())).preferArray();
    }

    public String getShortDescription() {
        return "POIFS FileSystem";
    }
}

