/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.cp.eip.fts.app.AnalyzerManager;
import com.kingdee.eas.cp.eip.fts.app.FtsPermissionManager;
import com.kingdee.eas.cp.eip.fts.app.HighlightFinder;
import com.kingdee.eas.cp.eip.fts.app.IFtsPermission;
import com.kingdee.eas.cp.eip.fts.app.SearchException;
import com.kingdee.eas.cp.eip.fts.app.SearchParameters;
import com.kingdee.eas.cp.eip.fts.app.SearchResult;
import com.kingdee.eas.cp.eip.fts.app.SearchResultList;
import com.kingdee.eas.cp.eip.fts.app.TermHighlighterHtml;
import com.kingdee.eas.cp.eip.fts.utils.Utils;
import java.io.IOException;
import org.apache.lucene1.analysis.Analyzer;
import org.apache.lucene1.document.Document;
import org.apache.lucene1.index.Term;
import org.apache.lucene1.queryParser.ParseException;
import org.apache.lucene1.queryParser.QueryParser;
import org.apache.lucene1.search.BooleanQuery;
import org.apache.lucene1.search.Hits;
import org.apache.lucene1.search.IndexSearcher;
import org.apache.lucene1.search.Query;
import org.apache.lucene1.search.TermQuery;

public class SearchManager {
    public static final String[] C_DOC_META_FIELDS = new String[]{"title", "keyWord", "createuser", "lastUpdateUser", "content"};
    public static final String C_EXCERPT = SearchManager.class.getName() + ".createExcerpt";
    public static final String C_PERMISSIONS = SearchManager.class.getName() + ".checkPermissions";
    public static final String C_PRIORITY = SearchManager.class.getName() + ".priority";
    private static final String C_EXCERPT_FRAGMENT_SEPARATOR = " ... ";
    private static final int C_EXCERPT_FRAGMENT_SIZE = 200;
    private static final int C_EXCERPT_REQUIRED_FRAGMENTS = 5;
    private boolean m_createExcerpt = true;
    private boolean m_dontCheckPermissions = false;
    private String m_name;
    private int m_priority;
    private IObjectPK userPK;
    private IObjectPK orgPK;
    private Context context;
    private int currRecored;
    private int totalSize;

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public synchronized SearchResultList search(String dbCenterName, SearchParameters params, int page, int matchesPerPage) throws SearchException {
        IndexSearcher searcher = null;
        SearchResultList searchResults = new SearchResultList();
        try {
            searcher = new IndexSearcher(Utils.getIndexDbPath(dbCenterName));
            Analyzer languageAnalyzer = AnalyzerManager.getAnalyzer();
            Query finalQuery = this.getFinalQuery(params, searcher, languageAnalyzer);
            this.doSearchNext(params, page, matchesPerPage, searcher, searchResults, languageAnalyzer, finalQuery);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return searchResults;
    }

    private Query getFinalQuery(SearchParameters params, IndexSearcher searcher, Analyzer languageAnalyzer) throws ParseException, IOException {
        int i;
        BooleanQuery query = new BooleanQuery();
        if (params.getCategories() != null && params.getCategories().size() > 0) {
            BooleanQuery categoryQuery = new BooleanQuery();
            for (i = 0; i < params.getCategories().size(); ++i) {
                Term term = new Term("gategory", (String)params.getCategories().get(i));
                TermQuery termQuery = new TermQuery(term);
                categoryQuery.add(termQuery, false, false);
            }
            query.add(categoryQuery, true, false);
        }
        if (params.getFields() != null && params.getFields().size() > 0) {
            BooleanQuery fieldsQuery = new BooleanQuery();
            for (i = 0; i < params.getFields().size(); ++i) {
                Query t_Query = QueryParser.parse(params.getQuery(), (String)params.getFields().get(i), languageAnalyzer);
                fieldsQuery.add(t_Query, false, false);
            }
            query.add(fieldsQuery, true, false);
        } else {
            query.add(QueryParser.parse(params.getQuery(), "content", languageAnalyzer), true, false);
        }
        Query finalQuery = this.m_createExcerpt ? searcher.rewrite(query) : query;
        return finalQuery;
    }

    private void doSearchPage(SearchParameters params, int page, int matchesPerPage, IndexSearcher searcher, SearchResultList searchResults, Analyzer languageAnalyzer, Query finalQuery) throws IOException, BOSException {
        Hits hits = searcher.search(finalQuery, params.getSort());
        int hitCount = hits.length();
        this.setTotalSize(hitCount);
        String excerpt = null;
        if (hits != null) {
            int start = -1;
            int end = -1;
            if (matchesPerPage > 0 && page > 0 && hitCount > 0) {
                start = matchesPerPage * (page - 1);
                end = start + matchesPerPage;
                start = start > hitCount ? hitCount : start;
                end = end > hitCount ? hitCount : end;
            } else {
                start = 0;
                end = hitCount;
            }
            int cnt = 0;
            for (int i = 0; i < hitCount && cnt < end; ++i) {
                Document doc = hits.doc(i);
                if (!this.hasReadPermission(doc)) continue;
                if (cnt >= start) {
                    if (this.m_createExcerpt) {
                        excerpt = this.getExcerpt(doc.getField("content").stringValue(), finalQuery, languageAnalyzer);
                    }
                    SearchResult searchResult = new SearchResult(cnt + 1, Math.round(hits.score(i) * 100.0f), doc, excerpt);
                    searchResults.add(searchResult);
                }
                ++cnt;
            }
            searchResults.setHitCount(hitCount);
        }
    }

    private void doSearchNext(SearchParameters params, int page, int matchesPerPage, IndexSearcher searcher, SearchResultList searchResults, Analyzer languageAnalyzer, Query finalQuery) throws IOException, BOSException {
        Hits hits = searcher.search(finalQuery, params.getSort());
        int hitCount = hits.length();
        this.setTotalSize(hitCount);
        String excerpt = null;
        if (hits != null) {
            int start = -1;
            int end = -1;
            if (matchesPerPage > 0 && hitCount > 0) {
                start = page;
                end = start + matchesPerPage;
                start = start > hitCount ? hitCount : start;
                end = end > hitCount ? hitCount : end;
            } else {
                start = 0;
                end = hitCount;
            }
            int cnt = 0;
            for (int i = start; i < hitCount; ++i) {
                Document doc = hits.doc(i);
                if (this.hasReadPermission(doc)) {
                    if (this.m_createExcerpt) {
                        excerpt = doc.getField("content") != null && doc.getField("content").stringValue() != null ? this.getExcerpt(doc.getField("content").stringValue(), finalQuery, languageAnalyzer) : null;
                    }
                    SearchResult searchResult = new SearchResult(i, Math.round(hits.score(i) * 100.0f), doc, excerpt);
                    searchResults.add(searchResult);
                    ++cnt;
                }
                ++start;
            }
            this.setCurrRecored(start);
            searchResults.setHitCount(hitCount);
        }
    }

    private boolean hasReadPermission(Document doc) throws BOSException {
        if (this.isDontCheckPermissions()) {
            return true;
        }
        String gategory = doc.getField("gategory").stringValue();
        String id = doc.getField("uuid").stringValue();
        if (id == null || id.length() < 1) {
            return true;
        }
        IFtsPermission perm = FtsPermissionManager.INSTANCE.getPermission(gategory);
        if (perm == null) {
            return true;
        }
        return perm.hasReadPermission(this.context, Utils.getBosId(id), this);
    }

    private String getExcerpt(String content, Query searchQuery, Analyzer analyzer) throws IOException {
        if (content == null) {
            return null;
        }
        TermHighlighterHtml termHighlighterHtml = new TermHighlighterHtml();
        HighlightFinder highlighter = new HighlightFinder(termHighlighterHtml, searchQuery, analyzer);
        String excerpt = highlighter.getBestFragments(content, 200, 5, C_EXCERPT_FRAGMENT_SEPARATOR);
        excerpt = excerpt.replace('\t', ' ');
        excerpt = excerpt.replace('\n', ' ');
        excerpt = excerpt.replace('\r', ' ');
        excerpt = excerpt.replace('\f', ' ');
        int maxLength = 200;
        int lightLen = highlighter.getScore() * termHighlighterHtml.highlightLength();
        if (excerpt != null && excerpt.length() > maxLength + lightLen) {
            excerpt = excerpt.substring(0, maxLength + lightLen);
        }
        return excerpt;
    }

    public boolean isCreateExcerpt() {
        return this.m_createExcerpt;
    }

    public void setCreateExcerpt(boolean excerpt) {
        this.m_createExcerpt = excerpt;
    }

    public boolean isDontCheckPermissions() {
        return this.m_dontCheckPermissions;
    }

    public void setDontCheckPermissions(boolean checkPermissions) {
        this.m_dontCheckPermissions = checkPermissions;
    }

    public String getName() {
        return this.m_name;
    }

    public void setNname(String m_name) {
        this.m_name = m_name;
    }

    public int getPriority() {
        return this.m_priority;
    }

    public void setPriority(int m_priority) {
        this.m_priority = m_priority;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public IObjectPK getOrgPK() {
        return this.orgPK;
    }

    public void setOrgPK(IObjectPK orgPK) {
        this.orgPK = orgPK;
    }

    public IObjectPK getUserPK() {
        return this.userPK;
    }

    public void setUserPK(IObjectPK userPK) {
        this.userPK = userPK;
    }

    public int getCurrRecored() {
        return this.currRecored;
    }

    public void setCurrRecored(int currRecored) {
        this.currRecored = currRecored;
    }
}

