/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.documents;

import com.kingdee.eas.cp.eip.fts.documents.A_TextExtractor;
import com.kingdee.eas.cp.eip.fts.documents.ExtractionResult;
import com.kingdee.eas.cp.eip.fts.documents.I_ExtractionResult;
import com.kingdee.eas.cp.eip.fts.documents.I_TextExtractor;
import java.io.InputStream;
import org.pdfbox.encryption.DocumentEncryption;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.util.PDFTextStripper;

public class ExtractorPdf
extends A_TextExtractor {
    private static final ExtractorPdf INSTANCE = new ExtractorPdf();

    private ExtractorPdf() {
    }

    public static I_TextExtractor getExtractor() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I_ExtractionResult extractText(InputStream in, String encoding) throws Exception {
        PDDocument pdfDocument = null;
        try {
            PDFParser parser = new PDFParser(in);
            parser.parse();
            pdfDocument = parser.getPDDocument();
            if (pdfDocument.isEncrypted()) {
                DocumentEncryption decryptor = new DocumentEncryption(pdfDocument);
                decryptor.decryptDocument("");
            }
            PDFTextStripper stripper = new PDFTextStripper();
            PDDocumentInformation info = pdfDocument.getDocumentInformation();
            String result = stripper.getText(pdfDocument);
            ExtractionResult extractionResult = new ExtractionResult(result);
            return extractionResult;
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }
}

