/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.document;

import java.io.Reader;
import java.io.Serializable;
import java.util.Date;
import org.apache.lucene1.document.DateField;

public final class Field
implements Serializable {
    private String name = "body";
    private String stringValue = null;
    private boolean storeTermVector = false;
    private Reader readerValue = null;
    private boolean isStored = false;
    private boolean isIndexed = true;
    private boolean isTokenized = true;
    private float boost = 1.0f;

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public float getBoost() {
        return this.boost;
    }

    public static final Field Keyword(String name, String value) {
        return new Field(name, value, true, true, false);
    }

    public static final Field UnIndexed(String name, String value) {
        return new Field(name, value, true, false, false);
    }

    public static final Field Text(String name, String value) {
        return Field.Text(name, value, false);
    }

    public static final Field Keyword(String name, Date value) {
        return new Field(name, DateField.dateToString(value), true, true, false);
    }

    public static final Field Text(String name, String value, boolean storeTermVector) {
        return new Field(name, value, true, true, true, storeTermVector);
    }

    public static final Field UnStored(String name, String value) {
        return Field.UnStored(name, value, false);
    }

    public static final Field UnStored(String name, String value, boolean storeTermVector) {
        return new Field(name, value, false, true, true, storeTermVector);
    }

    public static final Field Text(String name, Reader value) {
        return Field.Text(name, value, false);
    }

    public static final Field Text(String name, Reader value, boolean storeTermVector) {
        Field f = new Field(name, value);
        f.storeTermVector = storeTermVector;
        return f;
    }

    public String name() {
        return this.name;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public Reader readerValue() {
        return this.readerValue;
    }

    public Field(String name, String string, boolean store, boolean index, boolean token) {
        this(name, string, store, index, token, false);
    }

    public Field(String name, String string, boolean store, boolean index, boolean token, boolean storeTermVector) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        if (!index && storeTermVector) {
            throw new IllegalArgumentException("cannot store a term vector for fields that are not indexed.");
        }
        this.name = name.intern();
        this.stringValue = string;
        this.isStored = store;
        this.isIndexed = index;
        this.isTokenized = token;
        this.storeTermVector = storeTermVector;
    }

    Field(String name, Reader reader) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.name = name.intern();
        this.readerValue = reader;
    }

    public final boolean isStored() {
        return this.isStored;
    }

    public final boolean isIndexed() {
        return this.isIndexed;
    }

    public final boolean isTokenized() {
        return this.isTokenized;
    }

    public final boolean isTermVectorStored() {
        return this.storeTermVector;
    }

    public final String toString() {
        if (this.isStored && this.isIndexed && !this.isTokenized) {
            return "Keyword<" + this.name + ":" + this.stringValue + ">";
        }
        if (this.isStored && !this.isIndexed && !this.isTokenized) {
            return "Unindexed<" + this.name + ":" + this.stringValue + ">";
        }
        if (this.isStored && this.isIndexed && this.isTokenized && this.stringValue != null) {
            return "Text<" + this.name + ":" + this.stringValue + ">";
        }
        if (!this.isStored && this.isIndexed && this.isTokenized && this.readerValue != null) {
            return "Text<" + this.name + ":" + this.readerValue + ">";
        }
        if (!this.isStored && this.isIndexed && this.isTokenized) {
            return "UnStored<" + this.name + ">";
        }
        return super.toString();
    }
}

