/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.lucene1.document.Document;
import org.apache.lucene1.index.IndexReader;
import org.apache.lucene1.index.MultiTermDocs;
import org.apache.lucene1.index.MultiTermEnum;
import org.apache.lucene1.index.MultiTermPositions;
import org.apache.lucene1.index.SegmentInfos;
import org.apache.lucene1.index.Term;
import org.apache.lucene1.index.TermDocs;
import org.apache.lucene1.index.TermEnum;
import org.apache.lucene1.index.TermFreqVector;
import org.apache.lucene1.index.TermPositions;
import org.apache.lucene1.store.Directory;

public class MultiReader
extends IndexReader {
    private IndexReader[] subReaders;
    private int[] starts;
    private Hashtable normsCache = new Hashtable();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;

    public MultiReader(IndexReader[] subReaders) throws IOException {
        super(subReaders.length == 0 ? null : subReaders[0].directory());
        this.initialize(subReaders);
    }

    MultiReader(Directory directory, SegmentInfos sis, boolean closeDirectory, IndexReader[] subReaders) throws IOException {
        super(directory, sis, closeDirectory);
        this.initialize(subReaders);
    }

    private void initialize(IndexReader[] subReaders) throws IOException {
        this.subReaders = subReaders;
        this.starts = new int[subReaders.length + 1];
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += subReaders[i].maxDoc();
            if (!subReaders[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[subReaders.length] = this.maxDoc;
    }

    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVectors(n - this.starts[i]);
    }

    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVector(n - this.starts[i], field);
    }

    public synchronized int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public Document document(int n) throws IOException {
        int i = this.readerIndex(n);
        return this.subReaders[i].document(n - this.starts[i]);
    }

    public boolean isDeleted(int n) {
        int i = this.readerIndex(n);
        return this.subReaders[i].isDeleted(n - this.starts[i]);
    }

    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    protected void doDelete(int n) throws IOException {
        this.numDocs = -1;
        int i = this.readerIndex(n);
        this.subReaders[i].delete(n - this.starts[i]);
        this.hasDeletions = true;
    }

    protected void doUndeleteAll() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
    }

    private int readerIndex(int n) {
        int lo = 0;
        int hi = this.subReaders.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.subReaders.length && this.starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    public synchronized byte[] norms(String field) throws IOException {
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes != null) {
            return bytes;
        }
        bytes = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, bytes, this.starts[i]);
        }
        this.normsCache.put(field, bytes);
        return bytes;
    }

    public synchronized void norms(String field, byte[] result, int offset) throws IOException {
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes != null) {
            System.arraycopy(bytes, 0, result, offset, this.maxDoc());
        }
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, result, offset + this.starts[i]);
        }
    }

    protected void doSetNorm(int n, String field, byte value) throws IOException {
        this.normsCache.remove(field);
        int i = this.readerIndex(n);
        this.subReaders[i].setNorm(n - this.starts[i], field, value);
    }

    public TermEnum terms() throws IOException {
        return new MultiTermEnum(this.subReaders, this.starts, null);
    }

    public TermEnum terms(Term term) throws IOException {
        return new MultiTermEnum(this.subReaders, this.starts, term);
    }

    public int docFreq(Term t) throws IOException {
        int total = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            total += this.subReaders[i].docFreq(t);
        }
        return total;
    }

    public TermDocs termDocs() throws IOException {
        return new MultiTermDocs(this.subReaders, this.starts);
    }

    public TermPositions termPositions() throws IOException {
        return new MultiTermPositions(this.subReaders, this.starts);
    }

    protected void doCommit() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].commit();
        }
    }

    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].close();
        }
    }

    public Collection getFieldNames() throws IOException {
        HashSet<String> fieldSet = new HashSet<String>();
        for (int i = 0; i < this.subReaders.length; ++i) {
            IndexReader reader = this.subReaders[i];
            Collection names = reader.getFieldNames();
            Iterator iterator = names.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                fieldSet.add(s);
            }
        }
        return fieldSet;
    }

    public Collection getFieldNames(boolean indexed) throws IOException {
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < this.subReaders.length; ++i) {
            IndexReader reader = this.subReaders[i];
            Collection names = reader.getFieldNames(indexed);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }

    public Collection getIndexedFieldNames(boolean storedTermVector) {
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < this.subReaders.length; ++i) {
            IndexReader reader = this.subReaders[i];
            Collection names = reader.getIndexedFieldNames(storedTermVector);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }
}

