/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene1.index.IndexReader;
import org.apache.lucene1.search.Explanation;
import org.apache.lucene1.search.Filter;
import org.apache.lucene1.search.Query;
import org.apache.lucene1.search.Scorer;
import org.apache.lucene1.search.Searcher;
import org.apache.lucene1.search.Weight;

public class FilteredQuery
extends Query {
    Query query;
    Filter filter;

    public FilteredQuery(Query query, Filter filter) {
        this.query = query;
        this.filter = filter;
    }

    protected Weight createWeight(final Searcher searcher) {
        final Weight weight = this.query.createWeight(searcher);
        return new Weight(){

            public float getValue() {
                return weight.getValue();
            }

            public float sumOfSquaredWeights() throws IOException {
                return weight.sumOfSquaredWeights();
            }

            public void normalize(float v) {
                weight.normalize(v);
            }

            public Explanation explain(IndexReader ir, int i) throws IOException {
                return weight.explain(ir, i);
            }

            public Query getQuery() {
                return FilteredQuery.this;
            }

            public Scorer scorer(IndexReader indexReader) throws IOException {
                Scorer scorer = weight.scorer(indexReader);
                BitSet bitset = FilteredQuery.this.filter.bits(indexReader);
                return new Scorer(this, FilteredQuery.this.query.getSimilarity(searcher), scorer, bitset){
                    private final /* synthetic */ Scorer val$scorer;
                    private final /* synthetic */ BitSet val$bitset;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$scorer = val$scorer;
                        this.val$bitset = val$bitset;
                        super(x0);
                    }

                    public boolean next() throws IOException {
                        return this.val$scorer.next();
                    }

                    public int doc() {
                        return this.val$scorer.doc();
                    }

                    public boolean skipTo(int i) throws IOException {
                        return this.val$scorer.skipTo(i);
                    }

                    public float score() throws IOException {
                        return this.val$bitset.get(this.val$scorer.doc()) ? this.val$scorer.score() : 0.0f;
                    }

                    public Explanation explain(int i) throws IOException {
                        Explanation exp = this.val$scorer.explain(i);
                        if (this.val$bitset.get(i)) {
                            exp.setDescription("allowed by filter: " + exp.getDescription());
                        } else {
                            exp.setDescription("removed by filter: " + exp.getDescription());
                        }
                        return exp;
                    }
                };
            }
        };
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (rewritten != this.query) {
            FilteredQuery clone = (FilteredQuery)this.clone();
            clone.query = rewritten;
            return clone;
        }
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public String toString(String s) {
        return "filtered(" + this.query.toString(s) + ")->" + this.filter;
    }

    public boolean equals(Object o) {
        if (o instanceof FilteredQuery) {
            FilteredQuery fq = (FilteredQuery)o;
            return this.query.equals(fq.query) && this.filter.equals(fq.filter);
        }
        return false;
    }

    public int hashCode() {
        return this.query.hashCode() ^ this.filter.hashCode();
    }
}

