/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.LittleEndian;

public class EndRecord
extends Record {
    public static final short sid = 4148;

    public EndRecord() {
    }

    public EndRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4148) {
            throw new RecordFormatException("NOT An END RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[END]\n");
        buffer.append("[/END]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4148);
        LittleEndian.putShort(data, 2 + offset, (short)0);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4;
    }

    public short getSid() {
        return 4148;
    }
}

