/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.LittleEndian;

public class MergeCellsRecord
extends Record {
    public static final short sid = 229;
    private ArrayList field_2_regions;

    public MergeCellsRecord() {
    }

    public MergeCellsRecord(RecordInputStream in) {
        super(in);
    }

    protected void fillFields(RecordInputStream in) {
        int numAreas = in.readShort();
        this.field_2_regions = new ArrayList(numAreas + 10);
        for (int k = 0; k < numAreas; ++k) {
            MergedRegion region = new MergedRegion(in.readShort(), in.readShort(), in.readShort(), in.readShort());
            this.field_2_regions.add(region);
        }
    }

    public short getNumAreas() {
        if (this.field_2_regions == null) {
            return 0;
        }
        return (short)this.field_2_regions.size();
    }

    public void setNumAreas(short numareas) {
    }

    public int addArea(int rowfrom, short colfrom, int rowto, short colto) {
        if (this.field_2_regions == null) {
            this.field_2_regions = new ArrayList(10);
        }
        MergedRegion region = new MergedRegion(rowfrom, rowto, colfrom, colto);
        this.field_2_regions.add(region);
        return this.field_2_regions.size() - 1;
    }

    public void removeAreaAt(int area) {
        this.field_2_regions.remove(area);
    }

    public MergedRegion getAreaAt(int index) {
        return (MergedRegion)this.field_2_regions.get(index);
    }

    public int getRecordSize() {
        int retValue = 6 + 8 * this.field_2_regions.size();
        return retValue;
    }

    public short getSid() {
        return 229;
    }

    public int serialize(int offset, byte[] data) {
        int recordsize = this.getRecordSize();
        int pos = 6;
        LittleEndian.putShort(data, offset + 0, (short)229);
        LittleEndian.putShort(data, offset + 2, (short)(recordsize - 4));
        LittleEndian.putShort(data, offset + 4, this.getNumAreas());
        for (int k = 0; k < this.getNumAreas(); ++k) {
            MergedRegion region = this.getAreaAt(k);
            LittleEndian.putShort(data, offset + pos, (short)region.row_from);
            LittleEndian.putShort(data, offset + (pos += 2), (short)region.row_to);
            LittleEndian.putShort(data, offset + (pos += 2), region.col_from);
            LittleEndian.putShort(data, offset + (pos += 2), region.col_to);
            pos += 2;
        }
        return recordsize;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append("[MERGEDCELLS]").append("\n");
        retval.append("     .sid        =").append(229).append("\n");
        retval.append("     .numregions =").append(this.getNumAreas()).append("\n");
        for (int k = 0; k < this.getNumAreas(); ++k) {
            MergedRegion region = (MergedRegion)this.field_2_regions.get(k);
            retval.append("     .rowfrom    =").append(region.row_from).append("\n");
            retval.append("     .colfrom    =").append(region.col_from).append("\n");
            retval.append("     .rowto      =").append(region.row_to).append("\n");
            retval.append("     .colto      =").append(region.col_to).append("\n");
        }
        retval.append("[MERGEDCELLS]").append("\n");
        return retval.toString();
    }

    protected void validateSid(short id) {
        if (id != 229) {
            throw new RecordFormatException("NOT A MERGEDCELLS RECORD!! " + id);
        }
    }

    public Object clone() {
        MergeCellsRecord rec = new MergeCellsRecord();
        rec.field_2_regions = new ArrayList();
        Iterator iterator = this.field_2_regions.iterator();
        while (iterator.hasNext()) {
            MergedRegion oldRegion = (MergedRegion)iterator.next();
            rec.addArea(oldRegion.row_from, oldRegion.col_from, oldRegion.row_to, oldRegion.col_to);
        }
        return rec;
    }

    public class MergedRegion {
        public int row_from;
        public int row_to;
        public short col_from;
        public short col_to;

        public MergedRegion(int row_from, int row_to, short col_from, short col_to) {
            this.row_from = row_from;
            this.row_to = row_to;
            this.col_from = col_from;
            this.col_to = col_to;
        }
    }
}

