/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi1.hssf.record.AbstractEscherHolderRecord;
import org.apache.poi1.hssf.record.BOFRecord;
import org.apache.poi1.hssf.record.BackupRecord;
import org.apache.poi1.hssf.record.BlankRecord;
import org.apache.poi1.hssf.record.BookBoolRecord;
import org.apache.poi1.hssf.record.BoolErrRecord;
import org.apache.poi1.hssf.record.BottomMarginRecord;
import org.apache.poi1.hssf.record.BoundSheetRecord;
import org.apache.poi1.hssf.record.CalcCountRecord;
import org.apache.poi1.hssf.record.CalcModeRecord;
import org.apache.poi1.hssf.record.CodepageRecord;
import org.apache.poi1.hssf.record.ColumnInfoRecord;
import org.apache.poi1.hssf.record.ContinueRecord;
import org.apache.poi1.hssf.record.CountryRecord;
import org.apache.poi1.hssf.record.DBCellRecord;
import org.apache.poi1.hssf.record.DSFRecord;
import org.apache.poi1.hssf.record.DateWindow1904Record;
import org.apache.poi1.hssf.record.DefaultColWidthRecord;
import org.apache.poi1.hssf.record.DefaultRowHeightRecord;
import org.apache.poi1.hssf.record.DeltaRecord;
import org.apache.poi1.hssf.record.DimensionsRecord;
import org.apache.poi1.hssf.record.DrawingGroupRecord;
import org.apache.poi1.hssf.record.DrawingRecord;
import org.apache.poi1.hssf.record.DrawingSelectionRecord;
import org.apache.poi1.hssf.record.EOFRecord;
import org.apache.poi1.hssf.record.ExtSSTRecord;
import org.apache.poi1.hssf.record.ExtendedFormatRecord;
import org.apache.poi1.hssf.record.ExternSheetRecord;
import org.apache.poi1.hssf.record.FilePassRecord;
import org.apache.poi1.hssf.record.FnGroupCountRecord;
import org.apache.poi1.hssf.record.FontRecord;
import org.apache.poi1.hssf.record.FooterRecord;
import org.apache.poi1.hssf.record.FormatRecord;
import org.apache.poi1.hssf.record.FormulaRecord;
import org.apache.poi1.hssf.record.GridsetRecord;
import org.apache.poi1.hssf.record.GutsRecord;
import org.apache.poi1.hssf.record.HCenterRecord;
import org.apache.poi1.hssf.record.HeaderRecord;
import org.apache.poi1.hssf.record.HideObjRecord;
import org.apache.poi1.hssf.record.HorizontalPageBreakRecord;
import org.apache.poi1.hssf.record.IndexRecord;
import org.apache.poi1.hssf.record.InterfaceEndRecord;
import org.apache.poi1.hssf.record.InterfaceHdrRecord;
import org.apache.poi1.hssf.record.IterationRecord;
import org.apache.poi1.hssf.record.LabelRecord;
import org.apache.poi1.hssf.record.LabelSSTRecord;
import org.apache.poi1.hssf.record.LeftMarginRecord;
import org.apache.poi1.hssf.record.MMSRecord;
import org.apache.poi1.hssf.record.MergeCellsRecord;
import org.apache.poi1.hssf.record.MulBlankRecord;
import org.apache.poi1.hssf.record.MulRKRecord;
import org.apache.poi1.hssf.record.NameRecord;
import org.apache.poi1.hssf.record.NoteRecord;
import org.apache.poi1.hssf.record.NumberRecord;
import org.apache.poi1.hssf.record.ObjRecord;
import org.apache.poi1.hssf.record.PaletteRecord;
import org.apache.poi1.hssf.record.PaneRecord;
import org.apache.poi1.hssf.record.PasswordRecord;
import org.apache.poi1.hssf.record.PasswordRev4Record;
import org.apache.poi1.hssf.record.PrecisionRecord;
import org.apache.poi1.hssf.record.PrintGridlinesRecord;
import org.apache.poi1.hssf.record.PrintHeadersRecord;
import org.apache.poi1.hssf.record.PrintSetupRecord;
import org.apache.poi1.hssf.record.ProtectRecord;
import org.apache.poi1.hssf.record.ProtectionRev4Record;
import org.apache.poi1.hssf.record.RKRecord;
import org.apache.poi1.hssf.record.RecalcIdRecord;
import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.hssf.record.RefModeRecord;
import org.apache.poi1.hssf.record.RefreshAllRecord;
import org.apache.poi1.hssf.record.RightMarginRecord;
import org.apache.poi1.hssf.record.RowRecord;
import org.apache.poi1.hssf.record.SSTRecord;
import org.apache.poi1.hssf.record.SaveRecalcRecord;
import org.apache.poi1.hssf.record.SelectionRecord;
import org.apache.poi1.hssf.record.SharedFormulaRecord;
import org.apache.poi1.hssf.record.StringRecord;
import org.apache.poi1.hssf.record.StyleRecord;
import org.apache.poi1.hssf.record.TabIdRecord;
import org.apache.poi1.hssf.record.TextObjectRecord;
import org.apache.poi1.hssf.record.TopMarginRecord;
import org.apache.poi1.hssf.record.UnknownRecord;
import org.apache.poi1.hssf.record.UseSelFSRecord;
import org.apache.poi1.hssf.record.VCenterRecord;
import org.apache.poi1.hssf.record.VerticalPageBreakRecord;
import org.apache.poi1.hssf.record.WSBoolRecord;
import org.apache.poi1.hssf.record.WindowOneRecord;
import org.apache.poi1.hssf.record.WindowProtectRecord;
import org.apache.poi1.hssf.record.WindowTwoRecord;
import org.apache.poi1.hssf.record.WriteAccessRecord;
import org.apache.poi1.hssf.record.WriteProtectRecord;

public class RecordFactory {
    private static int NUM_RECORDS = 10000;
    private static final Class[] records = new Class[]{BOFRecord.class, InterfaceHdrRecord.class, MMSRecord.class, InterfaceEndRecord.class, WriteAccessRecord.class, CodepageRecord.class, DSFRecord.class, TabIdRecord.class, FnGroupCountRecord.class, WindowProtectRecord.class, ProtectRecord.class, PasswordRecord.class, ProtectionRev4Record.class, PasswordRev4Record.class, WindowOneRecord.class, BackupRecord.class, HideObjRecord.class, DateWindow1904Record.class, PrecisionRecord.class, RefreshAllRecord.class, BookBoolRecord.class, FontRecord.class, FormatRecord.class, ExtendedFormatRecord.class, StyleRecord.class, UseSelFSRecord.class, BoundSheetRecord.class, CountryRecord.class, SSTRecord.class, ExtSSTRecord.class, EOFRecord.class, IndexRecord.class, CalcModeRecord.class, CalcCountRecord.class, RefModeRecord.class, IterationRecord.class, DeltaRecord.class, SaveRecalcRecord.class, PrintHeadersRecord.class, PrintGridlinesRecord.class, GridsetRecord.class, GutsRecord.class, DefaultRowHeightRecord.class, WSBoolRecord.class, HeaderRecord.class, FooterRecord.class, HCenterRecord.class, VCenterRecord.class, PrintSetupRecord.class, DefaultColWidthRecord.class, DimensionsRecord.class, RowRecord.class, LabelSSTRecord.class, RKRecord.class, NumberRecord.class, DBCellRecord.class, WindowTwoRecord.class, SelectionRecord.class, ContinueRecord.class, LabelRecord.class, BlankRecord.class, ColumnInfoRecord.class, MulRKRecord.class, MulBlankRecord.class, MergeCellsRecord.class, FormulaRecord.class, BoolErrRecord.class, ExternSheetRecord.class, NameRecord.class, LeftMarginRecord.class, RightMarginRecord.class, TopMarginRecord.class, BottomMarginRecord.class, DrawingRecord.class, DrawingGroupRecord.class, DrawingSelectionRecord.class, ObjRecord.class, TextObjectRecord.class, PaletteRecord.class, StringRecord.class, RecalcIdRecord.class, SharedFormulaRecord.class, HorizontalPageBreakRecord.class, VerticalPageBreakRecord.class, WriteProtectRecord.class, FilePassRecord.class, PaneRecord.class, NoteRecord.class};
    private static Map recordsMap = RecordFactory.recordsToMap(records);
    static /* synthetic */ Class class$org$apache$poi1$hssf$record$RecordInputStream;

    public static void setCapacity(int capacity) {
        NUM_RECORDS = capacity;
    }

    public static List createRecords(InputStream in) throws RecordFormatException {
        ArrayList<Record> records = new ArrayList<Record>(NUM_RECORDS);
        RecordInputStream recStream = new RecordInputStream(in);
        DrawingRecord lastDrawingRecord = new DrawingRecord();
        Record lastRecord = null;
        while (recStream.hasNextRecord()) {
            recStream.nextRecord();
            if (recStream.getSid() == 0) continue;
            Record[] recs = RecordFactory.createRecord(recStream);
            if (recs.length > 1) {
                for (int k = 0; k < recs.length; ++k) {
                    records.add(recs[k]);
                }
                continue;
            }
            Record record = recs[0];
            if (record == null) continue;
            if (record.getSid() == 235 && lastRecord instanceof DrawingGroupRecord) {
                DrawingGroupRecord lastDGRecord = (DrawingGroupRecord)lastRecord;
                lastDGRecord.join((AbstractEscherHolderRecord)record);
                continue;
            }
            if (record.getSid() == 60 && (lastRecord instanceof ObjRecord || lastRecord instanceof TextObjectRecord)) {
                lastDrawingRecord.processContinueRecord(((ContinueRecord)record).getData());
                continue;
            }
            if (record.getSid() == 60 && lastRecord instanceof DrawingGroupRecord) {
                ((DrawingGroupRecord)lastRecord).processContinueRecord(((ContinueRecord)record).getData());
                continue;
            }
            if (record.getSid() == 60) {
                if (lastRecord instanceof UnknownRecord) {
                    records.add(record);
                    continue;
                }
                throw new RecordFormatException("Unhandled Continue Record");
            }
            lastRecord = record;
            if (record instanceof DrawingRecord) {
                lastDrawingRecord = (DrawingRecord)record;
            }
            records.add(record);
        }
        return records;
    }

    public static Record[] createRecord(RecordInputStream in) {
        Record retval;
        Record[] realretval = null;
        try {
            Constructor constructor = (Constructor)recordsMap.get(new Short(in.getSid()));
            retval = constructor != null ? (Record)constructor.newInstance(in) : new UnknownRecord(in);
        }
        catch (Exception introspectionException) {
            throw new RecordFormatException("Unable to construct record instance", introspectionException);
        }
        if (retval instanceof RKRecord) {
            RKRecord rk = (RKRecord)retval;
            NumberRecord num = new NumberRecord();
            num.setColumn(rk.getColumn());
            num.setRow(rk.getRow());
            num.setXFIndex(rk.getXFIndex());
            num.setValue(rk.getRKNumber());
            retval = num;
        } else if (retval instanceof DBCellRecord) {
            retval = null;
        } else if (retval instanceof MulRKRecord) {
            MulRKRecord mrk = (MulRKRecord)retval;
            realretval = new Record[mrk.getNumColumns()];
            for (int k = 0; k < mrk.getNumColumns(); ++k) {
                NumberRecord nr = new NumberRecord();
                nr.setColumn((short)(k + mrk.getFirstColumn()));
                nr.setRow(mrk.getRow());
                nr.setXFIndex(mrk.getXFAt(k));
                nr.setValue(mrk.getRKNumberAt(k));
                realretval[k] = nr;
            }
        } else if (retval instanceof MulBlankRecord) {
            MulBlankRecord mb = (MulBlankRecord)retval;
            realretval = new Record[mb.getNumColumns()];
            for (int k = 0; k < mb.getNumColumns(); ++k) {
                BlankRecord br = new BlankRecord();
                br.setColumn((short)(k + mb.getFirstColumn()));
                br.setRow(mb.getRow());
                br.setXFIndex(mb.getXFAt(k));
                realretval[k] = br;
            }
        }
        if (realretval == null) {
            realretval = new Record[]{retval};
        }
        return realretval;
    }

    public static short[] getAllKnownRecordSIDs() {
        short[] results = new short[recordsMap.size()];
        int i = 0;
        Iterator iterator = recordsMap.keySet().iterator();
        while (iterator.hasNext()) {
            Short sid = (Short)iterator.next();
            results[i++] = sid;
        }
        return results;
    }

    private static Map recordsToMap(Class[] records) {
        HashMap result = new HashMap();
        for (int i = 0; i < records.length; ++i) {
            Constructor constructor;
            short sid;
            Class record = records[i];
            try {
                sid = record.getField("sid").getShort(null);
                constructor = record.getConstructor(class$org$apache$poi1$hssf$record$RecordInputStream == null ? RecordFactory.class$("org.apache.poi1.hssf.record.RecordInputStream") : class$org$apache$poi1$hssf$record$RecordInputStream);
            }
            catch (Exception illegalArgumentException) {
                throw new RecordFormatException("Unable to determine record types", illegalArgumentException);
            }
            result.put(new Short(sid), constructor);
        }
        return result;
    }
}

