/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.LittleEndian;

public class UseSelFSRecord
extends Record {
    public static final short sid = 352;
    public static final short TRUE = 1;
    public static final short FALSE = 0;
    private short field_1_flag;

    public UseSelFSRecord() {
    }

    public UseSelFSRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 352) {
            throw new RecordFormatException("NOT A UseSelFS RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_flag = in.readShort();
    }

    public void setFlag(short flag) {
        this.field_1_flag = flag;
    }

    public short getFlag() {
        return this.field_1_flag;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[USESELFS]\n");
        buffer.append("    .flag            = ").append(Integer.toHexString(this.getFlag())).append("\n");
        buffer.append("[/USESELFS]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)352);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getFlag());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 352;
    }
}

