/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.LittleEndian;

public class VCenterRecord
extends Record {
    public static final short sid = 132;
    private short field_1_vcenter;

    public VCenterRecord() {
    }

    public VCenterRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 132) {
            throw new RecordFormatException("NOT A VCenter RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_vcenter = in.readShort();
    }

    public void setVCenter(boolean hc) {
        this.field_1_vcenter = hc ? (short)1 : 0;
    }

    public boolean getVCenter() {
        return this.field_1_vcenter == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[VCENTER]\n");
        buffer.append("    .vcenter        = ").append(this.getVCenter()).append("\n");
        buffer.append("[/VCENTER]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)132);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_vcenter);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 132;
    }

    public Object clone() {
        VCenterRecord rec = new VCenterRecord();
        rec.field_1_vcenter = this.field_1_vcenter;
        return rec;
    }
}

