/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.text.extraction1;

import java.util.Iterator;
import java.util.List;
import org.apache.poi1.hwpf.model.CHPX;
import org.apache.poi1.util.LittleEndian;
import org.textmining.text.extraction1.WordTextBuffer;
import org.textmining.text.extraction1.chp.Word6CHPBinTable;

class Word6Extractor {
    public String extractText(byte[] mainStream) throws Exception {
        int fcMin = LittleEndian.getInt(mainStream, 24);
        int fcMax = LittleEndian.getInt(mainStream, 28);
        int chpTableOffset = LittleEndian.getInt(mainStream, 184);
        int chpTableSize = LittleEndian.getInt(mainStream, 188);
        Word6CHPBinTable chpTable = new Word6CHPBinTable(mainStream, chpTableOffset, chpTableSize, fcMin);
        List textRuns = chpTable.getTextRuns();
        WordTextBuffer finalTextBuf = new WordTextBuffer();
        Iterator runsIt = textRuns.iterator();
        while (runsIt.hasNext()) {
            CHPX chpx = (CHPX)runsIt.next();
            int runStart = chpx.getStart() + fcMin;
            int runEnd = chpx.getEnd() + fcMin;
            if (this.isDeleted(chpx.getGrpprl())) continue;
            String s = new String(mainStream, runStart, Math.min(runEnd, fcMax) - runStart, "Cp1252");
            finalTextBuf.append(s);
            if (runEnd < fcMax) continue;
            break;
        }
        return finalTextBuf.toString();
    }

    private boolean isDeleted(byte[] grpprl) {
        int offset = 0;
        boolean deleted = false;
        while (offset < grpprl.length) {
            switch (LittleEndian.getUnsignedByte(grpprl, offset++)) {
                case 65: {
                    deleted = grpprl[offset++] != 0;
                    break;
                }
                case 66: {
                    ++offset;
                    break;
                }
                case 67: {
                    ++offset;
                    break;
                }
                case 68: {
                    offset += grpprl[offset];
                    break;
                }
                case 69: {
                    offset += 2;
                    break;
                }
                case 70: {
                    offset += 4;
                    break;
                }
                case 71: {
                    ++offset;
                    break;
                }
                case 72: {
                    offset += 2;
                    break;
                }
                case 73: {
                    offset += 3;
                    break;
                }
                case 74: {
                    offset += grpprl[offset];
                    break;
                }
                case 75: {
                    ++offset;
                    break;
                }
                case 80: {
                    offset += 2;
                    break;
                }
                case 81: {
                    offset += grpprl[offset];
                    break;
                }
                case 82: {
                    offset += grpprl[offset];
                    break;
                }
                case 83: {
                    break;
                }
                case 85: {
                    ++offset;
                    break;
                }
                case 86: {
                    ++offset;
                    break;
                }
                case 87: {
                    ++offset;
                    break;
                }
                case 88: {
                    ++offset;
                    break;
                }
                case 89: {
                    ++offset;
                    break;
                }
                case 90: {
                    ++offset;
                    break;
                }
                case 91: {
                    ++offset;
                    break;
                }
                case 92: {
                    ++offset;
                    break;
                }
                case 93: {
                    offset += 2;
                    break;
                }
                case 94: {
                    ++offset;
                    break;
                }
                case 95: {
                    offset += 3;
                    break;
                }
                case 96: {
                    offset += 2;
                    break;
                }
                case 97: {
                    offset += 2;
                    break;
                }
                case 98: {
                    ++offset;
                    break;
                }
                case 99: {
                    ++offset;
                    break;
                }
                case 100: {
                    ++offset;
                    break;
                }
                case 101: {
                    ++offset;
                    break;
                }
                case 102: {
                    ++offset;
                    break;
                }
                case 103: {
                    offset += grpprl[offset];
                    break;
                }
                case 104: {
                    ++offset;
                    break;
                }
                case 105: {
                    offset += grpprl[offset];
                    break;
                }
                case 106: {
                    offset += grpprl[offset];
                    break;
                }
                case 107: {
                    offset += 2;
                    break;
                }
                case 108: {
                    offset += grpprl[offset];
                    break;
                }
                case 109: {
                    offset += 2;
                    break;
                }
                case 110: {
                    offset += 2;
                    break;
                }
                case 117: {
                    ++offset;
                    break;
                }
                case 118: {
                    ++offset;
                }
            }
        }
        return deleted;
    }
}

