/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.text.extraction1.chp;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi1.hwpf.model.CHPFormattedDiskPage;
import org.apache.poi1.hwpf.model.GenericPropertyNode;
import org.apache.poi1.hwpf.model.PlexOfCps;
import org.apache.poi1.util.LittleEndian;

public class Word6CHPBinTable {
    ArrayList _textRuns = new ArrayList();

    public Word6CHPBinTable(byte[] documentStream, int offset, int size, int fcMin) {
        PlexOfCps binTable = new PlexOfCps(documentStream, offset, size, 2);
        int length = binTable.length();
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = binTable.getProperty(x);
            short pageNum = LittleEndian.getShort(node.getBytes());
            int pageOffset = 512 * pageNum;
            CHPFormattedDiskPage cfkp = new CHPFormattedDiskPage(documentStream, pageOffset, fcMin);
            int fkpSize = cfkp.size();
            for (int y = 0; y < fkpSize; ++y) {
                this._textRuns.add(cfkp.getCHPX(y));
            }
        }
    }

    public List getTextRuns() {
        return this._textRuns;
    }
}

