/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.text.extraction1.sprm;

import org.apache.poi1.util.BitField;
import org.apache.poi1.util.LittleEndian;

public class SprmOperation {
    private static final BitField OP_BITFIELD = new BitField(511);
    private static final BitField SPECIAL_BITFIELD = new BitField(512);
    private static final BitField TYPE_BITFIELD = new BitField(7168);
    private static final BitField SIZECODE_BITFIELD = new BitField(57344);
    private int _type;
    private int _operation;
    private int _operand;
    private byte[] _varOperand;
    private int _sizeNeeded;

    public SprmOperation(byte[] grpprl, int offset) {
        short sprmStart = LittleEndian.getShort(grpprl, offset);
        offset += 2;
        this._operation = OP_BITFIELD.getValue(sprmStart);
        this._type = TYPE_BITFIELD.getValue(sprmStart);
        int sizeCode = SIZECODE_BITFIELD.getValue(sprmStart);
        switch (sizeCode) {
            case 0: 
            case 1: {
                this._operand = LittleEndian.getUnsignedByte(grpprl, offset);
                this._sizeNeeded = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                this._operand = LittleEndian.getShort(grpprl, offset);
                this._sizeNeeded = 4;
                break;
            }
            case 3: {
                this._operand = LittleEndian.getInt(grpprl, offset);
                this._sizeNeeded = 6;
                break;
            }
            case 6: {
                this._varOperand = new byte[grpprl[offset++]];
                System.arraycopy(grpprl, offset, this._varOperand, 0, this._varOperand.length);
                this._sizeNeeded = this._varOperand.length + 3;
                break;
            }
            case 7: {
                byte[] threeByteInt = new byte[]{grpprl[offset], grpprl[offset + 1], grpprl[offset + 2], 0};
                this._operand = LittleEndian.getInt(threeByteInt, 0);
                this._sizeNeeded = 5;
            }
        }
    }

    public int getType() {
        return this._type;
    }

    public int getOperation() {
        return this._operation;
    }

    public int getOperand() {
        return this._operand;
    }

    public int size() {
        return this._sizeNeeded;
    }
}

