/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.WorkflowLogUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.mc.AgentType;
import com.kingdee.eas.cp.eip.mc.IJobDelegate;
import com.kingdee.eas.cp.eip.mc.IJobDelegateManagerFacade;
import com.kingdee.eas.cp.eip.mc.IMcBillCondition;
import com.kingdee.eas.cp.eip.mc.IOrgRangeEntry;
import com.kingdee.eas.cp.eip.mc.IProcRangeEntry;
import com.kingdee.eas.cp.eip.mc.IUserRangeCondition;
import com.kingdee.eas.cp.eip.mc.IUserRangeEntry;
import com.kingdee.eas.cp.eip.mc.IotherUserRangeEntry;
import com.kingdee.eas.cp.eip.mc.JobDelegateAllInfo;
import com.kingdee.eas.cp.eip.mc.JobDelegateCollection;
import com.kingdee.eas.cp.eip.mc.JobDelegateException;
import com.kingdee.eas.cp.eip.mc.JobDelegateFactory;
import com.kingdee.eas.cp.eip.mc.JobDelegateInfo;
import com.kingdee.eas.cp.eip.mc.JobDelegateManagerFacadeFactory;
import com.kingdee.eas.cp.eip.mc.JobDelegateTansInfo;
import com.kingdee.eas.cp.eip.mc.LoopException;
import com.kingdee.eas.cp.eip.mc.McBillConditionFactory;
import com.kingdee.eas.cp.eip.mc.McBillConditionInfo;
import com.kingdee.eas.cp.eip.mc.OrgRangeEntryCollection;
import com.kingdee.eas.cp.eip.mc.OrgRangeEntryFactory;
import com.kingdee.eas.cp.eip.mc.OrgRangeEntryInfo;
import com.kingdee.eas.cp.eip.mc.ProcRangeEntryCollection;
import com.kingdee.eas.cp.eip.mc.ProcRangeEntryFactory;
import com.kingdee.eas.cp.eip.mc.ProcRangeEntryInfo;
import com.kingdee.eas.cp.eip.mc.ProcSelectedInfo;
import com.kingdee.eas.cp.eip.mc.UserRangeConditionCollection;
import com.kingdee.eas.cp.eip.mc.UserRangeConditionFactory;
import com.kingdee.eas.cp.eip.mc.UserRangeConditionInfo;
import com.kingdee.eas.cp.eip.mc.UserRangeEntryCollection;
import com.kingdee.eas.cp.eip.mc.UserRangeEntryFactory;
import com.kingdee.eas.cp.eip.mc.UserRangeEntryInfo;
import com.kingdee.eas.cp.eip.mc.app.AbstractJobDelegateControllerBean;
import com.kingdee.eas.cp.eip.mc.app.JobDelegateAppUtil;
import com.kingdee.eas.cp.eip.mc.otherUserRangeEntryCollection;
import com.kingdee.eas.cp.eip.mc.otherUserRangeEntryFactory;
import com.kingdee.eas.cp.eip.mc.otherUserRangeEntryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class JobDelegateControllerBean
extends AbstractJobDelegateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eip.mc.app.JobDelegateControllerBean");

    private boolean hasDelegate(Context ctx, String userID, String orgID) throws BOSException {
        Object info = null;
        JobDelegateCollection infoColl = null;
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        cuttentDate = Timestamp.valueOf(cuttentDate.toString().substring(0, 19));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("consignor", (Object)userID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("effectDate", (Object)cuttentDate, CompareType.LESS_EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("invalidDate", (Object)cuttentDate, CompareType.GREATER);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("orgID", (Object)orgID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        infoColl = this.getJobDelegateCollection(ctx, viewInfo);
        return infoColl.size() > 0;
    }

    private JobDelegateCollection getDelegate(Context ctx, String userID) throws BOSException {
        Object info = null;
        JobDelegateCollection infoColl = null;
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        cuttentDate = Timestamp.valueOf(cuttentDate.toString().substring(0, 19));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("consignor", (Object)userID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("effectDate", (Object)cuttentDate, CompareType.LESS_EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("invalidDate", (Object)cuttentDate, CompareType.GREATER);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SorterItemInfo sorterItemInfo = null;
        sorterItemInfo = new SorterItemInfo("agentType");
        sorterItemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        infoColl = this.getJobDelegateCollection(ctx, viewInfo);
        return infoColl;
    }

    private IObjectValue getAllDelegate(Context ctx, String userID, String orgID) throws BOSException {
        JobDelegateInfo info = null;
        JobDelegateCollection infoColl = null;
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        cuttentDate = Timestamp.valueOf(cuttentDate.toString().substring(0, 19));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("consignor", (Object)userID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("delegateByProc", (Object)new Integer(0), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("agentType", (Object)new Integer(1), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("effectDate", (Object)cuttentDate, CompareType.LESS_EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("invalidDate", (Object)cuttentDate, CompareType.GREATER);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("orgID", (Object)orgID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        infoColl = this.getJobDelegateCollection(ctx, viewInfo);
        if (infoColl.size() > 0) {
            info = infoColl.get(0);
        }
        return info;
    }

    @Override
    protected IObjectValue _getAllDelegateInfo(Context ctx, String orgID) throws BOSException {
        JobDelegateInfo info = null;
        JobDelegateCollection infoColl = null;
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        cuttentDate = Timestamp.valueOf(cuttentDate.toString().substring(0, 19));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("consignor", (Object)ctx.getCaller().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("delegateByProc", (Object)new Integer(0), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("agentType", (Object)new Integer(1), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("invalidDate", (Object)cuttentDate, CompareType.GREATER);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("orgID", (Object)orgID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        infoColl = this.getJobDelegateCollection(ctx, viewInfo);
        if (infoColl.size() > 0) {
            info = infoColl.get(0);
        }
        return info;
    }

    protected IObjectValue getOtherDelegate(Context ctx, String userID, String orgID) throws BOSException {
        JobDelegateInfo info = null;
        JobDelegateCollection infoColl = null;
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        cuttentDate = Timestamp.valueOf(cuttentDate.toString().substring(0, 19));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("consignor", (Object)userID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("delegateByProc", (Object)new Integer(1), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("agentType", (Object)new Integer(3), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("effectDate", (Object)cuttentDate, CompareType.LESS_EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("invalidDate", (Object)cuttentDate, CompareType.GREATER);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("orgID", (Object)orgID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        infoColl = this.getJobDelegateCollection(ctx, viewInfo);
        if (infoColl.size() > 0) {
            info = infoColl.get(0);
        }
        return info;
    }

    @Override
    protected IObjectValue _getOtherDelegateInfo(Context ctx, String orgID) throws BOSException {
        JobDelegateInfo info = null;
        JobDelegateCollection infoColl = null;
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        cuttentDate = Timestamp.valueOf(cuttentDate.toString().substring(0, 19));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("consignor", (Object)ctx.getCaller().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("delegateByProc", (Object)new Integer(1), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("agentType", (Object)new Integer(3), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("invalidDate", (Object)cuttentDate, CompareType.GREATER);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("orgID", (Object)orgID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        infoColl = this.getJobDelegateCollection(ctx, viewInfo);
        if (infoColl.size() > 0) {
            info = infoColl.get(0);
        }
        return info;
    }

    @Override
    protected void _noDelegateSave(Context ctx, String orgID) throws BOSException {
        Timestamp timestamp = new Timestamp(new Date().getTime());
        timestamp = Timestamp.valueOf(timestamp.toString().substring(0, 19));
        Object[] params = null;
        String ksql = null;
        if (StringUtils.isEmpty((String)orgID)) {
            params = new Object[]{timestamp, timestamp, ctx.getCaller().toString()};
            ksql = " update T_MC_JobDelegate set  FInvalidDate = ? where FInvalidDate >=? and FConsignor = ? ";
        } else {
            params = new Object[]{timestamp, timestamp, ctx.getCaller().toString(), orgID};
            ksql = " update T_MC_JobDelegate set  FInvalidDate = ? where FInvalidDate >=? and FConsignor = ? and FOrgID=?";
        }
        DbUtil.execute((Context)ctx, (String)ksql, (Object[])params);
    }

    private Timestamp addDate(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Calendar cd = Calendar.getInstance();
        cd.setTime(new Date(timestamp.getTime()));
        cd.add(5, 1);
        Timestamp timestamp_new = new Timestamp(cd.getTime().getTime());
        timestamp_new = Timestamp.valueOf(timestamp_new.toString().substring(0, 19));
        return timestamp_new;
    }

    @Override
    protected void _batchDelegateSave(Context ctx, Timestamp beginDate, Timestamp endDate, IObjectValue userInfo, String[] proIdArray, String orgID) throws BOSException {
        try {
            if (StringUtils.isEmpty((String)orgID)) {
                this._noOrgDelegateDel(ctx);
            } else {
                this._hasOrgDelegateDel(ctx);
            }
            Timestamp invalidDate = this.addDate(endDate);
            UserInfo user = (UserInfo)userInfo;
            if (proIdArray != null && proIdArray.length > 0) {
                JobDelegateInfo info = null;
                for (int i = 0; i < proIdArray.length; ++i) {
                    info = new JobDelegateInfo();
                    BOSUuid id = BOSUuid.create((BOSObjectType)info.getBOSType());
                    info.setId(id);
                    info.setConsignor(user);
                    info.setEffectDate(beginDate);
                    info.setPlanInvalidDate(endDate);
                    info.setInvalidDate(invalidDate);
                    info.setDelegateByProc(true);
                    info.setProcDefID(proIdArray[i]);
                    info.setAgentType(AgentType.BYPROC);
                    if (!StringUtils.isEmpty((String)orgID)) {
                        info.setOrgID(BOSUuid.read((String)orgID));
                    }
                    this.addnew(ctx, (CoreBaseInfo)info);
                }
                JobDelegateInfo allInfo = this.getAllDelegateInfo(ctx, orgID);
                if (allInfo != null) {
                    ObjectUuidPK pk = new ObjectUuidPK(allInfo.getId());
                    Timestamp timestamp = new Timestamp(new Date().getTime());
                    timestamp = Timestamp.valueOf(timestamp.toString().substring(0, 19));
                    allInfo.setInvalidDate(timestamp);
                    this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)allInfo);
                }
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _proDelegateSave(Context ctx, Timestamp beginDate, Timestamp endDate, IObjectValue userInfo, IObjectValue delegateInfo, String orgID) throws BOSException {
        UserInfo user = (UserInfo)userInfo;
        JobDelegateInfo info = (JobDelegateInfo)delegateInfo;
        try {
            ObjectUuidPK pk;
            if (StringUtils.isEmpty((String)orgID)) {
                this._noOrgDelegateDel(ctx);
            } else {
                this._hasOrgDelegateDel(ctx);
            }
            Timestamp invalidDate = this.addDate(endDate);
            if (user != null) {
                if (info != null) {
                    pk = new ObjectUuidPK(info.getId());
                    info.setConsignor(user);
                    info.setEffectDate(beginDate);
                    info.setPlanInvalidDate(endDate);
                    info.setInvalidDate(invalidDate);
                    info.setDelegateByProc(true);
                    info.setAgentType(AgentType.OTHERPROC);
                    this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
                } else {
                    info = new JobDelegateInfo();
                    BOSUuid id = BOSUuid.create((BOSObjectType)info.getBOSType());
                    info.setId(id);
                    info.setConsignor(user);
                    info.setEffectDate(beginDate);
                    info.setPlanInvalidDate(endDate);
                    info.setInvalidDate(invalidDate);
                    info.setDelegateByProc(true);
                    info.setAgentType(AgentType.OTHERPROC);
                    if (!StringUtils.isEmpty((String)orgID)) {
                        info.setOrgID(BOSUuid.read((String)orgID));
                    }
                    this.addnew(ctx, (CoreBaseInfo)info);
                }
            } else if (info != null) {
                pk = new ObjectUuidPK(info.getId());
                Timestamp timestamp = new Timestamp(new Date().getTime());
                timestamp = Timestamp.valueOf(timestamp.toString().substring(0, 19));
                info.setInvalidDate(timestamp);
                this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
            }
            JobDelegateInfo allInfo = this.getAllDelegateInfo(ctx, orgID);
            if (allInfo != null) {
                ObjectUuidPK pk2 = new ObjectUuidPK(allInfo.getId());
                Timestamp timestamp = new Timestamp(new Date().getTime());
                timestamp = Timestamp.valueOf(timestamp.toString().substring(0, 19));
                allInfo.setInvalidDate(timestamp);
                this.update(ctx, (IObjectPK)pk2, (CoreBaseInfo)allInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _allDelegateSave(Context ctx, Timestamp beginDate, Timestamp endDate, IObjectValue userInfo, IObjectValue delegateInfo, String orgID) throws BOSException {
        UserInfo user = (UserInfo)userInfo;
        JobDelegateInfo info = (JobDelegateInfo)delegateInfo;
        try {
            if (StringUtils.isEmpty((String)orgID)) {
                this.noDelegateSave(ctx, orgID);
            } else {
                this._hasOrgDelegateDel(ctx);
            }
            Timestamp invalidDate = this.addDate(endDate);
            if (info != null) {
                ObjectUuidPK pk = new ObjectUuidPK(info.getId());
                info.setConsignor(user);
                info.setEffectDate(beginDate);
                info.setPlanInvalidDate(endDate);
                info.setInvalidDate(invalidDate);
                info.setDelegateByProc(false);
                info.setAgentType(AgentType.ALLPROC);
                this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
            } else {
                info = new JobDelegateInfo();
                BOSUuid id = BOSUuid.create((BOSObjectType)info.getBOSType());
                info.setId(id);
                info.setConsignor(user);
                info.setEffectDate(beginDate);
                info.setPlanInvalidDate(endDate);
                info.setInvalidDate(invalidDate);
                info.setDelegateByProc(false);
                info.setAgentType(AgentType.ALLPROC);
                if (!StringUtils.isEmpty((String)orgID)) {
                    info.setOrgID(BOSUuid.read((String)orgID));
                }
                this.addnew(ctx, (CoreBaseInfo)info);
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IRowSet _getDelegates(Context ctx, String orgID) throws BOSException {
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        cuttentDate = Timestamp.valueOf(cuttentDate.toString().substring(0, 19));
        Object[] params = null;
        params = !StringUtils.isEmpty((String)orgID) ? new Object[]{cuttentDate, ctx.getCaller().toString(), orgID} : new Object[]{cuttentDate, ctx.getCaller().toString()};
        String strName = "FNAME_" + ctx.getLocale().toString();
        StringBuffer ksqlBf = new StringBuffer();
        ksqlBf.append("select a.FID,b." + strName + ",a.FEffectDate,a.FInvalidDate,c." + strName + ",c.FID, a.FProcDefID");
        ksqlBf.append(" from T_MC_JobDelegate a, T_WFR_PROCDEF b, T_PM_User c");
        ksqlBf.append(" where  FInvalidDate > ?");
        if (!StringUtils.isEmpty((String)orgID)) {
            ksqlBf.append(" and a.FConsignor= ?  and FOrgID = ?");
        } else {
            ksqlBf.append(" and a.FConsignor= ? and FOrgID is null ");
        }
        ksqlBf.append(" and FDelegateByProc=1 and FAgentType = 2 ");
        ksqlBf.append(" and a.FProcDefID = b.FPROCDEFID and a.FConsignor = c.FID");
        ksqlBf.append(" and b.FINNERVERSION = ( select max(d.FINNERVERSION) from T_WFR_PROCDEF d where d.FPROCDEFID = b.FPROCDEFID)");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)ksqlBf.toString(), (Object[])params);
        return rowSet;
    }

    @Override
    protected HashMap _getProcess(Context ctx, String[] orgType) throws BOSException {
        IRowSet rowSet = null;
        HashMap<String, String> map = new HashMap<String, String>();
        String strName = "FNAME_" + ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select a.FPROCDEFID,a.").append(strName);
        sql.append(" from T_WFR_PROCDEF a ");
        sql.append(" where  a.FENABLE = 1 ");
        sql.append(" and  a.FINNERVERSION =(select max(c.FINNERVERSION)");
        sql.append(" from T_WFR_PROCDEF c  where c.FPROCDEFID = a.FPROCDEFID) ");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        BOSObjectType[] billType = null;
        EntityObjectInfo entity = null;
        String orgTypeAlias = null;
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        try {
            if (orgType != null && orgType.length > 0) {
                IRowSet copyRowSet = null;
                copyRowSet = rowSet.createCopy();
                ArrayList<String> procList = new ArrayList<String>();
                while (copyRowSet.next()) {
                    procList.add(copyRowSet.getString("FPROCDEFID"));
                }
                int size = procList.size();
                String[] proc = new String[size];
                for (int i = 0; i < size; ++i) {
                    proc[i] = (String)procList.get(i);
                }
                List list = service.getRelatedEntityTypes(proc);
                HashMap hash = new HashMap();
                if (list != null && list.size() > 0) {
                    int k = list.size();
                    for (int i = 0; i < k; ++i) {
                        hash.put(procList.get(i), (BOSObjectType[])list.get(i));
                    }
                }
                for (int i = 0; i <= orgType.length - 1; ++i) {
                    String[] org = null;
                    if (orgType[i] == null) {
                        return map;
                    }
                    org = orgType[i].split("\\.");
                    copyRowSet = rowSet.createCopy();
                    while (copyRowSet.next()) {
                        String procId = copyRowSet.getString("FPROCDEFID");
                        billType = (BOSObjectType[])hash.get(procId);
                        if (billType != null && billType.length > 0) {
                            entity = metaDataLoader.getEntity(billType[0]);
                            orgTypeAlias = entity.getExtendedProperty("OrgType");
                        }
                        if (StringUtils.isEmpty(orgTypeAlias) || !this.stringInArray(orgTypeAlias, org) || map.get(copyRowSet.getString("FPROCDEFID")) != null) continue;
                        map.put(copyRowSet.getString("FPROCDEFID"), copyRowSet.getString(strName));
                    }
                }
            } else if (orgType != null && orgType.length == 0) {
                while (rowSet.next()) {
                    map.put(rowSet.getString("FPROCDEFID"), rowSet.getString(strName));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_getProcess failed", (Throwable)e);
        }
        return map;
    }

    @Override
    protected IRowSet _getProcess(Context ctx) throws BOSException {
        String procCatalogId = "";
        String strCUID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        cuttentDate = Timestamp.valueOf(cuttentDate.toString().substring(0, 19));
        Object[] params = null;
        StringBuffer strBf = new StringBuffer();
        strBf.append("select a.FNumber from T_PC_PROCCATALOG a ,T_PC_ProcCatalogSolution b");
        strBf.append(" where (a.FControlUnitID= ? ");
        strBf.append(" or b.FIsDefault=1) and a.FParentID is null and a.FSolutionID=b.FID");
        strBf.append(" order by b.FIsDefault");
        params = new Object[]{strCUID};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strBf.toString(), (Object[])params);
        try {
            if (rowSet != null && rowSet.next()) {
                procCatalogId = rowSet.getString("FNumber");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String strName = "FNAME_" + ctx.getLocale().toString();
        StringBuffer strSql = new StringBuffer();
        strSql.append("select a.FPROCDEFID,a.").append(strName);
        strSql.append(" from T_WFR_PROCDEF a ,T_PC_PROCCATALOG e,T_PC_CONFIGURATIONITEM b ");
        strSql.append(" where b.FCATALOGID = e.FID and e.FLONGNUMBER like ? and a.FENABLE = 1 ");
        strSql.append(" and a.FPROCDEFID not in(");
        strSql.append("select f.FProcDefID");
        strSql.append(" from T_MC_JobDelegate f, T_WFR_PROCDEF g, T_PM_User h");
        strSql.append(" where  FInvalidDate > ?");
        strSql.append(" and f.FConsignor= ?");
        strSql.append(" and f.FDelegateByProc=1 and f.FAgentType = 2");
        strSql.append(" and f.FProcDefID = g.FPROCDEFID and f.FConsignor= h.FID");
        strSql.append(" and g.FINNERVERSION = ( select max(k.FINNERVERSION) from T_WFR_PROCDEF k where k.FPROCDEFID = g.FPROCDEFID)");
        strSql.append(")");
        strSql.append(" and b.FPROCDEFID = a.FPROCDEFID and  a.FINNERVERSION =(select max(c.FINNERVERSION) ");
        strSql.append(" from T_WFR_PROCDEF c where c.FPROCDEFID = a.FPROCDEFID) ");
        params = procCatalogId != null && procCatalogId.length() > 0 ? new Object[]{procCatalogId + "%", cuttentDate, ctx.getCaller().toString()} : new Object[]{"%", cuttentDate, ctx.getCaller().toString()};
        rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])params);
        return rowSet;
    }

    @Override
    protected void _delProcess(Context ctx, String[] proIdArray) throws BOSException {
        Timestamp timestamp = new Timestamp(new Date().getTime());
        timestamp = Timestamp.valueOf(timestamp.toString().substring(0, 19));
        Object[] params = new Object[]{timestamp, timestamp, ctx.getCaller().toString(), "0"};
        String ksql = " update T_MC_JobDelegate set  FInvalidDate = ? where FInvalidDate >= ? and FConsignor = ? and FID= ?";
        String id2 = null;
        for (String id2 : proIdArray) {
            params[3] = id2;
            DbUtil.execute((Context)ctx, (String)ksql, (Object[])params);
        }
    }

    protected String _getConsignorId_bak(Context ctx, String proId, String userID, String initiatorId) throws BOSException {
        if (StringUtils.isEmpty((String)initiatorId)) {
            return null;
        }
        JobDelegateInfo dInfo = null;
        JobDelegateCollection delegates = this.getDelegate(ctx, userID);
        if (delegates.size() > 0) {
            JobDelegateInfo delegateInfo;
            FullOrgUnitCollection orgs = null;
            FullOrgUnitInfo oInfo = null;
            try {
                orgs = PermissionRangeHelper.getUserOrgCol((Context)ctx, (IObjectPK)new ObjectUuidPK(initiatorId), (OrgRangeType)OrgRangeType.ADMIN_ORG_TYPE);
            }
            catch (Exception e) {
                logger.error((Object)"\u83b7\u5f97\u7ec4\u7ec7\u62a5\u9519", (Throwable)e);
            }
            if (orgs == null || orgs.size() == 0) {
                return null;
            }
            String orgID = null;
            block2: for (int i = 0; i < delegates.size() && StringUtils.isEmpty(orgID); ++i) {
                dInfo = delegates.get(i);
                if (dInfo.getOrgID() == null) continue;
                for (int j = 0; j < orgs.size(); ++j) {
                    oInfo = orgs.get(j);
                    if (!dInfo.getOrgID().equals((Object)oInfo.getId()) && !this.checkParentID(ctx, dInfo.getOrgID(), oInfo.getId())) continue;
                    orgID = dInfo.getOrgID().toString();
                    continue block2;
                }
            }
            if (StringUtils.isEmpty(orgID)) {
                boolean isEmptyOrgDelegate = false;
                for (int i = 0; i < delegates.size(); ++i) {
                    dInfo = delegates.get(i);
                    if (dInfo.getOrgID() != null) continue;
                    isEmptyOrgDelegate = true;
                    break;
                }
                if (!isEmptyOrgDelegate) {
                    return null;
                }
            }
            if ((delegateInfo = (JobDelegateInfo)this.getAllDelegate(ctx, userID, orgID)) != null) {
                return delegateInfo.getConsignor().getId().toString();
            }
            String delegateUserId = this.getUserIdIfBatchDelegate(ctx, proId, userID, orgID);
            if (delegateUserId != null) {
                return delegateUserId;
            }
            delegateInfo = (JobDelegateInfo)this.getOtherDelegate(ctx, userID, orgID);
            if (delegateInfo != null) {
                return delegateInfo.getConsignor().getId().toString();
            }
        }
        return null;
    }

    @Override
    protected String _getConsignorId(Context ctx, String proId, String userID, String initiatorId) throws BOSException {
        if (StringUtils.isEmpty((String)initiatorId)) {
            logger.debug((Object)"\u6d41\u7a0b\u53d1\u8d77\u4ebaID\u4e3a\u7a7a\uff0c\u59d4\u6258\u4e0d\u6210\u529f");
            return null;
        }
        JobDelegateInfo dInfo = null;
        JobDelegateCollection delegates = this.getDelegate(ctx, userID);
        if (delegates.size() > 0) {
            FullOrgUnitCollection orgs = null;
            FullOrgUnitInfo oInfo = null;
            try {
                orgs = PermissionRangeHelper.getUserOrgCol((Context)ctx, (IObjectPK)new ObjectUuidPK(initiatorId), (OrgRangeType)OrgRangeType.ADMIN_ORG_TYPE);
            }
            catch (Exception e) {
                logger.error((Object)"\u83b7\u5f97\u7ec4\u7ec7\u62a5\u9519", (Throwable)e);
            }
            if (orgs == null || orgs.size() == 0) {
                logger.debug((Object)"\u53d1\u8d77\u4eba\u6ca1\u6709\u884c\u653f\u7ec4\u7ec7\uff0c\u59d4\u6258\u4e0d\u6210\u529f");
                return null;
            }
            String orgID = null;
            for (int i = 0; i < delegates.size(); ++i) {
                dInfo = delegates.get(i);
                if (dInfo.getOrgID() == null) {
                    logger.debug((Object)"\u7ec4\u7ec7ID\u4e3a\u7a7a\u5219,\u8bf4\u660e\u662f\u4e0d\u6309\u7ec4\u7ec7\u59d4\u6258\u7684");
                    if (dInfo.getAgentType().getValue() == 1) {
                        logger.debug((Object)"\u5168\u90e8\u59d4\u6258,\u76f4\u63a5\u8fd4\u56de\u5168\u90e8\u59d4\u6258\u7684\u4ee3\u7406\u4eba");
                        return dInfo.getConsignor().getId().toString();
                    }
                    JobDelegateInfo tempInfo = null;
                    for (int j = 0; j < delegates.size(); ++j) {
                        tempInfo = delegates.get(j);
                        if (StringUtils.isEmpty((String)tempInfo.getProcDefID()) || !tempInfo.getProcDefID().equals(proId)) continue;
                        logger.debug((Object)"\u627e\u5230\u4e86\u4e0e\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u76f8\u5339\u914d\u7684\u59d4\u6258,\u76f4\u63a5\u8fd4\u56de\u59d4\u6258\u4eba");
                        return tempInfo.getConsignor().getId().toString();
                    }
                    if (orgID != null) continue;
                    logger.debug((Object)"\u6309\u6d41\u7a0b\u5b9a\u4e49\u627e\u4e0d\u5230\u59d4\u6258\u5173\u7cfb\u5219\u8bd5\u56fe\u627e\u5176\u4ed6\u6d41\u7a0b\u59d4\u6258");
                    for (int k = 0; k < delegates.size(); ++k) {
                        tempInfo = delegates.get(k);
                        if (dInfo.getAgentType().getValue() != 3) continue;
                        logger.debug((Object)"\u6309\u5176\u4ed6\u59d4\u6258\u627e\u59d4\u6258\u4eba");
                        return tempInfo.getConsignor().getId().toString();
                    }
                    continue;
                }
                logger.debug((Object)"\u7ec4\u7ec7ID\u4e0d\u4e3a\u7a7a,\u6309\u7ec4\u7ec7\u59d4\u6258\u627e\u59d4\u6258\u4eba");
                for (int j = 0; j < orgs.size(); ++j) {
                    oInfo = orgs.get(j);
                    if (!dInfo.getOrgID().equals((Object)oInfo.getId()) && !this.checkParentID(ctx, dInfo.getOrgID(), oInfo.getId())) continue;
                    orgID = dInfo.getOrgID().toString();
                    logger.debug((Object)("\u6309\u7ec4\u7ec7\u59d4\u6258,\u627e\u5230\u4e86\u5339\u914d\u7684\u7ec4\u7ec7ID" + orgID));
                    break;
                }
                if (StringUtils.isEmpty(orgID)) continue;
                if (dInfo.getAgentType().getValue() == 1) {
                    logger.debug((Object)("\u8fd4\u56de\u5168\u90e8\u7684\u59d4\u6258\u7684\u59d4\u6258\u4eba" + dInfo.getConsignor().getId().toString()));
                    return dInfo.getConsignor().getId().toString();
                }
                if (dInfo.getAgentType().getValue() == 2) {
                    if (StringUtils.isEmpty((String)dInfo.getProcDefID()) || !dInfo.getProcDefID().equals(proId)) continue;
                    logger.debug((Object)("\u8fd4\u56de\u6309\u6d41\u7a0b'" + proId + "'\u59d4\u6258\u7684\u59d4\u6258\u4eba" + dInfo.getConsignor().getId().toString()));
                    return dInfo.getConsignor().getId().toString();
                }
                if (dInfo.getAgentType().getValue() != 3) continue;
                logger.debug((Object)("\u8fd4\u56de\u6309\u5176\u4ed6\u59d4\u6258\u7684\u59d4\u6258\u4eba" + dInfo.getConsignor().getId().toString()));
                return dInfo.getConsignor().getId().toString();
            }
        }
        return null;
    }

    private String getUserIdIfBatchDelegate(Context ctx, String proId, String userID, String orgID) throws BOSException {
        JobDelegateCollection infoColl = null;
        Object info = null;
        Timestamp currentDate = new Timestamp(new Date().getTime());
        currentDate = Timestamp.valueOf(currentDate.toString().substring(0, 19));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = new FilterItemInfo("consignor", (Object)userID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("invalidDate", (Object)currentDate, CompareType.GREATER);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("effectDate", (Object)currentDate, CompareType.LESS_EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("procDefID", (Object)proId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (!StringUtils.isEmpty((String)orgID)) {
            filterItem = new FilterItemInfo("orgID", (Object)orgID, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        infoColl = this.getJobDelegateCollection(ctx, viewInfo);
        if (infoColl.size() <= 0) {
            return null;
        }
        return infoColl.get(0).getConsignor().getId().toString();
    }

    @Override
    protected IRowSet _getProcess(Context ctx, String orgID, String proName) throws BOSException {
        String procCatalogId = "";
        String strCUID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        cuttentDate = Timestamp.valueOf(cuttentDate.toString().substring(0, 19));
        Object[] params = null;
        params = !StringUtils.isEmpty((String)orgID) ? new Object[]{orgID, cuttentDate, ctx.getCaller().toString()} : new Object[]{cuttentDate, ctx.getCaller().toString()};
        String strName = "a.FNAME_" + ctx.getLocale().toString();
        StringBuffer strBf = new StringBuffer();
        strBf.append(" select a.FPROCDEFID ,");
        strBf.append(strName);
        strBf.append(" from T_WFR_PROCDEF a inner join(");
        strBf.append(" select FPROCDEFID ,max(FINNERVERSION) as t1 from T_WFR_PROCDEF ");
        strBf.append(" where FPROCDEFTYPE='NORMAL' and FEnable=1  group by FPROCDEFID)");
        strBf.append(" b on a.FPROCDEFID=b.FPROCDEFID and a.FINNERVERSION=b.t1 ");
        if (!StringUtils.isEmpty((String)orgID)) {
            strBf.append(" where a.FPROCDEFID not in(select FProcDefID  from T_MC_JobDelegate where FOrgID=? ");
        } else {
            strBf.append(" where a.FPROCDEFID not in(select FProcDefID  from T_MC_JobDelegate where FOrgID is null ");
        }
        strBf.append(" and FInvalidDate > ? and FConsignor=? and FDelegateByProc=1 and FAgentType = 2 and FProcDefID is not null ) ");
        if (proName != null && proName.trim().length() > 0) {
            params = !StringUtils.isEmpty((String)orgID) ? new Object[]{orgID, cuttentDate, ctx.getCaller().toString(), "%" + proName + "%"} : new Object[]{cuttentDate, ctx.getCaller().toString(), "%" + proName + "%"};
            strBf.append(" and a.FName_L2 like ?");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strBf.toString(), (Object[])params);
        return rowSet;
    }

    @Override
    protected void _batchUpdateDelegate(Context ctx, Timestamp beginDate, Timestamp endDate, IObjectValue userInfo, String[] idArray, String[] proIdArray, String orgID) throws BOSException {
        this._delProcess(ctx, idArray);
        this._batchDelegateSave(ctx, beginDate, endDate, userInfo, proIdArray, orgID);
    }

    private boolean checkParentID(Context ctx, BOSUuid dOrgID, BOSUuid orgID) {
        try {
            IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            FullOrgUnitInfo info = iOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
            String longNumber = info.getLongNumber();
            if (longNumber.lastIndexOf("!") > 0) {
                longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
            }
            String[] numberArray = longNumber.split("!");
            for (int i = 0; i < numberArray.length; ++i) {
                numberArray[i] = longNumber;
                if (longNumber.lastIndexOf("!") <= 0) continue;
                longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
            }
            StringBuffer sbf = new StringBuffer();
            sbf.append("select FID from T_ORG_Admin where FLongNumber in(");
            for (int j = 0; j < numberArray.length; ++j) {
                if (j == 0) {
                    sbf.append("'");
                    sbf.append(numberArray[j]);
                    sbf.append("'");
                    continue;
                }
                sbf.append(",'");
                sbf.append(numberArray[j]);
                sbf.append("'");
            }
            sbf.append(") and FID='" + dOrgID + "'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sbf.toString());
            if (rowSet != null && rowSet.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u5224\u65ad\u7ec4\u7ec7ID\u7684\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u51fa\u9519", (Throwable)e);
        }
        return false;
    }

    private void _noOrgDelegateDel(Context ctx) throws BOSException {
        Timestamp timestamp = new Timestamp(new Date().getTime());
        timestamp = Timestamp.valueOf(timestamp.toString().substring(0, 19));
        Object[] params = null;
        String ksql = null;
        params = new Object[]{timestamp, timestamp, ctx.getCaller().toString()};
        ksql = " update T_MC_JobDelegate set  FInvalidDate = ? where FInvalidDate >=? and FConsignor = ? and FOrgID is not null";
        DbUtil.execute((Context)ctx, (String)ksql, (Object[])params);
    }

    private void _hasOrgDelegateDel(Context ctx) throws BOSException {
        Timestamp timestamp = new Timestamp(new Date().getTime());
        timestamp = Timestamp.valueOf(timestamp.toString().substring(0, 19));
        Object[] params = null;
        String ksql = null;
        params = new Object[]{timestamp, timestamp, ctx.getCaller().toString()};
        ksql = " update T_MC_JobDelegate set  FInvalidDate = ? where FInvalidDate >=? and FConsignor = ? and FOrgID is null";
        DbUtil.execute((Context)ctx, (String)ksql, (Object[])params);
    }

    @Override
    protected void _allDelegateSave(Context ctx, JobDelegateTansInfo delegateInfo) throws BOSException, EASBizException, LoopException {
        Timestamp startTime = new Timestamp(delegateInfo.getEffectDate().getTime());
        Timestamp endTime = new Timestamp(delegateInfo.getPlanInvalidDate().getTime());
        String endTimeStr = endTime.toString().substring(0, 19);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = dateFormat.parse(endTimeStr);
            endTime = new Timestamp(date.getTime());
        }
        catch (Exception e) {
            logger.error((Object)"_allDelegateSave failed", (Throwable)e);
        }
        JobDelegateAppUtil.checkEntrustRelation(ctx, delegateInfo.getConsignor().getId().toString(), delegateInfo, startTime, endTime, false);
        List userList = delegateInfo.getUserList();
        List orgList = delegateInfo.getOrgList();
        UserInfo checkUserInfo2 = null;
        for (UserInfo checkUserInfo2 : userList) {
            JobDelegateAppUtil.checkclosedloop(ctx, delegateInfo.getConsignor().getId().toString(), checkUserInfo2.getId().toString(), startTime, endTime, delegateInfo.getProcList());
        }
        IUserRangeEntry userRangeInstance = UserRangeEntryFactory.getLocalInstance(ctx);
        IOrgRangeEntry orgRangeInstance = OrgRangeEntryFactory.getLocalInstance(ctx);
        JobDelegateInfo info = new JobDelegateInfo();
        UserRangeEntryCollection userRange = new UserRangeEntryCollection();
        OrgRangeEntryCollection orgRange = new OrgRangeEntryCollection();
        UserRangeEntryInfo userEntryInfo = null;
        ObjectUuidPK pk = new ObjectUuidPK(delegateInfo.getId());
        BOSUuid id = BOSUuid.read((String)pk.toString());
        info.setId(id);
        info.setAllOrg(delegateInfo.isAllOrg());
        info.setAllProc(delegateInfo.isAllProc());
        info.setOtherDelegate(delegateInfo.isOther());
        info.setMsgRemind(delegateInfo.isMsgRemind());
        info.setMailRemind(delegateInfo.isMailRemind());
        info.setSmsRemind(delegateInfo.isSmsRemind());
        info.setPlanInvalidDate(endTime);
        info.setEffectDate(new Timestamp(delegateInfo.getEffectDate().getTime()));
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setReferrence(false);
        info.setInUse(true);
        info.setTemp(false);
        info.setConsignor(delegateInfo.getConsignor());
        if (delegateInfo.isAllOrg()) {
            for (int i = 0; i < userList.size(); ++i) {
                userEntryInfo = new UserRangeEntryInfo();
                userEntryInfo.setParent(info);
                userEntryInfo.setReferrence(false);
                userEntryInfo.setUser((UserInfo)userList.get(i));
                userRange.add(userEntryInfo);
            }
            try {
                userRangeInstance.addCollection(userRange);
                this.addnew(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
            }
            catch (EASBizException e) {
                logger.error((Object)"\u6dfb\u52a0\u4efb\u52a1\u59d4\u6258\u8bb0\u5f55\uff08\u5168\u90e8\u6d41\u7a0b-\u5168\u90e8\u7ec4\u7ec7\uff09\u65f6\u51fa\u9519", (Throwable)e);
            }
        } else {
            for (int i = 0; i < userList.size(); ++i) {
                userEntryInfo = new UserRangeEntryInfo();
                userEntryInfo.setParent(info);
                userEntryInfo.setReferrence(false);
                userEntryInfo.setUser((UserInfo)userList.get(i));
                userRange.add(userEntryInfo);
            }
            if (!delegateInfo.isAllOrg() && orgList != null) {
                List<Boolean> includeSubOrgs = delegateInfo.getIncludeSubOrgs();
                for (int k = 0; k < orgList.size(); ++k) {
                    OrgRangeEntryInfo orgEntryInfo = new OrgRangeEntryInfo();
                    orgEntryInfo.setParent(info);
                    orgEntryInfo.setReferrence(false);
                    FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                    fullOrgUnitInfo.setId(((OrgUnitInfo)orgList.get(k)).getId());
                    orgEntryInfo.setOrg(fullOrgUnitInfo);
                    if (includeSubOrgs != null) {
                        orgEntryInfo.setIncludeSubOrg(includeSubOrgs.get(k));
                    }
                    orgRange.add(orgEntryInfo);
                }
            }
            try {
                userRangeInstance.addCollection(userRange);
                orgRangeInstance.addCollection(orgRange);
                this.addnew(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
            }
            catch (EASBizException e) {
                logger.error((Object)"\u6dfb\u52a0\u4efb\u52a1\u59d4\u6258\u8bb0\u5f55\uff08\u5168\u90e8\u6d41\u7a0b-\u975e\u5168\u90e8\u7ec4\u7ec7\uff09\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
        this.addConsigneeBillCondition(delegateInfo, ctx);
    }

    @Override
    protected void _proDelegateSave(Context ctx, JobDelegateTansInfo delegateInfo) throws BOSException, EASBizException, LoopException {
        Timestamp startTime = new Timestamp(delegateInfo.getEffectDate().getTime());
        Timestamp endTime = new Timestamp(delegateInfo.getPlanInvalidDate().getTime());
        String endTimeStr = endTime.toString().substring(0, 19);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = dateFormat.parse(endTimeStr);
            endTime = new Timestamp(date.getTime());
        }
        catch (Exception e) {
            logger.error((Object)"_proDelegateSave failed", (Throwable)e);
        }
        JobDelegateAppUtil.checkEntrustRelation(ctx, delegateInfo.getConsignor().getId().toString(), delegateInfo, startTime, endTime, false);
        List userList = delegateInfo.getUserList();
        List orgList = delegateInfo.getOrgList();
        List procList = delegateInfo.getProcList();
        List otherUserList = delegateInfo.getOtheruserList();
        UserInfo checkUserInfo2 = null;
        for (UserInfo checkUserInfo2 : userList) {
            JobDelegateAppUtil.checkclosedloop(ctx, delegateInfo.getConsignor().getId().toString(), checkUserInfo2.getId().toString(), startTime, endTime, delegateInfo.getProcList());
        }
        IUserRangeEntry userRangeInstance = UserRangeEntryFactory.getLocalInstance(ctx);
        IotherUserRangeEntry otherUserRange = otherUserRangeEntryFactory.getLocalInstance(ctx);
        IOrgRangeEntry orgRangeInstance = OrgRangeEntryFactory.getLocalInstance(ctx);
        IProcRangeEntry procRangeInstance = ProcRangeEntryFactory.getLocalInstance(ctx);
        JobDelegateInfo info = new JobDelegateInfo();
        UserRangeEntryCollection userRange = new UserRangeEntryCollection();
        OrgRangeEntryCollection orgRange = new OrgRangeEntryCollection();
        ProcRangeEntryCollection procRange = new ProcRangeEntryCollection();
        otherUserRangeEntryCollection otherUserCollection = new otherUserRangeEntryCollection();
        UserRangeEntryInfo userEntryInfo = null;
        ProcRangeEntryInfo procEntryInfo = null;
        otherUserRangeEntryInfo otherUserRangeEntryInfo2 = null;
        ObjectUuidPK pk = new ObjectUuidPK(delegateInfo.getId());
        BOSUuid id = BOSUuid.read((String)pk.toString());
        info.setId(id);
        info.setAllOrg(delegateInfo.isAllOrg());
        info.setAllProc(delegateInfo.isAllProc());
        info.setOtherDelegate(delegateInfo.isOther());
        info.setMsgRemind(delegateInfo.isMsgRemind());
        info.setMailRemind(delegateInfo.isMailRemind());
        info.setSmsRemind(delegateInfo.isSmsRemind());
        info.setPlanInvalidDate(endTime);
        info.setEffectDate(new Timestamp(delegateInfo.getEffectDate().getTime()));
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setInUse(true);
        info.setReferrence(false);
        info.setTemp(false);
        info.setConsignor(delegateInfo.getConsignor());
        if (delegateInfo.isAllOrg()) {
            for (int i = 0; i < userList.size(); ++i) {
                userEntryInfo = new UserRangeEntryInfo();
                userEntryInfo.setParent(info);
                userEntryInfo.setReferrence(false);
                userEntryInfo.setUser((UserInfo)userList.get(i));
                userRange.add(userEntryInfo);
            }
            for (int j = 0; j < procList.size(); ++j) {
                procEntryInfo = new ProcRangeEntryInfo();
                procEntryInfo.setParent(info);
                procEntryInfo.setReferrence(false);
                procEntryInfo.setProcDefId(((ProcSelectedInfo)procList.get(j)).getProcDefId());
                procEntryInfo.setProcName(((ProcSelectedInfo)procList.get(j)).getName());
                procRange.add(procEntryInfo);
            }
            try {
                userRangeInstance.addCollection(userRange);
                procRangeInstance.addCollection(procRange);
                this.addnew(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
            }
            catch (EASBizException e) {
                logger.error((Object)"\u6dfb\u52a0\u4efb\u52a1\u59d4\u6258\u8bb0\u5f55\uff08\u975e\u5168\u90e8\u6d41\u7a0b-\u5168\u90e8\u7ec4\u7ec7\uff09\u65f6\u51fa\u9519", (Throwable)e);
            }
        } else {
            int i;
            for (i = 0; i < userList.size(); ++i) {
                userEntryInfo = new UserRangeEntryInfo();
                userEntryInfo.setParent(info);
                userEntryInfo.setReferrence(false);
                userEntryInfo.setUser((UserInfo)userList.get(i));
                userRange.add(userEntryInfo);
            }
            if (otherUserList != null) {
                for (i = 0; i < otherUserList.size(); ++i) {
                    otherUserRangeEntryInfo2 = new otherUserRangeEntryInfo();
                    otherUserRangeEntryInfo2.setParent(info);
                    otherUserRangeEntryInfo2.setReferrence(false);
                    otherUserRangeEntryInfo2.setUser((UserInfo)otherUserList.get(i));
                    otherUserCollection.add(otherUserRangeEntryInfo2);
                }
            }
            if (!delegateInfo.isAllOrg() && orgList != null) {
                List<Boolean> includeSubOrgs = delegateInfo.getIncludeSubOrgs();
                for (int k = 0; k < orgList.size(); ++k) {
                    OrgRangeEntryInfo orgEntryInfo = new OrgRangeEntryInfo();
                    orgEntryInfo.setParent(info);
                    orgEntryInfo.setReferrence(false);
                    FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                    fullOrgUnitInfo.setId(((OrgUnitInfo)orgList.get(k)).getId());
                    orgEntryInfo.setOrg(fullOrgUnitInfo);
                    if (includeSubOrgs != null) {
                        orgEntryInfo.setIncludeSubOrg(includeSubOrgs.get(k));
                    }
                    orgRange.add(orgEntryInfo);
                }
            }
            for (int j = 0; j < procList.size(); ++j) {
                procEntryInfo = new ProcRangeEntryInfo();
                procEntryInfo.setParent(info);
                procEntryInfo.setReferrence(false);
                procEntryInfo.setProcDefId(((ProcSelectedInfo)procList.get(j)).getProcDefId());
                procEntryInfo.setProcName(((ProcSelectedInfo)procList.get(j)).getName());
                procRange.add(procEntryInfo);
            }
            try {
                userRangeInstance.addCollection(userRange);
                orgRangeInstance.addCollection(orgRange);
                procRangeInstance.addCollection(procRange);
                otherUserRange.addCollection(otherUserCollection);
                this.addnew(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
            }
            catch (EASBizException e) {
                logger.error((Object)"\u6dfb\u52a0\u4efb\u52a1\u59d4\u6258\u8bb0\u5f55\uff08\u975e\u5168\u90e8\u6d41\u7a0b-\u975e\u5168\u90e8\u7ec4\u7ec7\uff09\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
        this.addConsigneeBillCondition(delegateInfo, ctx);
    }

    private void addConsigneeBillCondition(JobDelegateTansInfo delegateInfo, Context ctx) throws BOSException {
        int i;
        IUserRangeCondition urcInstance = UserRangeConditionFactory.getLocalInstance(ctx);
        IMcBillCondition mbcInstance = McBillConditionFactory.getLocalInstance(ctx);
        List<McBillConditionInfo> conditionList = delegateInfo.getConditionList();
        List<UserRangeConditionInfo> userRangeConditionList = delegateInfo.getUserRangeConditionList();
        if (conditionList != null) {
            for (i = 0; i < conditionList.size(); ++i) {
                mbcInstance.addnew(conditionList.get(i));
            }
        }
        if (userRangeConditionList != null) {
            for (i = 0; i < userRangeConditionList.size(); ++i) {
                urcInstance.addnew(userRangeConditionList.get(i));
            }
        }
    }

    private void deleteConsigneeBillCondition(String delegateId, Context ctx) throws BOSException {
        IUserRangeCondition urcInstance = UserRangeConditionFactory.getLocalInstance(ctx);
        IMcBillCondition mbcInstance = McBillConditionFactory.getLocalInstance(ctx);
        UserRangeConditionCollection urcConditions = urcInstance.getCollection("where jobDelegateId='" + delegateId + "'");
        if (urcConditions != null) {
            ObjectUuidPK[] pks = new ObjectUuidPK[urcConditions.size()];
            for (int i = 0; i < urcConditions.size(); ++i) {
                String conditionId = urcConditions.get(i).getConditionId().toString();
                pks[i] = new ObjectUuidPK(conditionId);
            }
            mbcInstance.delete((IObjectPK[])pks);
            urcInstance.delete("where jobDelegateId='" + delegateId + "'");
        }
    }

    private boolean stringInArray(String item, String[] array) {
        if ("NONE".equals(item)) {
            return true;
        }
        if ("HRO".equals(item)) {
            return true;
        }
        boolean flag = false;
        if (array != null && array.length > 0 || !StringUtils.isEmpty((String)item)) {
            for (int i = 0; i < array.length; ++i) {
                if (!item.equals(array[i])) continue;
                flag = true;
                break;
            }
        } else {
            return false;
        }
        return flag;
    }

    @Override
    protected JobDelegateAllInfo _getDelegateAllInfo(Context ctx, String Id) throws BOSException {
        return JobDelegateAppUtil.getAllInfo(ctx, Id);
    }

    @Override
    protected List _getNewDelegateList(Context ctx) throws BOSException {
        LinkedList returnList = new LinkedList();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select FID from T_MC_JobDelegate where ");
        sqlBuffer.append("FConsignor = '" + ctx.getCaller().toString() + "'");
        sqlBuffer.append(" and FTemp = 0 order by FEffectDate desc");
        IRowSet delegateRs = null;
        try {
            delegateRs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"getDelegateList\uff08\u83b7\u53d6\u7528\u6237\u59d4\u6258\u8bb0\u5f55\u96c6\uff09\u65f6\u51fa\u9519", (Throwable)e);
        }
        LinkedList allInfoList = new LinkedList();
        String headID = null;
        String allOrgText = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateResource", (String)"allOrg", (Locale)ctx.getLocale());
        String allProcText = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateResource", (String)"allProc", (Locale)ctx.getLocale());
        String noOtherPerson = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateResource", (String)"emptyPerson", (Locale)ctx.getLocale());
        StringBuffer bf = new StringBuffer();
        try {
            if (delegateRs != null) {
                while (delegateRs.next()) {
                    headID = delegateRs.getString("FID");
                    bf.append(headID);
                    bf.append(",");
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u5728\u6784\u9020JobDelegateAllInfo\u96c6\u5408\u65f6\u51fa\u9519", (Throwable)e);
        }
        String idList = "";
        if (bf.length() <= 0) {
            return returnList;
        }
        idList = bf.toString().substring(0, bf.length() - 1);
        IJobDelegate jobDalegate = JobDelegateFactory.getLocalInstance(ctx);
        IOrgRangeEntry orgRange = OrgRangeEntryFactory.getLocalInstance(ctx);
        IProcRangeEntry procRange = ProcRangeEntryFactory.getLocalInstance(ctx);
        IUserRangeEntry userRange = UserRangeEntryFactory.getLocalInstance(ctx);
        IotherUserRangeEntry otherUserRange = otherUserRangeEntryFactory.getLocalInstance(ctx);
        OrgRangeEntryCollection allorgCollection = null;
        ProcRangeEntryCollection allprocCollection = null;
        UserRangeEntryCollection alluserCollection = null;
        otherUserRangeEntryCollection allotherUserCollection = null;
        JobDelegateCollection alljobDelegateInfoColl = null;
        EntityViewInfo jobView = new EntityViewInfo();
        FilterInfo jobfilter = new FilterInfo();
        jobfilter.getFilterItems().add(new FilterItemInfo("id", (Object)idList, CompareType.INCLUDE));
        jobView.setFilter(jobfilter);
        alljobDelegateInfoColl = jobDalegate.getJobDelegateCollection(jobView);
        EntityViewInfo orcView = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("org.name"));
        selector.add(new SelectorItemInfo("parent.id"));
        selector.add(new SelectorItemInfo("parent"));
        orcView.getSelector().addObjectCollection((IObjectCollection)selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)idList, CompareType.INCLUDE));
        orcView.setFilter(filter);
        allorgCollection = orgRange.getCollection(orcView);
        EntityViewInfo procView = new EntityViewInfo();
        SelectorItemCollection procselector = new SelectorItemCollection();
        procselector.add(new SelectorItemInfo("id"));
        procselector.add(new SelectorItemInfo("ProcName"));
        procselector.add(new SelectorItemInfo("parent"));
        procselector.add(new SelectorItemInfo("parent.id"));
        procView.getSelector().addObjectCollection((IObjectCollection)procselector);
        FilterInfo procfilter = new FilterInfo();
        procfilter.getFilterItems().add(new FilterItemInfo("parent", (Object)idList, CompareType.INCLUDE));
        procView.setFilter(procfilter);
        allprocCollection = procRange.getCollection(procView);
        EntityViewInfo userView = new EntityViewInfo();
        SelectorItemCollection userselector = new SelectorItemCollection();
        userselector.add(new SelectorItemInfo("id"));
        userselector.add(new SelectorItemInfo("user.id"));
        userselector.add(new SelectorItemInfo("user.person.id"));
        userselector.add(new SelectorItemInfo("user.person.name"));
        userselector.add(new SelectorItemInfo("parent"));
        userselector.add(new SelectorItemInfo("parent.id"));
        userView.getSelector().addObjectCollection((IObjectCollection)userselector);
        FilterInfo userfilter = new FilterInfo();
        userfilter.getFilterItems().add(new FilterItemInfo("parent", (Object)idList, CompareType.INCLUDE));
        userView.setFilter(userfilter);
        alluserCollection = userRange.getCollection(userView);
        EntityViewInfo otheruserView = new EntityViewInfo();
        SelectorItemCollection otheruserselector = new SelectorItemCollection();
        otheruserselector.add(new SelectorItemInfo("id"));
        otheruserselector.add(new SelectorItemInfo("user.id"));
        otheruserselector.add(new SelectorItemInfo("user.person.id"));
        otheruserselector.add(new SelectorItemInfo("user.person.name"));
        otheruserselector.add(new SelectorItemInfo("parent"));
        otheruserselector.add(new SelectorItemInfo("parent.id"));
        otheruserView.getSelector().addObjectCollection((IObjectCollection)otheruserselector);
        FilterInfo otheruserfilter = new FilterInfo();
        otheruserfilter.getFilterItems().add(new FilterItemInfo("parent", (Object)idList, CompareType.INCLUDE));
        otheruserView.setFilter(otheruserfilter);
        allotherUserCollection = otherUserRange.getCollection(otheruserView);
        HashMap<JobDelegateInfo, JobDelegateAllInfo> headMap = new HashMap<JobDelegateInfo, JobDelegateAllInfo>();
        String[] idArray = idList.split(",");
        OrgRangeEntryCollection orgtmpCollection = null;
        ProcRangeEntryCollection proctmpCollection = null;
        UserRangeEntryCollection usertmpCollection = null;
        otherUserRangeEntryCollection othertmpUserCollection = null;
        JobDelegateInfo jobtmpDelegateInfo = null;
        JobDelegateAllInfo allInfo = null;
        for (int i = 0; i < idArray.length; ++i) {
            orgtmpCollection = new OrgRangeEntryCollection();
            proctmpCollection = new ProcRangeEntryCollection();
            usertmpCollection = new UserRangeEntryCollection();
            othertmpUserCollection = new otherUserRangeEntryCollection();
            String id = idArray[i];
            allInfo = new JobDelegateAllInfo();
            int jobSize = alljobDelegateInfoColl.size();
            for (int jsize = 0; jsize < jobSize; ++jsize) {
                JobDelegateInfo info = alljobDelegateInfoColl.get(jsize);
                if (!info.getId().toString().equals(id)) continue;
                jobtmpDelegateInfo = info;
            }
            int size = allorgCollection.size();
            for (int j = 0; j < size; ++j) {
                OrgRangeEntryInfo orgInfo = allorgCollection.get(j);
                if (!orgInfo.getParent().getId().toString().equals(id)) continue;
                orgtmpCollection.add(orgInfo);
            }
            int procsize = allprocCollection.size();
            for (int j = 0; j < procsize; ++j) {
                ProcRangeEntryInfo procInfo = allprocCollection.get(j);
                if (!procInfo.getParent().getId().toString().equals(id)) continue;
                proctmpCollection.add(procInfo);
            }
            int usersize = alluserCollection.size();
            for (int j = 0; j < usersize; ++j) {
                UserRangeEntryInfo userInfo = alluserCollection.get(j);
                if (!userInfo.getParent().getId().toString().equals(id)) continue;
                usertmpCollection.add(userInfo);
            }
            int otherusersize = allotherUserCollection.size();
            for (int j = 0; j < otherusersize; ++j) {
                otherUserRangeEntryInfo otheruserInfo = allotherUserCollection.get(j);
                if (!otheruserInfo.getParent().getId().toString().equals(id)) continue;
                othertmpUserCollection.add(otheruserInfo);
            }
            allInfo.setOrgEntry(orgtmpCollection);
            allInfo.setOtherUserEntry(othertmpUserCollection);
            allInfo.setParentInfo(jobtmpDelegateInfo);
            allInfo.setProcEntry(proctmpCollection);
            allInfo.setUserEntry(usertmpCollection);
            headMap.put(jobtmpDelegateInfo, allInfo);
        }
        HashMap<String, Object> rowMap = null;
        String org = "";
        String proc = "";
        String person = "";
        JobDelegateInfo jobDelegateInfo = null;
        OrgRangeEntryCollection orgCollection = null;
        ProcRangeEntryCollection procCollection = null;
        UserRangeEntryCollection userCollection = null;
        otherUserRangeEntryCollection otherUserCollection = null;
        PersonCollection personCollection = null;
        PersonCollection otherPersonCollection = null;
        OrgRangeEntryInfo orgRangeInfo = null;
        ProcRangeEntryInfo procRangeInfo = null;
        PersonInfo personInfo = null;
        Iterator it = headMap.keySet().iterator();
        JobDelegateAllInfo newAllInfo = null;
        while (it.hasNext()) {
            rowMap = new HashMap<String, Object>();
            jobDelegateInfo = (JobDelegateInfo)it.next();
            newAllInfo = (JobDelegateAllInfo)headMap.get(jobDelegateInfo);
            orgCollection = newAllInfo.getOrgEntry();
            procCollection = newAllInfo.getProcEntry();
            userCollection = newAllInfo.getUserEntry();
            otherUserCollection = newAllInfo.getOtherUserEntry();
            personCollection = this.getNewPersonByUserRange(ctx, userCollection);
            otherPersonCollection = this.getNewPersonByOtherUserRange(ctx, otherUserCollection);
            org = "";
            proc = "";
            person = "";
            if (jobDelegateInfo.isAllProc()) {
                proc = allProcText;
                if (jobDelegateInfo.isAllOrg()) {
                    org = allOrgText;
                } else {
                    for (int j = 0; j < orgCollection.size(); ++j) {
                        orgRangeInfo = orgCollection.get(j);
                        org = j == 0 ? org + orgRangeInfo.getOrg().getName() : org + ";" + orgRangeInfo.getOrg().getName();
                    }
                }
            } else {
                for (int k = 0; k < procCollection.size(); ++k) {
                    procRangeInfo = procCollection.get(k);
                    proc = k == 0 ? proc + procRangeInfo.getProcName() : proc + ";" + procRangeInfo.getProcName();
                }
                if (jobDelegateInfo.isAllOrg()) {
                    org = allOrgText;
                } else {
                    for (int j = 0; j < orgCollection.size(); ++j) {
                        orgRangeInfo = orgCollection.get(j);
                        org = j == 0 ? org + this.getOrgName(ctx, orgRangeInfo) : org + ";" + this.getOrgName(ctx, orgRangeInfo);
                    }
                }
            }
            for (int m = 0; m < personCollection.size(); ++m) {
                personInfo = personCollection.get(m);
                person = m == 0 ? person + personInfo.getName() : person + ";" + personInfo.getName();
            }
            String otherPerson = "";
            if (!jobDelegateInfo.isOtherDelegate()) {
                otherPerson = noOtherPerson;
            } else {
                for (int n = 0; n < otherPersonCollection.size(); ++n) {
                    personInfo = otherPersonCollection.get(n);
                    otherPerson = n == 0 ? otherPerson + personInfo.getName() : otherPerson + ";" + personInfo.getName();
                }
            }
            rowMap.put("id", jobDelegateInfo.getId().toString());
            rowMap.put("effectDate", jobDelegateInfo.getEffectDate());
            rowMap.put("invalidDate", jobDelegateInfo.getPlanInvalidDate());
            rowMap.put("isOther", new Boolean(jobDelegateInfo.isOtherDelegate()));
            rowMap.put("org", org);
            rowMap.put("proc", proc);
            rowMap.put("person", person);
            rowMap.put("otherPerson", otherPerson);
            rowMap.put("inUse", new Boolean(jobDelegateInfo.isInUse()));
            rowMap.put("referrence", new Boolean(jobDelegateInfo.isReferrence()));
            returnList.add(rowMap);
        }
        return returnList;
    }

    @Override
    protected List _getNewDelegateList(Context ctx, String consignorInfo) throws BOSException {
        LinkedList returnList = new LinkedList();
        StringBuffer sqlBuffer = new StringBuffer();
        UserInfo u = ContextUtil.getCurrentUserInfo((Context)ctx);
        Locale l = ctx.getLocale();
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(u.getId().toString())) {
            sqlBuffer.append("select j.FID FID,u.FNAME_" + l + " CONSIGNOR ");
            sqlBuffer.append("from T_MC_JobDelegate j ");
            sqlBuffer.append("LEFT OUTER JOIN T_PM_USER u ON J.FCONSIGNOR = U.FID where ");
            if (consignorInfo != null && !"".equals(consignorInfo)) {
                sqlBuffer.append("u.FNAME_" + l + " LIKE '%" + consignorInfo + "%' and ");
            }
            sqlBuffer.append("j.FTemp = 0 order by j.FEffectDate desc");
        } else {
            sqlBuffer.append("select FID from T_MC_JobDelegate where ");
            sqlBuffer.append("FCONSIGNOR = '" + ctx.getCaller().toString() + "'");
            sqlBuffer.append(" and FTemp = 0 order by FEffectDate desc");
        }
        IRowSet delegateRs = null;
        try {
            delegateRs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"getDelegateList\uff08\u83b7\u53d6\u7528\u6237\u59d4\u6258\u8bb0\u5f55\u96c6\uff09\u65f6\u51fa\u9519", (Throwable)e);
        }
        LinkedList allInfoList = new LinkedList();
        String headID = null;
        HashMap<String, String> consignorMap = new HashMap<String, String>();
        String allOrgText = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateResource", (String)"allOrg", (Locale)ctx.getLocale());
        String allProcText = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateResource", (String)"allProc", (Locale)ctx.getLocale());
        String noOtherPerson = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateResource", (String)"emptyPerson", (Locale)ctx.getLocale());
        StringBuffer bf = new StringBuffer();
        try {
            if (delegateRs != null) {
                while (delegateRs.next()) {
                    headID = delegateRs.getString("FID");
                    bf.append(headID);
                    bf.append(",");
                    if (!"00000000-0000-0000-0000-00000000000013B7DE7F".equals(u.getId().toString())) continue;
                    String consignorName = delegateRs.getString("CONSIGNOR");
                    consignorMap.put(headID, consignorName);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u5728\u6784\u9020JobDelegateAllInfo\u96c6\u5408\u65f6\u51fa\u9519", (Throwable)e);
        }
        String idList = "";
        if (bf.length() <= 0) {
            return returnList;
        }
        idList = bf.toString().substring(0, bf.length() - 1);
        IJobDelegate jobDalegate = JobDelegateFactory.getLocalInstance(ctx);
        IOrgRangeEntry orgRange = OrgRangeEntryFactory.getLocalInstance(ctx);
        IProcRangeEntry procRange = ProcRangeEntryFactory.getLocalInstance(ctx);
        IUserRangeEntry userRange = UserRangeEntryFactory.getLocalInstance(ctx);
        IotherUserRangeEntry otherUserRange = otherUserRangeEntryFactory.getLocalInstance(ctx);
        OrgRangeEntryCollection allorgCollection = null;
        ProcRangeEntryCollection allprocCollection = null;
        UserRangeEntryCollection alluserCollection = null;
        otherUserRangeEntryCollection allotherUserCollection = null;
        JobDelegateCollection alljobDelegateInfoColl = null;
        EntityViewInfo jobView = new EntityViewInfo();
        FilterInfo jobfilter = new FilterInfo();
        jobfilter.getFilterItems().add(new FilterItemInfo("id", (Object)idList, CompareType.INCLUDE));
        jobView.setFilter(jobfilter);
        alljobDelegateInfoColl = jobDalegate.getJobDelegateCollection(jobView);
        EntityViewInfo orcView = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("org.name"));
        selector.add(new SelectorItemInfo("parent.id"));
        selector.add(new SelectorItemInfo("parent"));
        orcView.getSelector().addObjectCollection((IObjectCollection)selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)idList, CompareType.INCLUDE));
        orcView.setFilter(filter);
        allorgCollection = orgRange.getCollection(orcView);
        EntityViewInfo procView = new EntityViewInfo();
        SelectorItemCollection procselector = new SelectorItemCollection();
        procselector.add(new SelectorItemInfo("id"));
        procselector.add(new SelectorItemInfo("ProcName"));
        procselector.add(new SelectorItemInfo("parent"));
        procselector.add(new SelectorItemInfo("parent.id"));
        procView.getSelector().addObjectCollection((IObjectCollection)procselector);
        FilterInfo procfilter = new FilterInfo();
        procfilter.getFilterItems().add(new FilterItemInfo("parent", (Object)idList, CompareType.INCLUDE));
        procView.setFilter(procfilter);
        allprocCollection = procRange.getCollection(procView);
        EntityViewInfo userView = new EntityViewInfo();
        SelectorItemCollection userselector = new SelectorItemCollection();
        userselector.add(new SelectorItemInfo("id"));
        userselector.add(new SelectorItemInfo("user.id"));
        userselector.add(new SelectorItemInfo("user.person.id"));
        userselector.add(new SelectorItemInfo("user.person.name"));
        userselector.add(new SelectorItemInfo("parent"));
        userselector.add(new SelectorItemInfo("parent.id"));
        userView.getSelector().addObjectCollection((IObjectCollection)userselector);
        FilterInfo userfilter = new FilterInfo();
        userfilter.getFilterItems().add(new FilterItemInfo("parent", (Object)idList, CompareType.INCLUDE));
        userView.setFilter(userfilter);
        alluserCollection = userRange.getCollection(userView);
        EntityViewInfo otheruserView = new EntityViewInfo();
        SelectorItemCollection otheruserselector = new SelectorItemCollection();
        otheruserselector.add(new SelectorItemInfo("id"));
        otheruserselector.add(new SelectorItemInfo("user.id"));
        otheruserselector.add(new SelectorItemInfo("user.person.id"));
        otheruserselector.add(new SelectorItemInfo("user.person.name"));
        otheruserselector.add(new SelectorItemInfo("parent"));
        otheruserselector.add(new SelectorItemInfo("parent.id"));
        otheruserView.getSelector().addObjectCollection((IObjectCollection)otheruserselector);
        FilterInfo otheruserfilter = new FilterInfo();
        otheruserfilter.getFilterItems().add(new FilterItemInfo("parent", (Object)idList, CompareType.INCLUDE));
        otheruserView.setFilter(otheruserfilter);
        allotherUserCollection = otherUserRange.getCollection(otheruserView);
        HashMap<JobDelegateInfo, JobDelegateAllInfo> headMap = new HashMap<JobDelegateInfo, JobDelegateAllInfo>();
        String[] idArray = idList.split(",");
        OrgRangeEntryCollection orgtmpCollection = null;
        ProcRangeEntryCollection proctmpCollection = null;
        UserRangeEntryCollection usertmpCollection = null;
        otherUserRangeEntryCollection othertmpUserCollection = null;
        JobDelegateInfo jobtmpDelegateInfo = null;
        JobDelegateAllInfo allInfo = null;
        for (int i = 0; i < idArray.length; ++i) {
            orgtmpCollection = new OrgRangeEntryCollection();
            proctmpCollection = new ProcRangeEntryCollection();
            usertmpCollection = new UserRangeEntryCollection();
            othertmpUserCollection = new otherUserRangeEntryCollection();
            String id = idArray[i];
            allInfo = new JobDelegateAllInfo();
            int jobSize = alljobDelegateInfoColl.size();
            for (int jsize = 0; jsize < jobSize; ++jsize) {
                JobDelegateInfo info = alljobDelegateInfoColl.get(jsize);
                if (!info.getId().toString().equals(id)) continue;
                jobtmpDelegateInfo = info;
            }
            int size = allorgCollection.size();
            for (int j = 0; j < size; ++j) {
                OrgRangeEntryInfo orgInfo = allorgCollection.get(j);
                if (!orgInfo.getParent().getId().toString().equals(id)) continue;
                orgtmpCollection.add(orgInfo);
            }
            int procsize = allprocCollection.size();
            for (int j = 0; j < procsize; ++j) {
                ProcRangeEntryInfo procInfo = allprocCollection.get(j);
                if (!procInfo.getParent().getId().toString().equals(id)) continue;
                proctmpCollection.add(procInfo);
            }
            int usersize = alluserCollection.size();
            for (int j = 0; j < usersize; ++j) {
                UserRangeEntryInfo userInfo = alluserCollection.get(j);
                if (!userInfo.getParent().getId().toString().equals(id)) continue;
                usertmpCollection.add(userInfo);
            }
            int otherusersize = allotherUserCollection.size();
            for (int j = 0; j < otherusersize; ++j) {
                otherUserRangeEntryInfo otheruserInfo = allotherUserCollection.get(j);
                if (!otheruserInfo.getParent().getId().toString().equals(id)) continue;
                othertmpUserCollection.add(otheruserInfo);
            }
            allInfo.setOrgEntry(orgtmpCollection);
            allInfo.setOtherUserEntry(othertmpUserCollection);
            allInfo.setParentInfo(jobtmpDelegateInfo);
            allInfo.setProcEntry(proctmpCollection);
            allInfo.setUserEntry(usertmpCollection);
            headMap.put(jobtmpDelegateInfo, allInfo);
        }
        HashMap rowMap = null;
        String org = "";
        String proc = "";
        String person = "";
        JobDelegateInfo jobDelegateInfo = null;
        OrgRangeEntryCollection orgCollection = null;
        ProcRangeEntryCollection procCollection = null;
        UserRangeEntryCollection userCollection = null;
        otherUserRangeEntryCollection otherUserCollection = null;
        PersonCollection personCollection = null;
        PersonCollection otherPersonCollection = null;
        OrgRangeEntryInfo orgRangeInfo = null;
        ProcRangeEntryInfo procRangeInfo = null;
        PersonInfo personInfo = null;
        Iterator it = headMap.keySet().iterator();
        JobDelegateAllInfo newAllInfo = null;
        while (it.hasNext()) {
            rowMap = new HashMap();
            jobDelegateInfo = (JobDelegateInfo)it.next();
            newAllInfo = (JobDelegateAllInfo)headMap.get(jobDelegateInfo);
            orgCollection = newAllInfo.getOrgEntry();
            procCollection = newAllInfo.getProcEntry();
            userCollection = newAllInfo.getUserEntry();
            otherUserCollection = newAllInfo.getOtherUserEntry();
            personCollection = this.getNewPersonByUserRange(ctx, userCollection);
            otherPersonCollection = this.getNewPersonByOtherUserRange(ctx, otherUserCollection);
            org = "";
            proc = "";
            person = "";
            if (jobDelegateInfo.isAllProc()) {
                proc = allProcText;
                if (jobDelegateInfo.isAllOrg()) {
                    org = allOrgText;
                } else {
                    for (int j = 0; j < orgCollection.size(); ++j) {
                        orgRangeInfo = orgCollection.get(j);
                        org = j == 0 ? org + orgRangeInfo.getOrg().getName() : org + ";" + orgRangeInfo.getOrg().getName();
                    }
                }
            } else {
                for (int k = 0; k < procCollection.size(); ++k) {
                    procRangeInfo = procCollection.get(k);
                    proc = k == 0 ? proc + procRangeInfo.getProcName() : proc + ";" + procRangeInfo.getProcName();
                }
                if (jobDelegateInfo.isAllOrg()) {
                    org = allOrgText;
                } else {
                    for (int j = 0; j < orgCollection.size(); ++j) {
                        orgRangeInfo = orgCollection.get(j);
                        org = j == 0 ? org + this.getOrgName(ctx, orgRangeInfo) : org + ";" + this.getOrgName(ctx, orgRangeInfo);
                    }
                }
            }
            for (int m = 0; m < personCollection.size(); ++m) {
                personInfo = personCollection.get(m);
                person = m == 0 ? person + personInfo.getName() : person + ";" + personInfo.getName();
            }
            String otherPerson = "";
            if (!jobDelegateInfo.isOtherDelegate()) {
                otherPerson = noOtherPerson;
            } else {
                for (int n = 0; n < otherPersonCollection.size(); ++n) {
                    personInfo = otherPersonCollection.get(n);
                    otherPerson = n == 0 ? otherPerson + personInfo.getName() : otherPerson + ";" + personInfo.getName();
                }
            }
            rowMap.put("consignor", consignorMap.get(jobDelegateInfo.getId().toString()));
            rowMap.put("id", jobDelegateInfo.getId().toString());
            rowMap.put("effectDate", jobDelegateInfo.getEffectDate());
            rowMap.put("invalidDate", jobDelegateInfo.getPlanInvalidDate());
            rowMap.put("isOther", new Boolean(jobDelegateInfo.isOtherDelegate()));
            rowMap.put("org", org);
            rowMap.put("proc", proc);
            rowMap.put("person", person);
            rowMap.put("otherPerson", otherPerson);
            rowMap.put("inUse", new Boolean(jobDelegateInfo.isInUse()));
            rowMap.put("referrence", new Boolean(jobDelegateInfo.isReferrence()));
            returnList.add(rowMap);
        }
        return returnList;
    }

    @Override
    protected List _getDelegateList(Context ctx) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select FID from T_MC_JobDelegate where ");
        sqlBuffer.append("FConsignor= '" + ctx.getCaller().toString() + "'");
        sqlBuffer.append(" and FTemp = 0 order by FEffectDate desc");
        IRowSet delegateRs = null;
        try {
            delegateRs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"getDelegateList\uff08\u83b7\u53d6\u7528\u6237\u59d4\u6258\u8bb0\u5f55\u96c6\uff09\u65f6\u51fa\u9519", (Throwable)e);
        }
        LinkedList<JobDelegateAllInfo> allInfoList = new LinkedList<JobDelegateAllInfo>();
        JobDelegateAllInfo allInfo = null;
        String headID = null;
        String allOrgText = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateResource", (String)"allOrg", (Locale)ctx.getLocale());
        String allProcText = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateResource", (String)"allProc", (Locale)ctx.getLocale());
        String noOtherPerson = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateResource", (String)"emptyPerson", (Locale)ctx.getLocale());
        try {
            if (delegateRs != null) {
                while (delegateRs.next()) {
                    headID = delegateRs.getString("FID");
                    allInfo = JobDelegateAppUtil.getAllInfo(ctx, headID);
                    allInfoList.add(allInfo);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u5728\u6784\u9020JobDelegateAllInfo\u96c6\u5408\u65f6\u51fa\u9519", (Throwable)e);
        }
        HashMap<String, Object> rowMap = null;
        LinkedList returnList = new LinkedList();
        String org = "";
        String proc = "";
        String person = "";
        JobDelegateInfo jobDelegateInfo = null;
        OrgRangeEntryCollection orgCollection = null;
        ProcRangeEntryCollection procCollection = null;
        UserRangeEntryCollection userCollection = null;
        otherUserRangeEntryCollection otherUserCollection = null;
        PersonCollection personCollection = null;
        PersonCollection otherPersonCollection = null;
        OrgRangeEntryInfo orgRangeInfo = null;
        ProcRangeEntryInfo procRangeInfo = null;
        PersonInfo personInfo = null;
        for (int i = 0; i < allInfoList.size(); ++i) {
            rowMap = new HashMap<String, Object>();
            allInfo = (JobDelegateAllInfo)allInfoList.get(i);
            jobDelegateInfo = allInfo.getParentInfo();
            orgCollection = allInfo.getOrgEntry();
            procCollection = allInfo.getProcEntry();
            userCollection = allInfo.getUserEntry();
            otherUserCollection = allInfo.getOtherUserEntry();
            personCollection = this.getPersonByUserRange(ctx, userCollection);
            otherPersonCollection = this.getPersonByOtherUserRange(ctx, otherUserCollection);
            org = "";
            proc = "";
            person = "";
            if (jobDelegateInfo.isAllProc()) {
                proc = allProcText;
                if (jobDelegateInfo.isAllOrg()) {
                    org = allOrgText;
                } else {
                    for (int j = 0; j < orgCollection.size(); ++j) {
                        orgRangeInfo = orgCollection.get(j);
                        org = j == 0 ? org + orgRangeInfo.getOrg().getName() : org + ";" + orgRangeInfo.getOrg().getName();
                    }
                }
            } else {
                for (int k = 0; k < procCollection.size(); ++k) {
                    procRangeInfo = procCollection.get(k);
                    proc = k == 0 ? proc + procRangeInfo.getProcName() : proc + ";" + procRangeInfo.getProcName();
                }
                if (jobDelegateInfo.isAllOrg()) {
                    org = allOrgText;
                } else {
                    for (int j = 0; j < orgCollection.size(); ++j) {
                        orgRangeInfo = orgCollection.get(j);
                        org = j == 0 ? org + this.getOrgName(ctx, orgRangeInfo) : org + ";" + this.getOrgName(ctx, orgRangeInfo);
                    }
                }
            }
            for (int m = 0; m < personCollection.size(); ++m) {
                personInfo = personCollection.get(m);
                person = m == 0 ? person + personInfo.getName() : person + ";" + personInfo.getName();
            }
            String otherPerson = "";
            if (!jobDelegateInfo.isOtherDelegate()) {
                otherPerson = noOtherPerson;
            } else {
                for (int n = 0; n < otherPersonCollection.size(); ++n) {
                    personInfo = otherPersonCollection.get(n);
                    otherPerson = n == 0 ? otherPerson + personInfo.getName() : otherPerson + ";" + personInfo.getName();
                }
            }
            rowMap.put("id", jobDelegateInfo.getId().toString());
            rowMap.put("effectDate", jobDelegateInfo.getEffectDate());
            rowMap.put("invalidDate", jobDelegateInfo.getPlanInvalidDate());
            rowMap.put("isOther", new Boolean(jobDelegateInfo.isOtherDelegate()));
            rowMap.put("org", org);
            rowMap.put("proc", proc);
            rowMap.put("person", person);
            rowMap.put("otherPerson", otherPerson);
            rowMap.put("inUse", new Boolean(jobDelegateInfo.isInUse()));
            rowMap.put("referrence", new Boolean(jobDelegateInfo.isReferrence()));
            returnList.add(rowMap);
        }
        return returnList;
    }

    private PersonCollection getNewPersonByUserRange(Context ctx, UserRangeEntryCollection userCollection) throws BOSException {
        PersonCollection personCollection = new PersonCollection();
        HashMap personIdMap = new HashMap();
        IUser userInstance = UserFactory.getLocalInstance((Context)ctx);
        try {
            for (int i = 0; i < userCollection.size(); ++i) {
                String userId = userCollection.get(i).getUser().getId().toString();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("person.id"));
                selector.add(new SelectorItemInfo("person.name"));
                UserInfo userInfo = userInstance.getUserInfo((IObjectPK)new ObjectUuidPK(userId), selector);
                String personId = userInfo.getPerson().getId().toString();
                if (personIdMap.containsKey(personId)) continue;
                personIdMap.put(personId, null);
                personCollection.add(userInfo.getPerson());
            }
        }
        catch (Exception e) {
            logger.error((Object)"getNewPersonByUserRange failed", (Throwable)e);
        }
        return personCollection;
    }

    private PersonCollection getNewPersonByOtherUserRange(Context ctx, otherUserRangeEntryCollection otheruserCollection) throws BOSException {
        HashMap personIdMap = new HashMap();
        PersonCollection personCollection = new PersonCollection();
        String personId = null;
        IUser userInstance = UserFactory.getLocalInstance((Context)ctx);
        try {
            for (int i = 0; i < otheruserCollection.size(); ++i) {
                String userId = otheruserCollection.get(i).getUser().getId().toString();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("person.id"));
                selector.add(new SelectorItemInfo("person.name"));
                UserInfo userInfo = userInstance.getUserInfo((IObjectPK)new ObjectUuidPK(userId), selector);
                personId = userInfo.getPerson().getId().toString();
                if (personIdMap.containsKey(personId)) continue;
                personIdMap.put(personId, null);
                personCollection.add(userInfo.getPerson());
            }
        }
        catch (Exception e) {
            logger.error((Object)"getNewPersonByOtherUserRange failed", (Throwable)e);
        }
        return personCollection;
    }

    private PersonCollection getPersonByUserRange(Context ctx, UserRangeEntryCollection userCollection) throws BOSException {
        HashMap personIdMap = new HashMap();
        PersonCollection personCollection = new PersonCollection();
        PersonInfo personInfo = null;
        UserInfo userInfo = null;
        IUser userInstance = UserFactory.getLocalInstance((Context)ctx);
        IPerson personInstance = PersonFactory.getLocalInstance((Context)ctx);
        String userId = null;
        String personId = null;
        try {
            for (int i = 0; i < userCollection.size(); ++i) {
                userId = userCollection.get(i).getUser().getId().toString();
                userInfo = userInstance.getUserInfo((IObjectPK)new ObjectUuidPK(userId));
                personId = userInfo.getPerson().getId().toString();
                if (personIdMap.containsKey(personId)) continue;
                personIdMap.put(personId, null);
                personInfo = personInstance.getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                personCollection.add(personInfo);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"getPersonByUserRange failed", (Throwable)e);
        }
        return personCollection;
    }

    private PersonCollection getPersonByOtherUserRange(Context ctx, otherUserRangeEntryCollection otheruserCollection) throws BOSException {
        HashMap personIdMap = new HashMap();
        PersonCollection personCollection = new PersonCollection();
        PersonInfo personInfo = null;
        UserInfo userInfo = null;
        IUser userInstance = UserFactory.getLocalInstance((Context)ctx);
        IPerson personInstance = PersonFactory.getLocalInstance((Context)ctx);
        String userId = null;
        String personId = null;
        try {
            for (int i = 0; i < otheruserCollection.size(); ++i) {
                userId = otheruserCollection.get(i).getUser().getId().toString();
                userInfo = userInstance.getUserInfo((IObjectPK)new ObjectUuidPK(userId));
                personId = userInfo.getPerson().getId().toString();
                if (personIdMap.containsKey(personId)) continue;
                personIdMap.put(personId, null);
                personInfo = personInstance.getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                personCollection.add(personInfo);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"getPersonByOtherUserRange failed", (Throwable)e);
        }
        return personCollection;
    }

    private String getOrgName(Context ctx, OrgRangeEntryInfo orgRangeInfo) throws BOSException {
        String orgName = null;
        FullOrgUnitInfo orgInfo = null;
        IFullOrgUnit orgInstance = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        try {
            orgInfo = orgInstance.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgRangeInfo.getOrg().getId().toString()));
            orgName = orgInfo.getName();
        }
        catch (EASBizException e) {
            logger.error((Object)"getOrgName failed", (Throwable)e);
        }
        return orgName;
    }

    @Override
    protected void _removeDelegate(Context ctx, List idList) throws BOSException, EASBizException {
        String id = null;
        ObjectUuidPK pk = null;
        JobDelegateInfo info = null;
        for (int i = 0; i < idList.size(); ++i) {
            id = (String)idList.get(i);
            pk = new ObjectUuidPK(id);
            info = (JobDelegateInfo)this.getValue(ctx, (IObjectPK)pk);
            if (!info.isReferrence()) continue;
            throw new JobDelegateException(JobDelegateException.CANNOTREMOVE);
        }
        IOrgRangeEntry orgInstance = OrgRangeEntryFactory.getLocalInstance(ctx);
        IProcRangeEntry procInstance = ProcRangeEntryFactory.getLocalInstance(ctx);
        IUserRangeEntry userInstance = UserRangeEntryFactory.getLocalInstance(ctx);
        for (int k = 0; k < idList.size(); ++k) {
            id = (String)idList.get(k);
            pk = new ObjectUuidPK(id);
            info = (JobDelegateInfo)this.getValue(ctx, (IObjectPK)pk);
            JobDelegateTansInfo tansInfo = JobDelegateAppUtil.getTansInfo(ctx, info);
            IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)ctx, (WorkflowLogItem)WorkflowLogItem.ENTRUST_DEL, (Object)(null == tansInfo ? "" : (null == tansInfo.getProcList() ? "" : tansInfo.getProcList().toString())));
            id = (String)idList.get(k);
            pk = new ObjectUuidPK(id);
            this.delete(ctx, (IObjectPK)pk);
            orgInstance.delete("where parent='" + id + "'");
            procInstance.delete("where parent='" + id + "'");
            procInstance.delete("where parent='" + id + "'");
            this.deleteConsigneeBillCondition(id, ctx);
            WorkflowLogUtil.endLogByLocal((Context)ctx, (IObjectPK)logPk);
        }
    }

    @Override
    protected void _updateJobDelegate(Context ctx, JobDelegateTansInfo delegateInfo) throws BOSException, EASBizException {
        int i;
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)ctx, (WorkflowLogItem)WorkflowLogItem.ENTRUST_UPDATE, (Object)(null == delegateInfo.getProcList() ? "" : delegateInfo.getProcList().toString()));
        Timestamp startTime = new Timestamp(delegateInfo.getEffectDate().getTime());
        Timestamp endTime = new Timestamp(delegateInfo.getPlanInvalidDate().getTime());
        String endTimeStr = endTime.toString().substring(0, 19);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = dateFormat.parse(endTimeStr);
            endTime = new Timestamp(date.getTime());
        }
        catch (Exception e) {
            logger.error((Object)"_updateJobDelegate failed", (Throwable)e);
        }
        JobDelegateAppUtil.checkEntrustRelation(ctx, delegateInfo.getConsignor().getId().toString(), delegateInfo, startTime, endTime, true);
        List userList = delegateInfo.getUserList();
        List orgList = delegateInfo.getOrgList();
        List procList = delegateInfo.getProcList();
        List otherUserList = delegateInfo.getOtheruserList();
        boolean isOther = delegateInfo.isOther();
        UserInfo checkUserInfo2 = null;
        for (UserInfo checkUserInfo2 : userList) {
            JobDelegateAppUtil.checkclosedloop(ctx, delegateInfo.getConsignor().getId().toString(), checkUserInfo2.getId().toString(), startTime, endTime, delegateInfo.getProcList());
        }
        if (isOther) {
            for (UserInfo checkUserInfo2 : otherUserList) {
                JobDelegateAppUtil.checkclosedloop(ctx, ctx.getCaller().toString(), checkUserInfo2.getId().toString(), startTime, endTime, delegateInfo.getProcList());
            }
        }
        IUserRangeEntry userRangeInstance = UserRangeEntryFactory.getLocalInstance(ctx);
        IOrgRangeEntry orgRangeInstance = OrgRangeEntryFactory.getLocalInstance(ctx);
        IProcRangeEntry procRangeInstance = ProcRangeEntryFactory.getLocalInstance(ctx);
        IotherUserRangeEntry otherUserRange = otherUserRangeEntryFactory.getLocalInstance(ctx);
        JobDelegateInfo info = new JobDelegateInfo();
        UserRangeEntryCollection userRange = new UserRangeEntryCollection();
        OrgRangeEntryCollection orgRange = new OrgRangeEntryCollection();
        ProcRangeEntryCollection procRange = new ProcRangeEntryCollection();
        otherUserRangeEntryCollection otherUserCollection = new otherUserRangeEntryCollection();
        otherUserRangeEntryInfo otherUserRangeEntryInfo2 = null;
        String headId = delegateInfo.getId();
        ObjectUuidPK pk = new ObjectUuidPK(headId);
        info.setId(BOSUuid.read((String)headId));
        info.setAllOrg(delegateInfo.isAllOrg());
        info.setAllProc(delegateInfo.isAllProc());
        info.setOtherDelegate(delegateInfo.isOther());
        info.setMsgRemind(delegateInfo.isMsgRemind());
        info.setMailRemind(delegateInfo.isMailRemind());
        info.setSmsRemind(delegateInfo.isSmsRemind());
        info.setPlanInvalidDate(endTime);
        info.setEffectDate(new Timestamp(delegateInfo.getEffectDate().getTime()));
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setConsignor(delegateInfo.getConsignor());
        this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
        userRangeInstance.delete("where parent = '" + headId + "'");
        orgRangeInstance.delete("where parent = '" + headId + "'");
        procRangeInstance.delete("where parent = '" + headId + "'");
        otherUserRange.delete("where parent = '" + headId + "'");
        if (!delegateInfo.isAllOrg() && orgList != null) {
            List<Boolean> includeSubOrgs = delegateInfo.getIncludeSubOrgs();
            for (int k = 0; k < orgList.size(); ++k) {
                OrgRangeEntryInfo orgEntryInfo = new OrgRangeEntryInfo();
                orgEntryInfo.setParent(info);
                orgEntryInfo.setReferrence(false);
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(((OrgUnitInfo)orgList.get(k)).getId());
                orgEntryInfo.setOrg(fullOrgUnitInfo);
                if (includeSubOrgs != null) {
                    orgEntryInfo.setIncludeSubOrg(includeSubOrgs.get(k));
                }
                orgRange.add(orgEntryInfo);
            }
        }
        if (!delegateInfo.isAllProc() && procList != null) {
            for (int j = 0; j < procList.size(); ++j) {
                ProcRangeEntryInfo procEntryInfo = new ProcRangeEntryInfo();
                procEntryInfo.setParent(info);
                procEntryInfo.setReferrence(false);
                procEntryInfo.setProcDefId(((ProcSelectedInfo)procList.get(j)).getProcDefId());
                procEntryInfo.setProcName(((ProcSelectedInfo)procList.get(j)).getName());
                procRange.add(procEntryInfo);
            }
        }
        for (i = 0; i < userList.size(); ++i) {
            UserRangeEntryInfo userEntryInfo = new UserRangeEntryInfo();
            userEntryInfo.setParent(info);
            userEntryInfo.setReferrence(false);
            userEntryInfo.setUser((UserInfo)userList.get(i));
            userRange.add(userEntryInfo);
        }
        userRangeInstance.addCollection(userRange);
        orgRangeInstance.addCollection(orgRange);
        procRangeInstance.addCollection(procRange);
        if (delegateInfo.isOther()) {
            if (otherUserList != null && otherUserList.size() > 0) {
                for (i = 0; i < otherUserList.size(); ++i) {
                    otherUserRangeEntryInfo2 = new otherUserRangeEntryInfo();
                    otherUserRangeEntryInfo2.setParent(info);
                    otherUserRangeEntryInfo2.setReferrence(false);
                    otherUserRangeEntryInfo2.setUser((UserInfo)otherUserList.get(i));
                    otherUserCollection.add(otherUserRangeEntryInfo2);
                }
                otherUserRange.addCollection(otherUserCollection);
            }
        } else {
            otherUserRange.delete("where parent = '" + headId + "'");
        }
        this.deleteConsigneeBillCondition(delegateInfo.getId(), ctx);
        this.addConsigneeBillCondition(delegateInfo, ctx);
        WorkflowLogUtil.endLogByLocal((Context)ctx, (IObjectPK)logPk);
    }

    @Override
    protected List _getAcceptDelegateList(Context ctx) throws BOSException {
        List returnList = new LinkedList();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select o.FID from ( select a.FID, a.FEffectDate, a.FOtherDelegate from T_MC_JobDelegate a, T_MC_UserRangeEntry b where ");
        sqlBuffer.append("b.FParentID = a.FID and b.FUserID = ? union ");
        sqlBuffer.append("select a.FID, a.FEffectDate, a.FOtherDelegate from T_MC_JobDelegate a, T_MC_OtherUserRangeEntry c where ");
        sqlBuffer.append("c.FParentID = a.FID and c.FUserID = ?) as o ");
        sqlBuffer.append("order by o.FOtherDelegate desc, o.FEffectDate");
        String currUser = ctx.getCaller().toString();
        Object[] params = new Object[]{currUser, currUser};
        String sql = sqlBuffer.toString();
        IRowSet delegateRs = null;
        try {
            delegateRs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        }
        catch (BOSException e) {
            logger.error((Object)"getAcceptDelegateList\uff08\u83b7\u53d6\u7528\u6237\u53d7\u6258\u8bb0\u5f55\u96c6\uff09\u65f6\u51fa\u9519", (Throwable)e);
        }
        returnList = this.getSqlResult(ctx, delegateRs);
        return returnList;
    }

    private String getConsignorName(Context ctx, JobDelegateInfo jobDelegateInfo) throws BOSException {
        String consignorName = null;
        UserInfo userInfo = null;
        IUser userInstance = UserFactory.getLocalInstance((Context)ctx);
        try {
            userInfo = userInstance.getUserInfo((IObjectPK)new ObjectUuidPK(jobDelegateInfo.getConsignor().getId().toString()));
            consignorName = userInfo.getName();
        }
        catch (Exception e) {
            logger.error((Object)"getConsignorName failed", (Throwable)e);
        }
        return consignorName;
    }

    private List getSqlResult(Context ctx, IRowSet delegateRs) throws BOSException {
        LinkedList returnList = new LinkedList();
        String headID = null;
        String allOrgText = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateResource", (String)"allOrg", (Locale)ctx.getLocale());
        String allProcText = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateResource", (String)"allProc", (Locale)ctx.getLocale());
        String noOtherPerson = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateResource", (String)"emptyPerson", (Locale)ctx.getLocale());
        StringBuffer bf = new StringBuffer();
        try {
            if (delegateRs != null) {
                while (delegateRs.next()) {
                    headID = delegateRs.getString("FID");
                    bf.append(headID);
                    bf.append(",");
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u5728\u6784\u9020JobDelegateAllInfo\u96c6\u5408\u65f6\u51fa\u9519", (Throwable)e);
        }
        String idList = "";
        if (bf.length() <= 0) {
            return returnList;
        }
        idList = bf.toString().substring(0, bf.length() - 1);
        IJobDelegate jobDalegate = JobDelegateFactory.getLocalInstance(ctx);
        IOrgRangeEntry orgRange = OrgRangeEntryFactory.getLocalInstance(ctx);
        IProcRangeEntry procRange = ProcRangeEntryFactory.getLocalInstance(ctx);
        IUserRangeEntry userRange = UserRangeEntryFactory.getLocalInstance(ctx);
        IotherUserRangeEntry otherUserRange = otherUserRangeEntryFactory.getLocalInstance(ctx);
        OrgRangeEntryCollection allorgCollection = null;
        ProcRangeEntryCollection allprocCollection = null;
        UserRangeEntryCollection alluserCollection = null;
        otherUserRangeEntryCollection allotherUserCollection = null;
        JobDelegateCollection alljobDelegateInfoColl = null;
        EntityViewInfo jobView = new EntityViewInfo();
        FilterInfo jobfilter = new FilterInfo();
        jobfilter.getFilterItems().add(new FilterItemInfo("id", (Object)idList, CompareType.INCLUDE));
        jobView.setFilter(jobfilter);
        alljobDelegateInfoColl = jobDalegate.getJobDelegateCollection(jobView);
        EntityViewInfo orcView = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("org.name"));
        selector.add(new SelectorItemInfo("parent.id"));
        selector.add(new SelectorItemInfo("parent"));
        orcView.getSelector().addObjectCollection((IObjectCollection)selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)idList, CompareType.INCLUDE));
        orcView.setFilter(filter);
        allorgCollection = orgRange.getCollection(orcView);
        EntityViewInfo procView = new EntityViewInfo();
        SelectorItemCollection procselector = new SelectorItemCollection();
        procselector.add(new SelectorItemInfo("id"));
        procselector.add(new SelectorItemInfo("ProcName"));
        procselector.add(new SelectorItemInfo("parent.id"));
        procselector.add(new SelectorItemInfo("parent"));
        procView.getSelector().addObjectCollection((IObjectCollection)procselector);
        FilterInfo procfilter = new FilterInfo();
        procfilter.getFilterItems().add(new FilterItemInfo("parent", (Object)idList, CompareType.INCLUDE));
        procView.setFilter(procfilter);
        allprocCollection = procRange.getCollection(procView);
        EntityViewInfo userView = new EntityViewInfo();
        SelectorItemCollection userselector = new SelectorItemCollection();
        userselector.add(new SelectorItemInfo("id"));
        userselector.add(new SelectorItemInfo("user.id"));
        userselector.add(new SelectorItemInfo("user.person.id"));
        userselector.add(new SelectorItemInfo("user.person.name"));
        userselector.add(new SelectorItemInfo("parent.id"));
        userselector.add(new SelectorItemInfo("parent"));
        userView.getSelector().addObjectCollection((IObjectCollection)userselector);
        FilterInfo userfilter = new FilterInfo();
        userfilter.getFilterItems().add(new FilterItemInfo("parent", (Object)idList, CompareType.INCLUDE));
        userView.setFilter(userfilter);
        alluserCollection = userRange.getCollection(userView);
        EntityViewInfo otheruserView = new EntityViewInfo();
        SelectorItemCollection otheruserselector = new SelectorItemCollection();
        otheruserselector.add(new SelectorItemInfo("id"));
        otheruserselector.add(new SelectorItemInfo("user.id"));
        otheruserselector.add(new SelectorItemInfo("user.person.id"));
        otheruserselector.add(new SelectorItemInfo("user.person.name"));
        otheruserselector.add(new SelectorItemInfo("parent.id"));
        otheruserselector.add(new SelectorItemInfo("parent"));
        otheruserView.getSelector().addObjectCollection((IObjectCollection)otheruserselector);
        FilterInfo otheruserfilter = new FilterInfo();
        otheruserfilter.getFilterItems().add(new FilterItemInfo("parent", (Object)idList, CompareType.INCLUDE));
        otheruserView.setFilter(otheruserfilter);
        allotherUserCollection = otherUserRange.getCollection(otheruserView);
        HashMap<JobDelegateInfo, JobDelegateAllInfo> headMap = new HashMap<JobDelegateInfo, JobDelegateAllInfo>();
        String[] idArray = idList.split(",");
        OrgRangeEntryCollection orgtmpCollection = null;
        ProcRangeEntryCollection proctmpCollection = null;
        UserRangeEntryCollection usertmpCollection = null;
        otherUserRangeEntryCollection othertmpUserCollection = null;
        JobDelegateInfo jobtmpDelegateInfo = null;
        JobDelegateAllInfo allInfo = null;
        for (int i = 0; i < idArray.length; ++i) {
            orgtmpCollection = new OrgRangeEntryCollection();
            proctmpCollection = new ProcRangeEntryCollection();
            usertmpCollection = new UserRangeEntryCollection();
            othertmpUserCollection = new otherUserRangeEntryCollection();
            String id = idArray[i];
            allInfo = new JobDelegateAllInfo();
            int jobSize = alljobDelegateInfoColl.size();
            for (int jsize = 0; jsize < jobSize; ++jsize) {
                JobDelegateInfo info = alljobDelegateInfoColl.get(jsize);
                if (!info.getId().toString().equals(id)) continue;
                jobtmpDelegateInfo = info;
            }
            int size = allorgCollection.size();
            for (int j = 0; j < size; ++j) {
                OrgRangeEntryInfo orgInfo = allorgCollection.get(j);
                if (!orgInfo.getParent().getId().toString().equals(id)) continue;
                orgtmpCollection.add(orgInfo);
            }
            int procsize = allprocCollection.size();
            for (int j = 0; j < procsize; ++j) {
                ProcRangeEntryInfo procInfo = allprocCollection.get(j);
                if (!procInfo.getParent().getId().toString().equals(id)) continue;
                proctmpCollection.add(procInfo);
            }
            int usersize = alluserCollection.size();
            for (int j = 0; j < usersize; ++j) {
                UserRangeEntryInfo userInfo = alluserCollection.get(j);
                if (!userInfo.getParent().getId().toString().equals(id)) continue;
                usertmpCollection.add(userInfo);
            }
            int otherusersize = allotherUserCollection.size();
            for (int j = 0; j < otherusersize; ++j) {
                otherUserRangeEntryInfo otheruserInfo = allotherUserCollection.get(j);
                if (!otheruserInfo.getParent().getId().toString().equals(id)) continue;
                othertmpUserCollection.add(otheruserInfo);
            }
            allInfo.setOrgEntry(orgtmpCollection);
            allInfo.setOtherUserEntry(othertmpUserCollection);
            allInfo.setParentInfo(jobtmpDelegateInfo);
            allInfo.setProcEntry(proctmpCollection);
            allInfo.setUserEntry(usertmpCollection);
            headMap.put(jobtmpDelegateInfo, allInfo);
        }
        HashMap<String, Object> rowMap = null;
        String org = "";
        String proc = "";
        String person = "";
        String consignor = "";
        JobDelegateInfo jobDelegateInfo = null;
        OrgRangeEntryCollection orgCollection = null;
        ProcRangeEntryCollection procCollection = null;
        UserRangeEntryCollection userCollection = null;
        otherUserRangeEntryCollection otherUserCollection = null;
        PersonCollection personCollection = null;
        PersonCollection otherPersonCollection = null;
        OrgRangeEntryInfo orgRangeInfo = null;
        ProcRangeEntryInfo procRangeInfo = null;
        PersonInfo personInfo = null;
        Iterator it = headMap.keySet().iterator();
        JobDelegateAllInfo newAllInfo = null;
        while (it.hasNext()) {
            rowMap = new HashMap<String, Object>();
            jobDelegateInfo = (JobDelegateInfo)it.next();
            newAllInfo = (JobDelegateAllInfo)headMap.get(jobDelegateInfo);
            orgCollection = newAllInfo.getOrgEntry();
            procCollection = newAllInfo.getProcEntry();
            userCollection = newAllInfo.getUserEntry();
            otherUserCollection = newAllInfo.getOtherUserEntry();
            personCollection = this.getNewPersonByUserRange(ctx, userCollection);
            otherPersonCollection = this.getNewPersonByOtherUserRange(ctx, otherUserCollection);
            org = "";
            proc = "";
            person = "";
            consignor = "";
            if (jobDelegateInfo.isAllProc()) {
                proc = allProcText;
                if (jobDelegateInfo.isAllOrg()) {
                    org = allOrgText;
                } else {
                    for (int j = 0; j < orgCollection.size(); ++j) {
                        orgRangeInfo = orgCollection.get(j);
                        org = j == 0 ? org + orgRangeInfo.getOrg().getName() : org + ";" + orgRangeInfo.getOrg().getName();
                    }
                }
            } else {
                for (int k = 0; k < procCollection.size(); ++k) {
                    procRangeInfo = procCollection.get(k);
                    proc = k == 0 ? proc + procRangeInfo.getProcName() : proc + ";" + procRangeInfo.getProcName();
                }
                if (jobDelegateInfo.isAllOrg()) {
                    org = allOrgText;
                } else {
                    for (int j = 0; j < orgCollection.size(); ++j) {
                        orgRangeInfo = orgCollection.get(j);
                        org = j == 0 ? org + this.getOrgName(ctx, orgRangeInfo) : org + ";" + this.getOrgName(ctx, orgRangeInfo);
                    }
                }
            }
            for (int m = 0; m < personCollection.size(); ++m) {
                personInfo = personCollection.get(m);
                person = m == 0 ? person + personInfo.getName() : person + ";" + personInfo.getName();
            }
            String otherPerson = "";
            if (!jobDelegateInfo.isOtherDelegate()) {
                otherPerson = noOtherPerson;
            } else {
                for (int n = 0; n < otherPersonCollection.size(); ++n) {
                    personInfo = otherPersonCollection.get(n);
                    otherPerson = n == 0 ? otherPerson + personInfo.getName() : otherPerson + ";" + personInfo.getName();
                }
            }
            consignor = this.getConsignorName(ctx, jobDelegateInfo);
            rowMap.put("consignor", consignor);
            rowMap.put("id", jobDelegateInfo.getId().toString());
            rowMap.put("effectDate", jobDelegateInfo.getEffectDate());
            rowMap.put("invalidDate", jobDelegateInfo.getPlanInvalidDate());
            rowMap.put("isOther", new Boolean(jobDelegateInfo.isOtherDelegate()));
            rowMap.put("org", org);
            rowMap.put("proc", proc);
            rowMap.put("person", person);
            rowMap.put("otherPerson", otherPerson);
            rowMap.put("inUse", new Boolean(jobDelegateInfo.isInUse()));
            rowMap.put("referrence", new Boolean(jobDelegateInfo.isReferrence()));
            returnList.add(rowMap);
        }
        return returnList;
    }

    @Override
    protected List _getQueryDelegateList(Context ctx, String effectDate, String planInvalidDate, String orgId, String procId) throws BOSException {
        int i;
        List returnList = new LinkedList();
        StringBuffer sqlBuffer = new StringBuffer();
        String parentId = "";
        String parentId2 = "";
        ArrayList<String> array = new ArrayList<String>();
        OrgRangeEntryCollection orgCollection = null;
        ProcRangeEntryCollection procCollection = null;
        IOrgRangeEntry orgRange = OrgRangeEntryFactory.getLocalInstance(ctx);
        IProcRangeEntry procRange = ProcRangeEntryFactory.getLocalInstance(ctx);
        if (!StringUtils.isEmpty((String)orgId)) {
            orgCollection = orgRange.getCollection("where org='" + orgId + "'");
        }
        if (!StringUtils.isEmpty((String)procId)) {
            procCollection = procRange.getCollection("where procDefId ='" + procId + "'");
        }
        boolean orgNotEmpty = false;
        if (orgCollection != null && orgCollection.size() > 0) {
            orgNotEmpty = true;
            block2: for (i = 0; i < orgCollection.size(); ++i) {
                parentId = orgCollection.get(i).getParent().getId().toString();
                if (procCollection != null && procCollection.size() > 0) {
                    for (int j = 0; j < procCollection.size(); ++j) {
                        parentId2 = procCollection.get(j).getParent().getId().toString();
                        if (!parentId.equals(parentId2)) continue;
                        array.add(parentId);
                        continue block2;
                    }
                    continue;
                }
                array.add(parentId);
            }
        } else if (procCollection != null && procCollection.size() > 0) {
            for (int j = 0; j < procCollection.size(); ++j) {
                parentId = procCollection.get(j).getParent().getId().toString();
                array.add(parentId);
            }
        } else if (!StringUtils.isEmpty((String)orgId) || !StringUtils.isEmpty((String)procId)) {
            return returnList;
        }
        if (procCollection != null && procCollection.size() > 0 && orgNotEmpty && array.size() <= 0) {
            return returnList;
        }
        sqlBuffer.append("select o.FID from ( select a.FID, a.FEffectDate, a.FPlanInvalidDate, a.FOtherDelegate from T_MC_JobDelegate a, T_MC_UserRangeEntry b where ");
        sqlBuffer.append("b.FParentID = a.FID and b.FUserID ='" + ctx.getCaller().toString() + "' union ");
        sqlBuffer.append("select a.FID, a.FEffectDate, a.FPlanInvalidDate, a.FOtherDelegate from T_MC_JobDelegate a, T_MC_OtherUserRangeEntry c where ");
        sqlBuffer.append("c.FParentID = a.FID and c.FUserID ='" + ctx.getCaller().toString() + "') as o ");
        if (array.size() > 0 || !StringUtils.isEmpty((String)effectDate) || !StringUtils.isEmpty((String)planInvalidDate)) {
            sqlBuffer.append("where");
        }
        if (array.size() > 0) {
            sqlBuffer.append("  o.fid in(");
            for (i = 0; i < array.size(); ++i) {
                String uid = array.get(i).toString();
                if (i == 0) {
                    sqlBuffer.append("'");
                    sqlBuffer.append(uid);
                    sqlBuffer.append("'");
                    continue;
                }
                sqlBuffer.append(",'");
                sqlBuffer.append(uid);
                sqlBuffer.append("'");
            }
            sqlBuffer.append(")");
            if (!StringUtils.isEmpty((String)effectDate) || !StringUtils.isEmpty((String)planInvalidDate)) {
                sqlBuffer.append(" and");
            }
        }
        if (!StringUtils.isEmpty((String)effectDate)) {
            String newEffectDate = "";
            newEffectDate = "{ts'" + effectDate + " '}";
            sqlBuffer.append(" o.FEffectDate >=").append(newEffectDate);
            if (!StringUtils.isEmpty((String)planInvalidDate)) {
                sqlBuffer.append(" and");
            }
        }
        if (!StringUtils.isEmpty((String)planInvalidDate)) {
            String newPlanInvalidDate = "";
            newPlanInvalidDate = "{ts'" + planInvalidDate + " '}";
            sqlBuffer.append(" o.FPlanInvalidDate<=").append(newPlanInvalidDate);
        }
        sqlBuffer.append(" order by o.FOtherDelegate desc, o.FEffectDate");
        String sql = sqlBuffer.toString();
        IRowSet delegateRs = null;
        try {
            delegateRs = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            logger.error((Object)"getQueryDelegateList\uff08\u67e5\u8be2\u7528\u6237\u53d7\u6258\u8bb0\u5f55\u96c6\uff09\u65f6\u51fa\u9519", (Throwable)e);
        }
        returnList = this.getSqlResult(ctx, delegateRs);
        return returnList;
    }

    @Override
    protected HashMap _updateNewJobDelegate(Context ctx, JobDelegateTansInfo delegateInfo, String emailAddress, String phoneNumber) throws BOSException, EASBizException {
        HashMap sendResult = new HashMap();
        this._updateJobDelegate(ctx, delegateInfo);
        IJobDelegateManagerFacade delegateManager = JobDelegateManagerFacadeFactory.getLocalInstance(ctx);
        sendResult = delegateManager.sendMessage(delegateInfo, emailAddress, phoneNumber);
        return sendResult;
    }

    @Override
    protected HashMap _getProcessNew(Context ctx, String[] orgType, String packageName, String[] searchParam) throws BOSException {
        String searchText;
        IRowSet rowSet = null;
        HashMap<String, ProcSelectedInfo> map = new HashMap<String, ProcSelectedInfo>();
        String strName = "FNAME_" + ctx.getLocale().toString();
        String strDesc = "FDESC_" + ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select a.FPROCDEFID,a.FProcCode,a.").append(strName);
        sql.append(",a.").append(strDesc);
        sql.append(" from T_WFR_PROCDEF a ");
        sql.append(" where  a.FENABLE = 1 ");
        sql.append(" and  a.FINNERVERSION =(select max(c.FINNERVERSION)");
        sql.append(" from T_WFR_PROCDEF c  where c.FPROCDEFID = a.FPROCDEFID) ");
        sql.append(" and (a.FPROCDEFTYPE = 'NORMAL' or a.FPROCDEFTYPE = 'MICRO') ");
        ArrayList<String> params = new ArrayList<String>();
        if (searchParam != null && searchParam.length >= 3 && !StringUtils.isEmpty((String)(searchText = searchParam[0]))) {
            String searchType = searchParam[1];
            String isMoHu = searchParam[2];
            if (searchType.equals("0")) {
                if (Boolean.valueOf(isMoHu).booleanValue()) {
                    sql.append(" and a.FProcCode like ? ");
                    params.add("%" + searchText + "%");
                } else {
                    sql.append(" and a.FProcCode = ?");
                    params.add(searchText);
                }
            } else if (Boolean.valueOf(isMoHu).booleanValue()) {
                sql.append(" and ").append(strName).append(" like ? ");
                params.add("%" + searchText + "%");
            } else {
                sql.append(" and ").append(strName).append(" = ? ");
                params.add(searchText);
            }
        }
        if (!StringUtils.isEmpty((String)packageName)) {
            sql.append(" and (a.FPackageName=? or a.FPackageName like ?)");
            params.add(packageName);
            params.add("%" + packageName + "%");
        }
        sql.append(" ORDER BY a.FCREATEDTIME DESC");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        BOSObjectType[] billType = null;
        EntityObjectInfo entity = null;
        String orgTypeAlias = null;
        ProcSelectedInfo procInfo = null;
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        try {
            if (orgType != null && orgType.length > 0) {
                IRowSet copyRowSet = null;
                copyRowSet = rowSet.createCopy();
                ArrayList<String> procList = new ArrayList<String>();
                while (copyRowSet.next()) {
                    procList.add(copyRowSet.getString("FPROCDEFID"));
                }
                int size = procList.size();
                String[] proc = new String[size];
                for (int i = 0; i < size; ++i) {
                    proc[i] = (String)procList.get(i);
                }
                List list = service.getRelatedEntityTypes(proc);
                HashMap hash = new HashMap();
                if (list != null && list.size() > 0) {
                    int k = list.size();
                    for (int i = 0; i < k; ++i) {
                        hash.put(procList.get(i), (BOSObjectType[])list.get(i));
                    }
                }
                for (int i = 0; i <= orgType.length - 1; ++i) {
                    String[] org = null;
                    if (orgType[i] == null) {
                        return map;
                    }
                    org = orgType[i].split("\\.");
                    copyRowSet = rowSet.createCopy();
                    while (copyRowSet.next()) {
                        String procId = copyRowSet.getString("FPROCDEFID");
                        billType = (BOSObjectType[])hash.get(procId);
                        if (billType != null && billType.length > 0) {
                            entity = metaDataLoader.getEntity(billType[0]);
                            orgTypeAlias = entity.getExtendedProperty("OrgType");
                        }
                        if (StringUtils.isEmpty(orgTypeAlias) || !this.stringInArray(orgTypeAlias, org) || map.get(copyRowSet.getString("FPROCDEFID")) != null) continue;
                        procInfo = new ProcSelectedInfo();
                        procInfo.setProcDefId(copyRowSet.getString("FPROCDEFID"));
                        procInfo.setProcCode(copyRowSet.getString("FProcCode"));
                        procInfo.setDescription(copyRowSet.getString(strDesc));
                        procInfo.setName(copyRowSet.getString(strName));
                        map.put(copyRowSet.getString("FPROCDEFID"), procInfo);
                    }
                }
            } else if (orgType != null && orgType.length == 0) {
                while (rowSet.next()) {
                    procInfo = new ProcSelectedInfo();
                    procInfo.setProcDefId(rowSet.getString("FPROCDEFID"));
                    procInfo.setProcCode(rowSet.getString("FProcCode"));
                    procInfo.setDescription(rowSet.getString(strDesc));
                    procInfo.setName(rowSet.getString(strName));
                    map.put(rowSet.getString("FPROCDEFID"), procInfo);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_getProcessNew failed", (Throwable)e);
        }
        return map;
    }
}

