/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.cp.common.web.util.ValueListDAO;
import com.kingdee.eas.cp.common.web.util.ValueListHandler;
import com.kingdee.eas.cp.eip.mc.BizPackageMapFactory;
import com.kingdee.eas.cp.eip.mc.IBizPackageMap;
import com.kingdee.eas.cp.eip.mc.web.MessageHander;
import com.kingdee.eas.cp.eip.mc.web.MsgType;
import com.kingdee.eas.cp.eip.mc.web.dao.AssignDetailMessageDAOImpl;
import com.kingdee.eas.cp.eip.mc.web.dao.AssignHstMessageDAOImpl;
import com.kingdee.eas.cp.eip.mc.web.dao.AssignMessageDAOImpl;
import com.kingdee.eas.cp.eip.mc.web.dao.CombineAssignMessageDAOImpl;
import com.kingdee.eas.cp.eip.mc.web.dao.CustomNodeMessageDAO;
import com.kingdee.eas.cp.eip.mc.web.dao.CustomNodeMessageDaoImpl;
import com.kingdee.eas.cp.eip.mc.web.dao.MessageDAOImpl;
import com.kingdee.eas.cp.eip.mc.web.dao.OfficeMessageDAOImpl;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MessageCenterService {
    private static final int unDisposedTaskPageSize = 500;
    private static Logger logger = Logger.getLogger((String)MessageCenterService.class.getName());

    public MessageHander queryMessage(Context context, MsgType msgType, int pageNo, int pageSize, String orderByField, String orderType) throws Exception {
        if (!StringUtils.isEmpty((String)msgType.getCustomNodeID())) {
            return this.queryCustomNodeMessage(context, msgType, pageNo, pageSize, orderByField, orderType);
        }
        return this.queryCommonMessage(context, msgType, pageNo, pageSize, orderByField, orderType);
    }

    public MessageHander queryCommonMessage(Context context, MsgType msgType, int pageNo, int pageSize, String orderByField, String orderType) throws Exception {
        logger.debug((Object)"\u5f00\u59cb\u8c03\u7528DAO\u65b9\u6cd5\u67e5\u8be2\u6d88\u606f\u4e2d\u5fc3\u7684\u6d88\u606f");
        logger.debug((Object)("user Contect is:" + context.toString()));
        ValueListDAO listDAO = this.getImpl(context, msgType);
        ValueListHandler valueListHandler = new ValueListHandler(listDAO);
        if (msgType.getNodeType() == 1 && "true".equals(msgType.getIfCombine())) {
            valueListHandler.setPageSize(500);
        } else {
            valueListHandler.setPageSize(pageSize);
        }
        valueListHandler.setOrderByField(orderByField);
        valueListHandler.setOrderType(orderType);
        valueListHandler.absolute(pageNo);
        MessageHander hander = new MessageHander();
        hander.setMsgList(valueListHandler.getValueList());
        hander.setMsgCount(valueListHandler.getRecordsCount());
        hander.setPageSize(valueListHandler.getPageSize());
        return hander;
    }

    public MessageHander queryCustomNodeMessage(Context context, MsgType msgType, int pageNo, int pageSize, String orderByField, String orderType) throws Exception {
        logger.debug((Object)"\u5f00\u59cb\u8c03\u7528\u81ea\u5b9a\u4e49\u8282\u70b9DAO\u65b9\u6cd5\u67e5\u8be2\u6d88\u606f\u4e2d\u5fc3\u7684\u6d88\u606f");
        logger.debug((Object)("user Contect is:" + context.toString()));
        CustomNodeMessageDAO msgDao = this.getCutomImpl(context, msgType);
        if (msgType.getNodeType() == 1 && "true".equals(msgType.getIfCombine())) {
            pageSize = 500;
        }
        MessageHander hander = msgDao.getMsghander(pageNo, pageSize, orderByField, orderType);
        hander.setPageSize(pageSize);
        return hander;
    }

    public ArrayList getMsgBizPackageTypes(Context context) throws Exception {
        ArrayList list = new ArrayList();
        IBizPackageMap bizPackageMap = BizPackageMapFactory.getLocalInstance(context);
        list = bizPackageMap.getMsgBizPackageTypes();
        return list;
    }

    private ValueListDAO getImpl(Context context, MsgType msgType) throws Exception {
        if (msgType.getNodeType() == 1) {
            if ("true".equals(msgType.getIfCombine())) {
                return new CombineAssignMessageDAOImpl(context, msgType);
            }
            return new AssignMessageDAOImpl(context, msgType);
        }
        if (msgType.getNodeType() == 2) {
            if ("true".equals(msgType.getIfHistory())) {
                return new AssignHstMessageDAOImpl(context, msgType);
            }
            return new AssignDetailMessageDAOImpl(context, msgType);
        }
        if (msgType.getNodeType() == 3) {
            return new MessageDAOImpl(context, msgType);
        }
        if (msgType.getNodeType() == 4) {
            boolean isHst = new Boolean(msgType.getIfHistory());
            return new OfficeMessageDAOImpl(context, msgType, isHst);
        }
        return new MessageDAOImpl(context, msgType);
    }

    private CustomNodeMessageDAO getCutomImpl(Context context, MsgType msgType) throws Exception {
        return new CustomNodeMessageDaoImpl(context, msgType);
    }

    public static void readOfficeMsg(Context ctx, String msgID) {
        String sql = "update T_BAS_Messageyr set FStatus = 10 where FID= ?";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{msgID});
        }
        catch (BOSException e) {
            logger.error((Object)"\u9605\u8bfb\u6021\u8f6f\u6d88\u606f\u62a5\u9519", (Throwable)e);
        }
    }
}

