/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.mc.DatePlanEntryException;
import com.kingdee.eas.cp.mc.DatePlanEventEntryCollection;
import com.kingdee.eas.cp.mc.DatePlanEventEntryFactory;
import com.kingdee.eas.cp.mc.DatePlanEventEntryInfo;
import com.kingdee.eas.cp.mc.DatePlanEventFacadeFactory;
import com.kingdee.eas.cp.mc.IDatePlanEventEntry;
import com.kingdee.eas.cp.mc.IDatePlanEventFacade;
import com.kingdee.eas.cp.mc.web.DatePlanEntryForm;
import com.kingdee.eas.cp.mc.web.ManageCommunicateUtil;
import com.kingdee.eas.portal.web.action.PortletDispatchAction;
import com.kingdee.eas.util.EASCommonResource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class DatePlanEntryAction
extends PortletDispatchAction {
    private static final String RESOURCE = "com.kingdee.eas.cp.mc.ManageCommunicateResource";
    private static final Logger logger = Logger.getLogger((String)DatePlanEntryAction.class.getName());

    public ActionForward addAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        DatePlanEntryForm datePlanEntryForm = (DatePlanEntryForm)form;
        if (datePlanEntryForm.getParent() == null) {
            String msg = new DatePlanEntryException(DatePlanEntryException.IDNOTNULL).getMessage(ctx.getLocale());
            HttpSession session = request.getSession(true);
            session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            request.setAttribute("datePlanEntryForm", (Object)datePlanEntryForm);
            return mapping.findForward("edit");
        }
        datePlanEntryForm.setAvoke(false);
        Date nowTime = new Date(System.currentTimeMillis());
        SimpleDateFormat now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        datePlanEntryForm.setStarttime(now.format(nowTime));
        datePlanEntryForm.setEndtime(now.format(nowTime));
        datePlanEntryForm.setTopic("");
        datePlanEntryForm.setPersonIDList("");
        datePlanEntryForm.setPersonNameList("");
        datePlanEntryForm.setReason("");
        datePlanEntryForm.setIsToTimeAvoke(false);
        datePlanEntryForm.setIsToTimeMobileAvoke(false);
        datePlanEntryForm.setTimeAvoke(5);
        datePlanEntryForm.setOprtStat(0);
        request.setAttribute("datePlanEntryForm", (Object)datePlanEntryForm);
        return mapping.findForward("edit");
    }

    public ActionForward deleteAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        Locale locale = ctx != null ? ctx.getLocale() : null;
        DatePlanEntryForm datePlanEntryForm = (DatePlanEntryForm)form;
        if (datePlanEntryForm.getUuid() == null) {
            String msg = new DatePlanEntryException(DatePlanEntryException.IDNOTNULL).getMessage(ctx.getLocale());
            HttpSession session = request.getSession(true);
            session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            if (datePlanEntryForm.getSource().trim().equalsIgnoreCase("list")) {
                return this.queryAction(mapping, datePlanEntryForm, request, response);
            }
            return mapping.findForward("edit");
        }
        try {
            IDatePlanEventEntry iEntry = DatePlanEventEntryFactory.getLocalInstance(ctx);
            iEntry.delete("where uuid='" + datePlanEntryForm.getUuid() + "'");
        }
        catch (EASBizException e) {
            logger.info((Object)("\u5220\u9664\u5931\u8d25" + e.getMessage()));
            String msg = e.getMessage();
            HttpSession session = request.getSession(true);
            session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            if (datePlanEntryForm.getSource().trim().equalsIgnoreCase("list")) {
                return this.queryAction(mapping, datePlanEntryForm, request, response);
            }
            return mapping.findForward("edit");
        }
        catch (Exception e) {
            logger.info((Object)("\u5220\u9664\u5931\u8d25" + e.getMessage()));
            String msg = EASCommonResource.getString((String)RESOURCE, (String)"deleteDateFail", (Locale)locale);
            HttpSession session = request.getSession(true);
            session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            if (datePlanEntryForm.getSource().trim().equalsIgnoreCase("list")) {
                return this.queryAction(mapping, datePlanEntryForm, request, response);
            }
            return mapping.findForward("edit");
        }
        String msg = EASCommonResource.getString((String)RESOURCE, (String)"delete.success", (Locale)locale);
        HttpSession session = request.getSession(true);
        session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
        if (datePlanEntryForm.getSource().trim().equalsIgnoreCase("list")) {
            return this.queryAction(mapping, datePlanEntryForm, request, response);
        }
        return this.addAction(mapping, form, request, response);
    }

    public ActionForward updateAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        DatePlanEntryForm datePlanEntryForm = (DatePlanEntryForm)form;
        if (datePlanEntryForm.getUuid() == null || datePlanEntryForm.getParent() == null) {
            String msg = new DatePlanEntryException(DatePlanEntryException.IDNOTNULL).getMessage(ctx.getLocale());
            HttpSession session = request.getSession(true);
            session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            request.setAttribute("datePlanEntryForm", (Object)datePlanEntryForm);
            return mapping.findForward("edit");
        }
        try {
            IDatePlanEventEntry iEntry = DatePlanEventEntryFactory.getLocalInstance(ctx);
            DatePlanEventEntryCollection entryCollection = iEntry.getDatePlanEventEntryCollection("where uuid='" + datePlanEntryForm.getUuid() + "'");
            int length = entryCollection.size();
            if (length < 1) {
                String msg = new DatePlanEntryException(DatePlanEntryException.IDNOTNULL).getMessage(ctx.getLocale());
                HttpSession session = request.getSession(true);
                session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
                request.setAttribute("datePlanEntryForm", (Object)datePlanEntryForm);
                return mapping.findForward("edit");
            }
            String personIdList = null;
            String personNameList = null;
            PersonInfo personInfo = null;
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < length; ++i) {
                DatePlanEventEntryInfo info = entryCollection.get(i);
                if (i == 0) {
                    datePlanEntryForm.setAvoke(info.isIsAvoke());
                    datePlanEntryForm.setStarttime(info.getBeginTime().toString());
                    datePlanEntryForm.setEndtime(info.getEndTime().toString());
                    datePlanEntryForm.setTopic(info.getTopic());
                    if (info.getPerson() != null) {
                        personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
                        personIdList = personInfo.getId().toString();
                        personNameList = personInfo.getName();
                    }
                    datePlanEntryForm.setReason(info.getEvent());
                    datePlanEntryForm.setIsToTimeAvoke(info.isIsToTimeAvoke());
                    datePlanEntryForm.setIsToTimeMobileAvoke(info.isIsMobileAvoke());
                    datePlanEntryForm.setTimeAvoke(info.getTimeAvoke());
                    datePlanEntryForm.setOprtStat(2);
                    continue;
                }
                if (info.getPerson() == null) continue;
                personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
                personIdList = personIdList + "," + personInfo.getId().toString();
                personNameList = personNameList + "," + personInfo.getName();
            }
            datePlanEntryForm.setPersonNameList(personNameList);
            datePlanEntryForm.setPersonIDList(personIdList);
        }
        catch (EASBizException e) {
            String msg = e.getMessage();
            HttpSession session = request.getSession(true);
            session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            request.setAttribute("datePlanEntryForm", (Object)datePlanEntryForm);
            return mapping.findForward("edit");
        }
        catch (Exception e) {
            String msg = e.getMessage();
            HttpSession session = request.getSession(true);
            session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            request.setAttribute("datePlanEntryForm", (Object)datePlanEntryForm);
            return mapping.findForward("edit");
        }
        request.setAttribute("datePlanEntryForm", (Object)datePlanEntryForm);
        return mapping.findForward("edit");
    }

    public ActionForward saveAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        Locale locale = ctx != null ? ctx.getLocale() : null;
        DatePlanEntryForm datePlanEntryForm = (DatePlanEntryForm)form;
        String uuid = null;
        try {
            IDatePlanEventEntry iEntry = DatePlanEventEntryFactory.getLocalInstance(ctx);
            uuid = datePlanEntryForm.getUuid();
            String starttime = datePlanEntryForm.getStarttime();
            String endtime = datePlanEntryForm.getEndtime();
            int timeAvoke = datePlanEntryForm.getTimeAvoke();
            boolean isToTimeMobileAvoke = datePlanEntryForm.getIsToTimeMobileAvoke();
            boolean isToTimeAvoke = datePlanEntryForm.getIsToTimeAvoke();
            String reason = datePlanEntryForm.getReason();
            String parent = datePlanEntryForm.getParent();
            String personIdList = datePlanEntryForm.getPersonIDList();
            String topic = datePlanEntryForm.getTopic();
            uuid = iEntry.saveBatch(personIdList, uuid, starttime, endtime, timeAvoke, isToTimeMobileAvoke, isToTimeAvoke, reason, parent, topic);
        }
        catch (EASBizException e) {
            logger.info((Object)"\u4fdd\u5b58\u5931\u8d25", e.getCause());
            String msg = e.getMessage();
            HttpSession session = request.getSession(true);
            session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            return mapping.findForward("edit");
        }
        catch (Exception e) {
            logger.info((Object)"\u4fdd\u5b58\u5931\u8d25", e.getCause());
            String msg = EASCommonResource.getString((String)RESOURCE, (String)"save.fail", (Locale)locale);
            HttpSession session = request.getSession(true);
            session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            return mapping.findForward("edit");
        }
        datePlanEntryForm.setUuid(uuid);
        datePlanEntryForm.setOprtStat(2);
        String msg = EASCommonResource.getString((String)RESOURCE, (String)"save.success", (Locale)locale);
        HttpSession session = request.getSession(true);
        session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
        request.setAttribute("datePlanEntryForm", (Object)datePlanEntryForm);
        return mapping.findForward("edit");
    }

    public ActionForward queryAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        Locale locale = ctx != null ? ctx.getLocale() : null;
        DatePlanEntryForm datePlanEntryForm = (DatePlanEntryForm)form;
        ArrayList list = new ArrayList();
        if (datePlanEntryForm.getParent() != null) {
            try {
                IDatePlanEventFacade iEntry = DatePlanEventFacadeFactory.getLocalInstance(ctx);
                list = iEntry.getDatePlanCooperateEntries(datePlanEntryForm.getParent(), null, null);
            }
            catch (Exception e) {
                logger.info((Object)("\u83b7\u53d6\u65e5\u7a0b\u4fe1\u606f\u5931\u8d25" + e.getMessage()));
                String msg = EASCommonResource.getString((String)RESOURCE, (String)"get.data.fail", (Locale)locale);
                HttpSession session = request.getSession(true);
                session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            }
        }
        String xmlData = ManageCommunicateUtil.makeProcDataToXMLData(list, 7);
        request.setAttribute("datePlanEvent.datePlanEntry.data", (Object)xmlData);
        request.setAttribute("datePlanEntryForm", (Object)datePlanEntryForm);
        return mapping.findForward("date");
    }

    public ActionForward viewAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        Locale locale = ctx != null ? ctx.getLocale() : null;
        DatePlanEntryForm datePlanEntryForm = (DatePlanEntryForm)form;
        if (datePlanEntryForm.getParent() == null && datePlanEntryForm.getUuid() == null) {
            String msg = new DatePlanEntryException(DatePlanEntryException.IDNOTNULL).getMessage(ctx.getLocale());
            HttpSession session = request.getSession(true);
            session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            return mapping.findForward("edit");
        }
        try {
            IDatePlanEventEntry iEntry = DatePlanEventEntryFactory.getLocalInstance(ctx);
            DatePlanEventEntryCollection entryCollection = iEntry.getDatePlanEventEntryCollection("where uuid ='" + datePlanEntryForm.getUuid() + "'");
            int size = entryCollection.size();
            if (size < 1) {
                String msg = new DatePlanEntryException(DatePlanEntryException.IDNOTNULL).getMessage(ctx.getLocale());
                HttpSession session = request.getSession(true);
                session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
                return mapping.findForward("edit");
            }
            String personIdList = null;
            String personNameList = null;
            PersonInfo personInfo = null;
            for (int i = 0; i < size; ++i) {
                DatePlanEventEntryInfo info = entryCollection.get(i);
                if (i == 0) {
                    datePlanEntryForm.setAvoke(info.isIsAvoke());
                    datePlanEntryForm.setStarttime(info.getBeginTime().toString());
                    datePlanEntryForm.setEndtime(info.getEndTime().toString());
                    datePlanEntryForm.setTopic(info.getTopic());
                    if (info.getPerson() != null) {
                        personIdList = info.getPerson().getId().toString();
                        personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
                        personNameList = personInfo.getName();
                    }
                    datePlanEntryForm.setReason(info.getEvent());
                    datePlanEntryForm.setIsToTimeAvoke(info.isIsToTimeAvoke());
                    datePlanEntryForm.setIsToTimeMobileAvoke(info.isIsMobileAvoke());
                    datePlanEntryForm.setTimeAvoke(info.getTimeAvoke());
                    if (datePlanEntryForm.getOprtStat() == 3) continue;
                    datePlanEntryForm.setOprtStat(4);
                    continue;
                }
                if (info.getPerson() == null) continue;
                personIdList = personIdList + "," + info.getPerson().getId().toString();
                personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
                personNameList = personNameList + "," + personInfo.getName();
            }
            datePlanEntryForm.setPersonIDList(personIdList);
            datePlanEntryForm.setPersonNameList(personNameList);
        }
        catch (EASBizException e) {
            logger.info((Object)("\u67e5\u770b\u65e5\u7a0b\u4fe1\u606f\u5931\u8d25" + e.getMessage()));
            String msg = e.getMessage();
            HttpSession session = request.getSession(true);
            session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            return mapping.findForward("edit");
        }
        catch (Exception e) {
            logger.info((Object)("\u67e5\u770b\u65e5\u7a0b\u4fe1\u606f\u5931\u8d25" + e.getMessage()));
            String msg = EASCommonResource.getString((String)RESOURCE, (String)"view.fail", (Locale)locale);
            HttpSession session = request.getSession(true);
            session.setAttribute("com.kingdee.eas.cp.mc.error.msg", (Object)msg);
            return mapping.findForward("edit");
        }
        request.setAttribute("datePlanEntryForm", (Object)form);
        return mapping.findForward("edit");
    }
}

