/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.cpmm.ArticlePoolCollection;
import com.kingdee.eas.cp.cpmm.ArticlePoolFactory;
import com.kingdee.eas.cp.cpmm.InventoryWarnningSettingCollection;
import com.kingdee.eas.cp.cpmm.InventoryWarnningSettingFactory;
import com.kingdee.eas.cp.cpmm.InventoryWarnningSettingInfo;
import com.kingdee.eas.cp.cpmm.app.AbstractArticlePoolControllerBean;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ArticlePoolControllerBean
extends AbstractArticlePoolControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.cpmm.app.ArticlePoolControllerBean");
    private String returnInformWay;

    protected void _sendMsgbyReturnDate(Context ctx) throws BOSException {
        super._sendMsgbyReturnDate(ctx);
        try {
            this.returnWarning(ctx);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private void returnWarning(Context ctx) throws BOSException, EASBizException {
        ArticlePoolCollection coll = this.getArticlePool(ctx);
        if (coll != null && coll.size() != 0) {
            this.notice(ctx);
        }
    }

    private ArticlePoolCollection getArticlePool(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(0), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("applicant.*"));
        sic.add(new SelectorItemInfo("materialsRecord.*"));
        view.setSelector(sic);
        ArticlePoolCollection coll = ArticlePoolFactory.getLocalInstance(ctx).getArticlePoolCollection(view);
        return coll;
    }

    private void notice(Context ctx) throws BOSException, EASBizException {
        InventoryWarnningSettingCollection informWayColl = InventoryWarnningSettingFactory.getLocalInstance(ctx).getInventoryWarnningSettingCollection();
        InventoryWarnningSettingInfo informModel = null;
        if (informWayColl != null && informWayColl.size() == 1) {
            informModel = informWayColl.get(0);
            this.returnInformWay = informModel.getReturnInformWay();
        }
        if (this.returnInformWay != null && !this.returnInformWay.trim().equals("")) {
            try {
                this.returnWarningInformWay(ctx, this.returnInformWay);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void returnWarningInformWay(Context ctx, String returnInformWay) throws BOSException, EASBizException {
        char[] returnInformWayArr = returnInformWay.toCharArray();
        if (returnInformWayArr[0] == '1') {
            this.returnSendSmSToPersons(ctx);
        }
        if (returnInformWayArr[1] == '1') {
            this.returnSendMsgToUsers(ctx);
        }
        if (returnInformWayArr[2] == '1') {
            this.returnSendMailToPersons(ctx);
        }
    }

    private void returnSendMsgToUsers(Context ctx) throws BOSException {
        ArticlePoolCollection apColl = this.getArticlePool(ctx);
        if (apColl != null && apColl.size() > 0) {
            String billNumber = null;
            String materialName = null;
            Date returnDate = null;
            String senderName = null;
            PersonInfo pInfo = null;
            int days = 0;
            int n = apColl.size();
            for (int i = 0; i < n; ++i) {
                if (apColl.get(i).getReturnDate() == null || (days = (int)(this.formateDate(returnDate = apColl.get(i).getReturnDate()).getTime() - this.formateDate(Calendar.getInstance().getTime()).getTime()) / 86400000) > 3) continue;
                String msgBodyStr = null;
                String msgTitleStr = null;
                pInfo = new PersonInfo();
                materialName = apColl.get(i).getMaterialsRecord().getName();
                billNumber = apColl.get(i).getNumber();
                pInfo = apColl.get(i).getApplicant();
                senderName = apColl.get(i).getApplicant().getName();
                List idList = ArticlePoolControllerBean.getUserIdList(ctx, pInfo);
                Locale locale = SysContext.getSysContext().getLocale();
                msgTitleStr = msgBodyStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.cp.cpmm.CPMMResource", (String)"RETURN_MSG", (Locale)locale), billNumber, materialName);
                ArticlePoolControllerBean.sendMessage(ctx, idList, msgTitleStr, senderName, msgBodyStr);
            }
        }
    }

    public static List getUserIdList(Context ctx, PersonInfo pInfo) throws BOSException {
        ArrayList<String> userIdList = new ArrayList<String>();
        String pId = pInfo.getId().toString();
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pId, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        UserCollection uc = iuser.getUserCollection(evi);
        if (uc.size() != 0) {
            for (int i = 0; i < uc.size(); ++i) {
                String userId = uc.get(i).getId().toString();
                if (userId == null) continue;
                userIdList.add(userId);
            }
        }
        return userIdList;
    }

    public static void sendMessage(Context ctx, List idList, String titleStr, String senderName, String bodyStr) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = ArticlePoolControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        String userId = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 20);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", titleStr, locale2);
            message.setLocaleStringHeader("sender", senderName, locale2);
            message.setLocaleStringHeader("body", bodyStr, locale2);
        }
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            userId = (String)idList.get(i);
            message.setStringHeader("receiver", userId);
            senderAgent.sendMessage(message);
        }
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    private void returnSendSmSToPersons(Context ctx) throws BOSException, EASBizException {
        ArticlePoolCollection apColl = this.getArticlePool(ctx);
        if (apColl != null && apColl.size() > 0) {
            String billNumber = null;
            String materialName = null;
            Date returnDate = null;
            PersonInfo pInfo = null;
            int days = 0;
            int n = apColl.size();
            for (int i = 0; i < n; ++i) {
                if (apColl.get(i).getReturnDate() == null || (days = (int)(this.formateDate(returnDate = apColl.get(i).getReturnDate()).getTime() - this.formateDate(Calendar.getInstance().getTime()).getTime()) / 86400000) > 3) continue;
                String content = null;
                pInfo = new PersonInfo();
                materialName = apColl.get(i).getMaterialsRecord().getName();
                billNumber = apColl.get(i).getNumber();
                pInfo = apColl.get(i).getApplicant();
                String receiver = this.getCellNumberStr(ctx, pInfo);
                if (receiver == null || "".equals(receiver)) continue;
                Locale locale = SysContext.getSysContext().getLocale();
                content = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.cp.cpmm.CPMMResource", (String)"RETURN_MSG", (Locale)locale), billNumber, materialName);
                this.sendSMS(ctx, content, receiver);
            }
        }
    }

    private String getCellNumberStr(Context ctx, PersonInfo pInfo) throws BOSException {
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("email"));
        evi.getSelector().add(new SelectorItemInfo("cell"));
        PersonCollection pc = ip.getPersonCollection(evi);
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        PersonInfo person = null;
        int size = pc.size();
        for (int i = 0; i < size; ++i) {
            person = pc.get(i);
            if (person.getCell() == null || person.getCell().trim().length() == 0) continue;
            map.put(person.getCell(), person.getCell());
        }
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    private void sendSMS(Context ctx, String content, String receiver) throws BOSException, EASBizException {
        SendMessageParamInfo paramInfo = new SendMessageParamInfo();
        paramInfo.setAppendCompanyName(false);
        paramInfo.setAppendNumber(false);
        paramInfo.setAppendPersonName(false);
        paramInfo.setAppendRevert(false);
        paramInfo.setAppendUserName(false);
        paramInfo.setContent(content);
        paramInfo.setReceiver(receiver);
        paramInfo.setCanback(false);
        IMsgFacade iMsgFacade = MsgFacadeFactory.getLocalInstance((Context)ctx);
        iMsgFacade.sendMsg(paramInfo);
    }

    private void returnSendMailToPersons(Context ctx) throws BOSException, EASBizException {
        ArticlePoolCollection apColl = this.getArticlePool(ctx);
        if (apColl != null && apColl.size() > 0) {
            String secretReceiver = null;
            String copyReceiver = null;
            KDMessageAttachment[] attachment = null;
            Date returnDate = null;
            String billNumber = null;
            String materialName = null;
            PersonInfo pInfo = null;
            int days = 0;
            int n = apColl.size();
            for (int i = 0; i < n; ++i) {
                if (apColl.get(i).getReturnDate() == null || (days = (int)(this.formateDate(returnDate = apColl.get(i).getReturnDate()).getTime() - this.formateDate(Calendar.getInstance().getTime()).getTime()) / 86400000) > 3) continue;
                String mailContent = null;
                String mailTitle = null;
                pInfo = new PersonInfo();
                billNumber = apColl.get(i).getNumber();
                materialName = apColl.get(i).getMaterialsRecord().getName();
                pInfo = apColl.get(i).getApplicant();
                String receiver = ArticlePoolControllerBean.getMailPersonStr(ctx, pInfo);
                if (receiver == null || "".equals(receiver)) continue;
                Locale locale = SysContext.getSysContext().getLocale();
                mailTitle = mailContent = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.cp.cpmm.CPMMResource", (String)"RETURN_MSG", (Locale)locale), billNumber, materialName);
                this.sendMail(ctx, mailTitle, mailContent, receiver, secretReceiver, copyReceiver, attachment);
            }
        }
    }

    public static String getMailPersonStr(Context ctx, PersonInfo pInfo) throws BOSException {
        String retStr = "";
        StringBuffer sb = new StringBuffer();
        if (pInfo != null) {
            IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
            evi.setFilter(filter);
            evi.getSelector().add(new SelectorItemInfo("email"));
            PersonCollection pc = ip.getPersonCollection(evi);
            int size = pc.size();
            for (int i = 0; i < size; ++i) {
                String mail = pc.get(i).getEmail();
                if (mail == null || mail.trim().length() == 0) continue;
                sb.append(mail).append(",");
            }
        }
        return (retStr = sb.toString()).length() <= 0 ? retStr : retStr.substring(0, retStr.length() - 1);
    }

    private void sendMail(Context ctx, String title, String content, String receiver, String secretReceiver, String copyReceiver, KDMessageAttachment[] attachment) throws BOSException, EASBizException {
        MsgUtil.msgMailDerect((Context)ctx, (String)title, (String)content, (String)receiver, (String)secretReceiver, (String)copyReceiver, (KDMessageAttachment[])attachment);
    }

    private Date formateDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.set(9, 0);
        return c.getTime();
    }
}

